/*
 * Decompiled with CFR 0.152.
 */
package org.forester.clade_analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.forester.clade_analysis.Prefix;
import org.forester.util.ForesterUtil;
import org.forester.util.UserException;

public final class ResultMulti {
    private static final double MIN_DIFF = 1.0E-5;
    private final String _separator;
    private final List<Prefix> _greatest_common_prefixes = new ArrayList<Prefix>();
    private final List<Prefix> _greatest_common_prefixes_up = new ArrayList<Prefix>();
    private final List<Prefix> _greatest_common_prefixes_down = new ArrayList<Prefix>();
    private List<Prefix> _all = null;
    private List<Prefix> _collapsed = null;
    private List<Prefix> _cleaned_spec = null;
    private boolean _has_specifics = false;
    private List<Prefix> _all_up = null;
    private List<Prefix> _collapsed_up = null;
    private List<Prefix> _cleaned_spec_up = null;
    private boolean _has_specifics_up = false;
    private List<Prefix> _all_down = null;
    private List<Prefix> _collapsed_down = null;
    private List<Prefix> _cleaned_spec_down = null;
    private boolean _has_specifics_down = false;
    private int _matches = 0;
    private int _ref_tree_ext_nodes = 0;
    private String _query_name_prefix = "";

    ResultMulti(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("separator must not be null or empty");
        }
        this._separator = string;
        this.reset();
    }

    ResultMulti() {
        this._separator = ".";
        this.reset();
    }

    public List<Prefix> getAllMultiHitPrefixesUp() {
        return this._all_up;
    }

    public List<Prefix> getCollapsedMultiHitPrefixesUp() {
        return this._collapsed_up;
    }

    public List<Prefix> getSpecificMultiHitPrefixesUp() {
        return this._cleaned_spec_up;
    }

    public boolean isHasSpecificMultiHitsPrefixesUp() {
        return this._has_specifics_up;
    }

    public List<Prefix> getAllMultiHitPrefixesDown() {
        return this._all_down;
    }

    public List<Prefix> getCollapsedMultiHitPrefixesDown() {
        return this._collapsed_down;
    }

    public List<Prefix> getSpecificMultiHitPrefixesDown() {
        return this._cleaned_spec_down;
    }

    public boolean isHasSpecificMultiHitsPrefixesDown() {
        return this._has_specifics_down;
    }

    public List<Prefix> getAllMultiHitPrefixes() {
        return this._all;
    }

    public List<Prefix> getCollapsedMultiHitPrefixes() {
        return this._collapsed;
    }

    public List<Prefix> getSpecificMultiHitPrefixes() {
        return this._cleaned_spec;
    }

    public boolean isHasSpecificMultiHitsPrefixes() {
        return this._has_specifics;
    }

    public String getQueryNamePrefix() {
        return this._query_name_prefix;
    }

    public int getNumberOfMatches() {
        return this._matches;
    }

    public int getReferenceTreeNumberOfExternalNodes() {
        return this._ref_tree_ext_nodes;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Query: ");
        stringBuilder.append(this.getQueryNamePrefix());
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        stringBuilder.append("Matching Clade(s):");
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        for (Prefix prefix : this._collapsed) {
            stringBuilder.append(prefix);
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        }
        if (this._has_specifics) {
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            stringBuilder.append("Specific-hit(s):");
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            for (Prefix prefix : this._cleaned_spec) {
                stringBuilder.append(prefix);
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            stringBuilder.append("Matching Clade(s) with Specific-hit(s):");
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            for (Prefix prefix : this._collapsed) {
                stringBuilder.append(prefix);
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                for (Prefix prefix2 : this._cleaned_spec) {
                    if (!prefix2.getPrefix().startsWith(prefix.getPrefix())) continue;
                    stringBuilder.append("    " + prefix2);
                    stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
        }
        if (!ForesterUtil.isEmpty(this._all_down)) {
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            stringBuilder.append("Matching Down-tree Bracketing Clade(s):");
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            for (Prefix prefix : this._collapsed_down) {
                stringBuilder.append(prefix);
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (!ForesterUtil.isEmpty(this._all_up)) {
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            stringBuilder.append("Matching Up-tree Bracketing Clade(s):");
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            for (Prefix prefix : this._collapsed_up) {
                stringBuilder.append(prefix);
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
        }
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        stringBuilder.append("Total Number of Matches: " + this.getNumberOfMatches() + "/" + this.getReferenceTreeNumberOfExternalNodes());
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    void addGreatestCommonPrefix(String string, double d) {
        this._greatest_common_prefixes.add(new Prefix(string, d, this._separator));
    }

    void addGreatestCommonPrefixUp(String string, double d) {
        this._greatest_common_prefixes_up.add(new Prefix(string, d, this._separator));
    }

    void addGreatestCommonPrefixDown(String string, double d) {
        this._greatest_common_prefixes_down.add(new Prefix(string, d, this._separator));
    }

    void setQueryNamePrefix(String string) {
        if (!ForesterUtil.isEmpty(this._query_name_prefix)) {
            throw new IllegalStateException("illegal attempt to change the query name prefix");
        }
        this._query_name_prefix = string;
    }

    void setTotalNumberOfMatches(int n) {
        if (this._matches > 0) {
            throw new IllegalStateException("illegal attempt to change the number of matches");
        }
        this._matches = n;
    }

    public void setReferenceTreeNumberOfExternalNodes(int n) {
        if (this._ref_tree_ext_nodes > 0) {
            throw new IllegalStateException("illegal attempt to change the number of external nodes");
        }
        this._ref_tree_ext_nodes = n;
    }

    final void analyze(double d) throws UserException {
        this.reset();
        this.analyzeGreatestCommonPrefixes(this._greatest_common_prefixes, this._separator, d);
        this.analyzeGreatestCommonPrefixesUp(this._greatest_common_prefixes_up, this._separator, d);
        this.analyzeGreatestCommonPrefixesDown(this._greatest_common_prefixes_down, this._separator, d);
    }

    private final void reset() {
        this._all = new ArrayList<Prefix>();
        this._collapsed = new ArrayList<Prefix>();
        this._cleaned_spec = new ArrayList<Prefix>();
        this._has_specifics = false;
        this._all_up = new ArrayList<Prefix>();
        this._collapsed_up = new ArrayList<Prefix>();
        this._cleaned_spec_up = new ArrayList<Prefix>();
        this._has_specifics_up = false;
        this._all_down = new ArrayList<Prefix>();
        this._collapsed_down = new ArrayList<Prefix>();
        this._cleaned_spec_down = new ArrayList<Prefix>();
        this._has_specifics_down = false;
    }

    private final void analyzeGreatestCommonPrefixes(List<Prefix> list, String string, double d) throws UserException {
        List<Prefix> list2 = ResultMulti.obtainAllPrefixes(list, string);
        if (!ForesterUtil.isEmpty(list2)) {
            ResultMulti.sortPrefixesAccordingToConfidence(list2);
            this._all = ResultMulti.removeLessSpecificPrefixes(list2, string);
            this._collapsed = ResultMulti.collapse(this._all);
            this._has_specifics = false;
            if (d >= 0.0) {
                this._cleaned_spec = ResultMulti.obtainSpecifics(d, this._all, this._collapsed, string);
                if (!ForesterUtil.isEmpty(this._cleaned_spec)) {
                    this._has_specifics = true;
                }
            }
        }
    }

    private final void analyzeGreatestCommonPrefixesUp(List<Prefix> list, String string, double d) throws UserException {
        List<Prefix> list2 = ResultMulti.obtainAllPrefixes(list, string);
        if (!ForesterUtil.isEmpty(list2)) {
            ResultMulti.sortPrefixesAccordingToConfidence(list2);
            this._all_up = ResultMulti.removeLessSpecificPrefixes(list2, string);
            this._collapsed_up = ResultMulti.collapse(this._all_up);
            this._has_specifics_up = false;
            if (d >= 0.0) {
                this._cleaned_spec_up = ResultMulti.obtainSpecifics(d, this._all_up, this._collapsed_up, string);
                if (!ForesterUtil.isEmpty(this._cleaned_spec_up)) {
                    this._has_specifics_up = true;
                }
            }
        }
    }

    final void analyzeGreatestCommonPrefixesDown(List<Prefix> list, String string, double d) throws UserException {
        List<Prefix> list2 = ResultMulti.obtainAllPrefixes(list, string);
        if (!ForesterUtil.isEmpty(list2)) {
            ResultMulti.sortPrefixesAccordingToConfidence(list2);
            this._all_down = ResultMulti.removeLessSpecificPrefixes(list2, string);
            this._collapsed_down = ResultMulti.collapse(this._all_down);
            this._has_specifics_down = false;
            if (d >= 0.0) {
                this._cleaned_spec_down = ResultMulti.obtainSpecifics(d, this._all_down, this._collapsed_down, string);
                if (!ForesterUtil.isEmpty(this._cleaned_spec_down)) {
                    this._has_specifics_down = true;
                }
            }
        }
    }

    static final List<Prefix> obtainSpecifics(double d, List<Prefix> list, List<Prefix> list2, String string) {
        ArrayList<Prefix> arrayList = new ArrayList<Prefix>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Prefix iterator2 : list2) {
            hashSet.add(iterator2.getPrefix());
        }
        ArrayList arrayList2 = new ArrayList();
        for (Prefix prefix : list) {
            if (!(prefix.getConfidence() >= d) || hashSet.contains(prefix.getPrefix())) continue;
            arrayList2.add(prefix);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Prefix prefix;
            prefix = (Prefix)iterator.next();
            boolean bl = true;
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                Prefix prefix2 = (Prefix)iterator2.next();
                if (prefix.getPrefix().equals(prefix2.getPrefix()) || !ForesterUtil.isContainsPrefix(prefix2.getPrefix(), prefix.getPrefix(), string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(prefix);
        }
        return arrayList;
    }

    private static final List<Prefix> collapse(List<Prefix> list) throws UserException {
        ArrayList<Prefix> arrayList = new ArrayList<Prefix>();
        HashSet<String> hashSet = new HashSet<String>();
        double d = 0.0;
        for (Prefix prefix : list) {
            String string = prefix.getPrefixFirstElement();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            arrayList.add(prefix);
            d += prefix.getConfidence();
        }
        if (!ForesterUtil.isEqual(d, 1.0, 1.0E-5)) {
            throw new UserException("confidences add up to " + d + " instead of 1.0");
        }
        return arrayList;
    }

    private static final List<Prefix> removeLessSpecificPrefixes(List<Prefix> list, String string) {
        ArrayList<Prefix> arrayList = new ArrayList<Prefix>();
        for (Prefix prefix : list) {
            boolean bl = true;
            for (Prefix prefix2 : list) {
                if (prefix.getPrefix().equals(prefix2.getPrefix()) || !ForesterUtil.isContainsPrefix(prefix2.getPrefix(), prefix.getPrefix(), string) || !ForesterUtil.isEqual(prefix2.getConfidence(), prefix.getConfidence())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(prefix);
        }
        return arrayList;
    }

    private static final void sortPrefixesAccordingToConfidence(List<Prefix> list) {
        Collections.sort(list, new Comparator<Prefix>(){

            @Override
            public int compare(Prefix prefix, Prefix prefix2) {
                return this.compare(prefix.getConfidence(), prefix2.getConfidence());
            }

            @Override
            private int compare(double d, double d2) {
                return d > d2 ? -1 : (d > d2 ? 1 : 0);
            }
        });
    }

    private static final List<Prefix> obtainAllPrefixes(List<Prefix> list, String string) {
        TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
        for (Prefix iterator : list) {
            Map.Entry entry = ForesterUtil.spliIntoPrefixes(iterator.getPrefix(), string);
            Iterator<String> iterator2 = entry.iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                treeMap.put(string2, 0.0);
            }
        }
        for (String string3 : treeMap.keySet()) {
            for (Prefix prefix : list) {
                if (!ForesterUtil.isContainsPrefix(prefix.getPrefix(), string3, string)) continue;
                treeMap.put(string3, (Double)treeMap.get(string3) + prefix.getConfidence());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : treeMap.entrySet()) {
            arrayList.add(new Prefix((String)entry.getKey(), (Double)entry.getValue(), string));
        }
        return arrayList;
    }
}

