/*
 * Decompiled with CFR 0.152.
 */
package org.forester.clade_analysis;

import java.io.File;
import org.forester.clade_analysis.AnalysisMulti;
import org.forester.clade_analysis.ResultMulti;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class CladeAnalysisDemo {
    private static final String PATH_TO_TEST_DATA = System.getProperty("user.dir") + ForesterUtil.getFileSeparator() + "test_data" + ForesterUtil.getFileSeparator();

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (!CladeAnalysisDemo.testCladeAnalysis1()) {
            System.out.println("Demo 1 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis2()) {
            System.out.println("Demo 2 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis3()) {
            System.out.println("Demo 3 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis4()) {
            System.out.println("Demo 4 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis5()) {
            System.out.println("Demo 5 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis6()) {
            System.out.println("Demo 6 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis7()) {
            System.out.println("Demo 7 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis8()) {
            System.out.println("Demo 8 failed");
            bl = true;
        }
        if (!CladeAnalysisDemo.testCladeAnalysis9()) {
            System.out.println("Demo 9 failed");
            bl = true;
        }
        if (!bl) {
            System.out.println("OK");
        } else {
            System.out.println("NOT OK");
        }
    }

    private static boolean testCladeAnalysis1() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_1.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 1:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis2() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_2.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 2:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis3() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_3.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 3:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis4() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_4.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 4:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis5() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_5.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 5:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis6() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_6.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 6:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis7() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_7.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 7:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis8() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_8.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 8:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis9() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "cladinator_demo_9.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, 0.5);
            System.out.println("DEMO 9:");
            System.out.println("+++++++");
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

