/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.File;
import org.forester.archaeopteryx.Configuration;

public final class InferenceManager {
    private static final String[] DEFAULT_PATHS = new String[]{"C:\\Program Files\\mafft-win\\", "C:\\Program Files\\", "C:\\Program Files (x86)\\", "/bin/", "/usr/local/bin/", "/usr/bin/"};
    private final File _path_to_local_mafft;
    private final File _path_to_local_fastme;
    private final File _path_to_local_raxml;

    public static InferenceManager createInstance(Configuration configuration) {
        return new InferenceManager(configuration.getPathToLocalMafft(), configuration.getPathToLocalFastme(), configuration.getPathToLocalRaxml());
    }

    public boolean canDoMsa() {
        return this.getPathToLocalMafft() != null;
    }

    public File getPathToLocalMafft() {
        return this._path_to_local_mafft;
    }

    public File getPathToLocalFastme() {
        return this._path_to_local_fastme;
    }

    public File getPathToLocalRaxml() {
        return this._path_to_local_raxml;
    }

    private static final File createLocalPath(File file, String string) {
        if (file != null && file.canExecute() && !file.isDirectory()) {
            return file;
        }
        File file2 = new File(string);
        if (file2.canExecute() && !file2.isDirectory()) {
            return file2;
        }
        for (String string2 : DEFAULT_PATHS) {
            try {
                File file3 = new File(string2 + string);
                if (file3.canExecute() && !file3.isDirectory()) {
                    return file3;
                }
                File file4 = new File(string2 + string + ".exe");
                if (file4.canExecute() && !file4.isDirectory()) {
                    return file4;
                }
                File file5 = new File(string2 + string + ".bat");
                if (!file5.canExecute() || file5.isDirectory()) continue;
                return file5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private InferenceManager(File file, File file2, File file3) {
        this._path_to_local_mafft = InferenceManager.createLocalPath(file, "mafft");
        this._path_to_local_fastme = InferenceManager.createLocalPath(file2, "fastme");
        this._path_to_local_raxml = InferenceManager.createLocalPath(file3, "raxml");
    }
}

