/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.InferenceManager;
import org.forester.archaeopteryx.tools.PhyloInferenceDialog;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.archaeopteryx.tools.PhylogeneticInferrer;
import org.forester.archaeopteryx.tools.SequenceDataRetriver;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.msa.MsaFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class MainFrameApplication
extends MainFrame {
    private static final int FRAME_X_SIZE = 900;
    private static final int FRAME_Y_SIZE = 900;
    private static final long serialVersionUID = -799735726778865234L;
    private static final boolean PREPROCESS_TREES = false;
    private final JFileChooser _values_filechooser;
    private final JFileChooser _sequences_filechooser;
    private final JFileChooser _open_filechooser;
    private final JFileChooser _msa_filechooser;
    private final JFileChooser _seqs_pi_filechooser;
    private final JFileChooser _open_filechooser_for_species_tree;
    private JMenuItem _collapse_below_threshold;
    private JMenuItem _collapse_below_branch_length;
    private ButtonGroup _radio_group_1;
    private ButtonGroup _radio_group_2;
    double _min_not_collapse = 50.0;
    double _min_not_collapse_bl = 0.001;
    private JMenu _inference_menu;
    private JMenuItem _inference_from_msa_item;
    private JMenuItem _inference_from_seqs_item;
    private PhylogeneticInferenceOptions _phylogenetic_inference_options = null;
    private Msa _msa = null;
    private File _msa_file = null;
    private List<MolecularSequence> _seqs = null;
    private File _seqs_file = null;
    JMenuItem _read_values_jmi;
    JMenuItem _read_seqs_jmi;

    private MainFrameApplication(Phylogeny[] phylogenyArray, Configuration configuration) {
        this._configuration = configuration;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = null;
        this._open_filechooser_for_species_tree = null;
        this._save_filechooser = null;
        this._writetopdf_filechooser = null;
        this._writetographics_filechooser = null;
        this._msa_filechooser = null;
        this._seqs_pi_filechooser = null;
        this._values_filechooser = null;
        this._sequences_filechooser = null;
        this._jmenubar = new JMenuBar();
        this.buildFileMenu();
        this.buildTypeMenu();
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(900, 900);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrameApplication.this.exit();
            }
        });
        if (phylogenyArray != null && phylogenyArray.length > 0) {
            AptxUtil.addPhylogeniesToTabs(phylogenyArray, "", null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this._contentpane.repaint();
    }

    private MainFrameApplication(Phylogeny[] phylogenyArray, Configuration configuration, String string) {
        this(phylogenyArray, configuration, string, null);
    }

    private MainFrameApplication(Phylogeny[] phylogenyArray, Configuration configuration, String string, File file) {
        this._configuration = configuration;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        try {
            if (this._configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            AptxUtil.dieWithSystemError("unsupported look and feel: " + unsupportedLookAndFeelException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            AptxUtil.dieWithSystemError("class not found exception: " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            AptxUtil.dieWithSystemError("instantiation exception: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            AptxUtil.dieWithSystemError("illegal access exception: " + illegalAccessException.toString());
        }
        if (file != null && file.canRead() && file.isDirectory()) {
            this.setCurrentDir(file);
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this.setInferenceManager(InferenceManager.createInstance(this._configuration));
        this.setPhylogeneticInferenceOptions(PhylogeneticInferenceOptions.createInstance(this._configuration));
        this.setTitle("Archaeopteryx 0.9928 beta (180705)");
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = new JFileChooser();
        this._open_filechooser.setMultiSelectionEnabled(true);
        this._open_filechooser.addChoosableFileFilter(MainFrame.xmlfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nhxfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nhfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.nexusfilter);
        this._open_filechooser.addChoosableFileFilter(MainFrame.tolfilter);
        this._open_filechooser.addChoosableFileFilter(this._open_filechooser.getAcceptAllFileFilter());
        this._open_filechooser.setFileFilter(MainFrame.defaultfilter);
        this._open_filechooser_for_species_tree = new JFileChooser();
        this._open_filechooser_for_species_tree.setMultiSelectionEnabled(false);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(MainFrame.xmlfilter);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(MainFrame.tolfilter);
        this._open_filechooser_for_species_tree.setFileFilter(MainFrame.xmlfilter);
        this._msa_filechooser = new JFileChooser();
        this._msa_filechooser.setName("Read Multiple Sequence Alignment File");
        this._msa_filechooser.setMultiSelectionEnabled(false);
        this._msa_filechooser.addChoosableFileFilter(this._msa_filechooser.getAcceptAllFileFilter());
        this._msa_filechooser.addChoosableFileFilter(MainFrame.msafilter);
        this._seqs_pi_filechooser = new JFileChooser();
        this._seqs_pi_filechooser.setName("Read Sequences File");
        this._seqs_pi_filechooser.setMultiSelectionEnabled(false);
        this._seqs_pi_filechooser.addChoosableFileFilter(this._seqs_pi_filechooser.getAcceptAllFileFilter());
        this._seqs_pi_filechooser.addChoosableFileFilter(MainFrame.seqsfilter);
        this._values_filechooser = new JFileChooser();
        this._values_filechooser.setMultiSelectionEnabled(false);
        this._sequences_filechooser = new JFileChooser();
        this._sequences_filechooser.setMultiSelectionEnabled(false);
        try {
            String string2 = System.getProperty("user.home");
            this._open_filechooser.setCurrentDirectory(new File(string2));
            this._open_filechooser_for_species_tree.setCurrentDirectory(new File(string2));
            this._msa_filechooser.setCurrentDirectory(new File(string2));
            this._seqs_pi_filechooser.setCurrentDirectory(new File(string2));
            this._values_filechooser.setCurrentDirectory(new File(string2));
            this._sequences_filechooser.setCurrentDirectory(new File(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._jmenubar = new JMenuBar();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
        }
        this.buildFileMenu();
        this.buildPhylogeneticInferenceMenu();
        this.buildAnalysisMenu();
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._jmenubar.add(this._help_jmenu);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(900, 900);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n;
                int n2;
                if (MainFrameApplication.this.isUnsavedDataPresent() ? (n2 = JOptionPane.showConfirmDialog(null, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0 : (n = JOptionPane.showConfirmDialog(null, "Exit Archaeopteryx?", "Exit?", 0)) != 0) {
                    return;
                }
                MainFrameApplication.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (MainFrameApplication.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplication.this._mainpanel.getCurrentTreePanel().calcParametersForPainting(MainFrameApplication.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplication.this._mainpanel.getCurrentTreePanel().getHeight());
                }
            }
        });
        this.requestFocusInWindow();
        this.setVisible(true);
        if (phylogenyArray != null && phylogenyArray.length > 0) {
            AptxUtil.addPhylogeniesToTabs(phylogenyArray, string, null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this.activateSaveAllIfNeeded();
        this._contentpane.repaint();
        System.gc();
    }

    private MainFrameApplication(Phylogeny[] phylogenyArray, String string, String string2) {
        this(phylogenyArray, new Configuration(string, false, false, true), string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            super.actionPerformed(actionEvent);
            Object object = actionEvent.getSource();
            if (object == this._open_item) {
                this.readPhylogeniesFromFile();
            }
            if (object == this._open_url_item) {
                this.readPhylogeniesFromURL();
            } else if (object == this._new_item) {
                this.newTree();
            } else if (object == this._close_item) {
                this.closeCurrentPane();
            } else if (object == this._load_species_tree_item) {
                this.readSpeciesTreeFromFile();
            } else if (object == this._obtain_detailed_taxonomic_information_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.obtainDetailedTaxonomicInformation();
            } else if (object == this._obtain_detailed_taxonomic_information_deleting_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.obtainDetailedTaxonomicInformationDelete();
            } else if (object == this._obtain_seq_information_jmi) {
                this.obtainSequenceInformation();
            } else if (object == this._read_values_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.addExpressionValuesFromFile();
            } else if (object == this._read_seqs_jmi) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.addSequencesFromFile();
            } else if (object == this._move_node_names_to_tax_sn_jmi) {
                this.moveNodeNamesToTaxSn();
            } else if (object == this._move_node_names_to_seq_names_jmi) {
                this.moveNodeNamesToSeqNames();
            } else if (object == this._extract_tax_code_from_node_names_jmi) {
                this.extractTaxDataFromNodeNames();
            } else if (object == this._internal_number_are_confidence_for_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._replace_underscores_cbmi) {
                if (this._extract_taxonomy_no_rbmi != null && !this._extract_taxonomy_no_rbmi.isSelected()) {
                    this._extract_taxonomy_no_rbmi.setSelected(true);
                }
                this.updateOptions(this.getOptions());
            } else if (object == this._allow_errors_in_distance_to_parent_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._collapse_below_threshold) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.collapseBelowThreshold();
            } else if (object == this._collapse_below_branch_length) {
                if (this.isSubtreeDisplayed()) {
                    return;
                }
                this.collapseBelowBranchLengthThreshold();
            } else if (object == this._extract_taxonomy_pfam_strict_rbmi || object == this._extract_taxonomy_pfam_relaxed_rbmi || object == this._extract_taxonomy_agressive_rbmi) {
                if (this._replace_underscores_cbmi != null) {
                    this._replace_underscores_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            } else if (object == this._extract_taxonomy_no_rbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._inference_from_msa_item) {
                this.executePhyleneticInference(false);
            } else if (object == this._inference_from_seqs_item) {
                this.executePhyleneticInference(true);
            }
            this._contentpane.repaint();
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        catch (Error error) {
            AptxUtil.unexpectedError(error);
        }
    }

    public void end() {
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public Msa getMsa() {
        return this._msa;
    }

    public File getMsaFile() {
        return this._msa_file;
    }

    public List<MolecularSequence> getSeqs() {
        return this._seqs;
    }

    public File getSeqsFile() {
        return this._seqs_file;
    }

    public void readMsaFromFile() {
        File file = this.getCurrentDir();
        this._msa_filechooser.setMultiSelectionEnabled(false);
        if (file != null) {
            this._msa_filechooser.setCurrentDirectory(file);
        }
        int n = this._msa_filechooser.showOpenDialog(this._contentpane);
        File file2 = this._msa_filechooser.getSelectedFile();
        this.setCurrentDir(this._msa_filechooser.getCurrentDirectory());
        if (file2 != null && !file2.isDirectory() && n == 0) {
            this.setMsaFile(null);
            this.setMsa(null);
            Msa msa = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                msa = FastaParser.isLikelyFasta(file2) ? FastaParser.parseMsa(fileInputStream) : GeneralMsaParser.parseMsa(fileInputStream);
            }
            catch (MsaFormatException msaFormatException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, msaFormatException.getLocalizedMessage(), "Multiple sequence alignment format error", 0);
                return;
            }
            catch (IOException iOException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "Failed to read multiple sequence alignment", 0);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, illegalArgumentException.getLocalizedMessage(), "Unexpected error during reading of multiple sequence alignment", 0);
                return;
            }
            catch (Exception exception) {
                this.setArrowCursor();
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Unexpected error during reading of multiple sequence alignment", 0);
                return;
            }
            if (msa == null || msa.getNumberOfSequences() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment is empty", "Illegal Multiple Sequence Alignment", 0);
                return;
            }
            if (msa.getNumberOfSequences() < 4) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment needs to contain at least 3 sequences", "Illegal multiple sequence alignment", 0);
                return;
            }
            if (msa.getLength() < 2) {
                JOptionPane.showMessageDialog(this, "Multiple sequence alignment needs to contain at least 2 residues", "Illegal multiple sequence alignment", 0);
                return;
            }
            System.gc();
            this.setMsaFile(this._msa_filechooser.getSelectedFile());
            this.setMsa(msa);
        }
    }

    public void readSeqsFromFileforPI() {
        File file = this.getCurrentDir();
        this._seqs_pi_filechooser.setMultiSelectionEnabled(false);
        if (file != null) {
            this._seqs_pi_filechooser.setCurrentDirectory(file);
        }
        int n = this._seqs_pi_filechooser.showOpenDialog(this._contentpane);
        File file2 = this._seqs_pi_filechooser.getSelectedFile();
        this.setCurrentDir(this._seqs_pi_filechooser.getCurrentDirectory());
        if (file2 != null && !file2.isDirectory() && n == 0) {
            this.setSeqsFile(null);
            this.setSeqs(null);
            List<MolecularSequence> list = null;
            try {
                if (FastaParser.isLikelyFasta(new FileInputStream(file2))) {
                    list = FastaParser.parse(new FileInputStream(file2));
                    for (MolecularSequence molecularSequence : list) {
                        System.out.println(SequenceWriter.toFasta(molecularSequence, 60));
                    }
                }
            }
            catch (MsaFormatException msaFormatException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, msaFormatException.getLocalizedMessage(), "Multiple sequence file format error", 0);
                return;
            }
            catch (IOException iOException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "Failed to read multiple sequence file", 0);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, illegalArgumentException.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            catch (Exception exception) {
                this.setArrowCursor();
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            if (list == null || list.size() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file is empty", "Illegal multiple sequence file", 0);
                return;
            }
            if (list.size() < 4) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file needs to contain at least 3 sequences", "Illegal multiple sequence file", 0);
                return;
            }
            System.gc();
            this.setSeqsFile(this._seqs_pi_filechooser.getSelectedFile());
            this.setSeqs(list);
        }
    }

    private void addExpressionValuesFromFile() {
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null) {
            JOptionPane.showMessageDialog(this, "Need to load evolutionary tree first", "Can Not Read Expression Values", 2);
            return;
        }
        File file = this.getCurrentDir();
        if (file != null) {
            this._values_filechooser.setCurrentDirectory(file);
        }
        int n = this._values_filechooser.showOpenDialog(this._contentpane);
        File file2 = this._values_filechooser.getSelectedFile();
        if (file2 != null && file2.length() > 0L && n == 0) {
            BasicTable<String> basicTable = null;
            try {
                basicTable = BasicTableParser.parse(file2, '\t');
                if (basicTable.getNumberOfColumns() < 2) {
                    basicTable = BasicTableParser.parse(file2, ',');
                }
                if (basicTable.getNumberOfColumns() < 2) {
                    basicTable = BasicTableParser.parse(file2, ' ');
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Could Not Read Expression Value Table", 0);
                return;
            }
            if (basicTable.getNumberOfColumns() < 2) {
                JOptionPane.showMessageDialog(this, "Table contains " + basicTable.getNumberOfColumns() + " column(s)", "Problem with Expression Value Table", 0);
                return;
            }
            if (basicTable.getNumberOfRows() < 1) {
                JOptionPane.showMessageDialog(this, "Table contains zero rows", "Problem with Expression Value Table", 0);
                return;
            }
            Phylogeny phylogeny = this.getCurrentTreePanel().getPhylogeny();
            if (basicTable.getNumberOfRows() != phylogeny.getNumberOfExternalNodes()) {
                JOptionPane.showMessageDialog(this, "Table contains " + basicTable.getNumberOfRows() + " rows, but tree contains " + phylogeny.getNumberOfExternalNodes() + " external nodes", "Warning", 2);
            }
            BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
            int n2 = 0;
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                String string = phylogenyNode.getName();
                if (ForesterUtil.isEmpty(string)) continue;
                int n3 = -1;
                try {
                    n3 = basicTable.findRow(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Error Mapping Node Identifiers to Expression Value Identifiers", 0);
                    return;
                }
                if (n3 < 0) {
                    if (!phylogenyNode.isExternal()) continue;
                    ++n2;
                    continue;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (int i = 1; i < basicTable.getNumberOfColumns(); ++i) {
                    double d = -100.0;
                    try {
                        d = Double.parseDouble(basicTable.getValueAsString(i, n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(this, "Could not parse \"" + basicTable.getValueAsString(i, n3) + "\" into a decimal value", "Issue with Expression Value Table", 0);
                        return;
                    }
                    basicDescriptiveStatistics.addValue(d);
                    arrayList.add(d);
                }
                if (arrayList.isEmpty()) continue;
                phylogenyNode.getNodeData().setVector(arrayList);
            }
            if (n2 > 0) {
                JOptionPane.showMessageDialog(this, "Could not fine expression values for " + n2 + " external node(s)", "Warning", 2);
            }
            this.getCurrentTreePanel().setStatisticsForExpressionValues(basicDescriptiveStatistics);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addSequencesFromFile() {
        Object object;
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null) {
            JOptionPane.showMessageDialog(this, "Need to load evolutionary tree first", "Can Not Read Sequences", 2);
            return;
        }
        File file = this.getCurrentDir();
        if (file != null) {
            this._sequences_filechooser.setCurrentDirectory(file);
        }
        int n = this._sequences_filechooser.showOpenDialog(this._contentpane);
        File file2 = this._sequences_filechooser.getSelectedFile();
        List<MolecularSequence> list = null;
        if (file2 != null && !file2.isDirectory() && n == 0) {
            try {
                object = new FileInputStream(file2);
                if (FastaParser.isLikelyFasta((InputStream)object)) {
                    FileInputStream object2 = new FileInputStream(file2);
                    list = FastaParser.parse(object2);
                    try {
                        object2.close();
                    }
                    catch (Exception exception) {}
                } else {
                    JOptionPane.showMessageDialog(this, "Format does not appear to be Fasta", "Multiple sequence file format error", 0);
                    return;
                }
                try {
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {}
            }
            catch (MsaFormatException msaFormatException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, msaFormatException.getLocalizedMessage(), "Multiple sequence file format error", 0);
                return;
            }
            catch (IOException iOException) {
                this.setArrowCursor();
                JOptionPane.showMessageDialog(this, iOException.getLocalizedMessage(), "Failed to read multiple sequence file", 0);
                return;
            }
            catch (Exception exception) {
                this.setArrowCursor();
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Unexpected error during reading of multiple sequence file", 0);
                return;
            }
            if (list == null || list.size() < 1) {
                JOptionPane.showMessageDialog(this, "Multiple sequence file is empty", "Empty multiple sequence file", 0);
                this.setArrowCursor();
                return;
            }
        }
        if (list != null) {
            Object object2;
            Object object3;
            void var6_15;
            for (MolecularSequence molecularSequence : list) {
                System.out.println(molecularSequence.getIdentifier());
            }
            object = this.getCurrentTreePanel().getPhylogeny();
            boolean bl = false;
            int n2 = 0;
            for (MolecularSequence molecularSequence : list) {
                Object object4;
                ++var6_15;
                object3 = molecularSequence.getIdentifier();
                if (ForesterUtil.isEmpty((String)object3)) continue;
                object2 = ((Phylogeny)object).getNodesViaSequenceName((String)object3);
                if (object2.isEmpty()) {
                    object2 = ((Phylogeny)object).getNodesViaSequenceSymbol((String)object3);
                }
                if (object2.isEmpty()) {
                    object2 = ((Phylogeny)object).getNodesViaGeneName((String)object3);
                }
                if (object2.isEmpty()) {
                    object2 = ((Phylogeny)object).getNodes((String)object3);
                }
                if (object2.size() > 1) {
                    JOptionPane.showMessageDialog(this, "Sequence name \"" + (String)object3 + "\" is not unique", "Sequence name not unique", 0);
                    this.setArrowCursor();
                    return;
                }
                String[] stringArray = ((String)object3).split("\\s");
                if (object2.isEmpty() && stringArray.length > 1) {
                    object4 = stringArray[0];
                    object2 = ((Phylogeny)object).getNodesViaSequenceName((String)object4);
                    if (object2.isEmpty()) {
                        object2 = ((Phylogeny)object).getNodesViaSequenceSymbol((String)object4);
                    }
                    if (object2.isEmpty()) {
                        object2 = ((Phylogeny)object).getNodes((String)object4);
                    }
                    if (object2.size() > 1) {
                        JOptionPane.showMessageDialog(this, "Split sequence name \"" + (String)object4 + "\" is not unique", "Sequence name not unique", 0);
                        this.setArrowCursor();
                        return;
                    }
                }
                if (object2.size() != 1) continue;
                ++n2;
                object4 = object2.get(0);
                if (!((PhylogenyNode)object4).getNodeData().isHasSequence()) {
                    ((PhylogenyNode)object4).getNodeData().addSequence(new Sequence());
                }
                ((PhylogenyNode)object4).getNodeData().getSequence().setMolecularSequence(molecularSequence.getMolecularSequenceAsString());
                if (!ForesterUtil.isEmpty(((PhylogenyNode)object4).getNodeData().getSequence().getName())) continue;
                ((PhylogenyNode)object4).getNodeData().getSequence().setName((String)object3);
            }
            if (n2 > 0) {
                int n3 = 0;
                int n4 = 0;
                object3 = ((Phylogeny)object).iteratorExternalForward();
                while (object3.hasNext()) {
                    ++n3;
                    object2 = object3.next();
                    if (!((PhylogenyNode)object2).getNodeData().isHasSequence() || ForesterUtil.isEmpty(((PhylogenyNode)object2).getNodeData().getSequence().getMolecularSequence())) continue;
                    ++n4;
                }
                object3 = n3 == n4 ? "All " + n4 + " external nodes now have a molecular sequence attached to them." : n4 + " out of " + n3 + " external nodes now have a molecular sequence attached to them.";
                if (n2 == var6_15 && n3 == n4) {
                    JOptionPane.showMessageDialog(this, "Attached all " + (int)var6_15 + " sequences to tree nodes.\n" + (String)object3, "All sequences attached", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Attached " + n2 + " sequences out of a total of " + (int)var6_15 + " sequences.\n" + (String)object3, n2 + " sequences attached", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No maching tree node for any of the " + (int)var6_15 + " sequences", "Could not attach any sequences", 0);
            }
        }
    }

    private void closeCurrentPane() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            int n;
            if (this.getMainPanel().getCurrentTreePanel().isEdited() && (n = JOptionPane.showConfirmDialog(this, "Close tab despite potentially unsaved changes?", "Close Tab?", 0)) != 0) {
                return;
            }
            this.getMainPanel().closeCurrentPane();
            this.activateSaveAllIfNeeded();
        }
    }

    private void collapseBelowThreshold(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d = Double.MAX_VALUE;
        boolean bl = false;
        while (phylogenyNodeIterator.hasNext()) {
            Object object;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || (object = phylogenyNode.getBranchData().getConfidences()) == null || object.size() <= 0) continue;
            bl = true;
            double d2 = 0.0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Confidence confidence = (Confidence)iterator.next();
                if (!(confidence.getValue() > d2)) continue;
                d2 = confidence.getValue();
            }
            if (d2 < this.getMinNotCollapseConfidenceValue()) {
                arrayList.add(phylogenyNode);
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        if (bl) {
            for (Object object : arrayList) {
                PhylogenyMethods.removeNode((PhylogenyNode)object, phylogeny);
            }
            if (arrayList.size() > 0) {
                phylogeny.externalNodesHaveChanged();
                phylogeny.clearHashIdToNodeMap();
                phylogeny.recalculateNumberOfExternalDescendants(true);
                this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                this.getCurrentTreePanel().calculateLongestExtNodeInfo();
                this.getCurrentTreePanel().setNodeInPreorderToNull();
                this.getCurrentTreePanel().recalculateMaxDistanceToRoot();
                this.getCurrentTreePanel().resetPreferredSize();
                this.getCurrentTreePanel().setEdited(true);
                this.getCurrentTreePanel().repaint();
                this.repaint();
            }
            if (arrayList.size() > 0) {
                JOptionPane.showMessageDialog(this, "Collapsed " + arrayList.size() + " branches with\nconfidence values below " + this.getMinNotCollapseConfidenceValue(), "Collapsed " + arrayList.size() + " branches", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No branch collapsed,\nminimum confidence value per branch is " + d, "No branch collapsed", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No branch collapsed because no confidence values present", "No confidence values present", 1);
        }
    }

    private void collapseBelowBranchLengthThreshold() {
        String string;
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty() && !ForesterUtil.isEmpty(string = (String)JOptionPane.showInputDialog(this, "Please enter the minimum branch length value\n", "Minimal Branch Length Value", 3, null, null, this.getMinNotCollapseBlValue()))) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.setMinNotCollapseBlValue(d);
                this.collapseBl(phylogeny);
            }
        }
    }

    private void collapseBelowThreshold() {
        String string;
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty() && !ForesterUtil.isEmpty(string = (String)JOptionPane.showInputDialog(this, "Please enter the minimum confidence value\n", "Minimal Confidence Value", 3, null, null, this.getMinNotCollapseConfidenceValue()))) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.setMinNotCollapseConfidenceValue(d);
                this.collapseBelowThreshold(phylogeny);
            }
        }
    }

    private void collapseBl(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d = Double.MAX_VALUE;
        boolean bl = false;
        while (phylogenyNodeIterator.hasNext()) {
            double d2;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || (d2 = phylogenyNode.getDistanceToParent()) == -1024.0) continue;
            bl = true;
            if (d2 < this.getMinNotCollapseBlValue()) {
                arrayList.add(phylogenyNode);
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        if (bl) {
            for (PhylogenyNode phylogenyNode : arrayList) {
                PhylogenyMethods.removeNode(phylogenyNode, phylogeny);
            }
            if (arrayList.size() > 0) {
                phylogeny.externalNodesHaveChanged();
                phylogeny.clearHashIdToNodeMap();
                phylogeny.recalculateNumberOfExternalDescendants(true);
                this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                this.getCurrentTreePanel().calculateLongestExtNodeInfo();
                this.getCurrentTreePanel().setNodeInPreorderToNull();
                this.getCurrentTreePanel().recalculateMaxDistanceToRoot();
                this.getCurrentTreePanel().resetPreferredSize();
                this.getCurrentTreePanel().setEdited(true);
                this.getCurrentTreePanel().repaint();
                this.repaint();
            }
            if (arrayList.size() > 0) {
                JOptionPane.showMessageDialog(this, "Collapsed " + arrayList.size() + " branches with\nbranch length values below " + this.getMinNotCollapseBlValue(), "Collapsed " + arrayList.size() + " branches", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No branch collapsed,\nminimum branch length is " + d, "No branch collapsed", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No branch collapsed because no branch length values present", "No branch length values present", 1);
        }
    }

    private PhyloXmlParser createPhyloXmlParser() {
        PhyloXmlParser phyloXmlParser = null;
        if (this.getConfiguration().isValidatePhyloXmlAgainstSchema()) {
            try {
                phyloXmlParser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "failed to create validating XML parser", 2);
            }
        }
        if (phyloXmlParser == null) {
            phyloXmlParser = PhyloXmlParser.createPhyloXmlParser();
        }
        return phyloXmlParser;
    }

    private void executePhyleneticInference(boolean bl) {
        PhyloInferenceDialog phyloInferenceDialog = new PhyloInferenceDialog(this, this.getPhylogeneticInferenceOptions(), bl);
        phyloInferenceDialog.activate();
        if (phyloInferenceDialog.getValue() == 0) {
            if (!bl) {
                if (this.getMsa() != null) {
                    PhylogeneticInferrer phylogeneticInferrer = new PhylogeneticInferrer(this.getMsa(), this.getPhylogeneticInferenceOptions().copy(), this);
                    new Thread(phylogeneticInferrer).start();
                } else {
                    JOptionPane.showMessageDialog(this, "No multiple sequence alignment selected", "Phylogenetic Inference Not Launched", 2);
                }
            } else if (this.getSeqs() != null) {
                PhylogeneticInferrer phylogeneticInferrer = new PhylogeneticInferrer(this.getSeqs(), this.getPhylogeneticInferenceOptions().copy(), this);
                new Thread(phylogeneticInferrer).start();
            } else {
                JOptionPane.showMessageDialog(this, "No input sequences selected", "Phylogenetic Inference Not Launched", 2);
            }
        }
    }

    private void extractTaxDataFromNodeNames() throws PhyloXmlDataFormatException {
        Phylogeny phylogeny;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        int n2 = 0;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            String string;
            Object object;
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                object = phylogenyNodeIterator.next();
                string = ((PhylogenyNode)object).getName().trim();
                if (ForesterUtil.isEmpty(string)) continue;
                String string2 = ParserUtils.extractTaxonomyDataFromNodeName((PhylogenyNode)object, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                if (!ForesterUtil.isEmpty(string2)) {
                    if (n < 15) {
                        stringBuilder.append(string + ": " + string2 + "\n");
                    } else if (n == 15) {
                        stringBuilder.append("...\n");
                    }
                    ++n;
                    continue;
                }
                if (n2 < 15) {
                    stringBuilder2.append(string + "\n");
                } else if (n2 == 15) {
                    stringBuilder2.append("...\n");
                }
                ++n2;
            }
            if (n > 0) {
                object = "";
                string = "all ";
                if (n2 > 0) {
                    string = "";
                    object = "\nCould not extract taxonomic data for " + n2 + " named external nodes:\n" + stringBuilder2;
                }
                JOptionPane.showMessageDialog(this, "Extracted taxonomic data from " + string + n + " named external nodes:\n" + stringBuilder.toString() + (String)object, "Taxonomic Data Extraction Completed", n2 > 0 ? 2 : 1);
            } else {
                JOptionPane.showMessageDialog(this, "Could not extract any taxonomic data.\nMaybe node names are empty\nor not in the forms \"XYZ_CAEEL\", \"XYZ_6239\", or \"XYZ_Caenorhabditis_elegans\"\nor nodes already have taxonomic data?\n", "No Taxonomic Data Extracted", 0);
            }
        }
    }

    private double getMinNotCollapseBlValue() {
        return this._min_not_collapse_bl;
    }

    private double getMinNotCollapseConfidenceValue() {
        return this._min_not_collapse;
    }

    private PhylogeneticInferenceOptions getPhylogeneticInferenceOptions() {
        if (this._phylogenetic_inference_options == null) {
            this._phylogenetic_inference_options = new PhylogeneticInferenceOptions();
        }
        return this._phylogenetic_inference_options;
    }

    private boolean isUnsavedDataPresent() {
        List<TreePanel> list = this.getMainPanel().getTreePanels();
        for (TreePanel treePanel : list) {
            if (!treePanel.isEdited()) continue;
            return true;
        }
        return false;
    }

    private void moveNodeNamesToSeqNames() throws PhyloXmlDataFormatException {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.SEQUENCE_NAME, false);
        }
    }

    private void moveNodeNamesToTaxSn() throws PhyloXmlDataFormatException {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, false);
        }
    }

    private void newTree() {
        Phylogeny[] phylogenyArray = new Phylogeny[1];
        Phylogeny phylogeny = new Phylogeny();
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(true);
        phylogenyArray[0] = phylogeny;
        AptxUtil.addPhylogeniesToTabs(phylogenyArray, "", "", this.getConfiguration(), this.getMainPanel());
        this._mainpanel.getControlPanel().showWhole();
        this._mainpanel.getCurrentTreePanel().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this._mainpanel.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void obtainDetailedTaxonomicInformation() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            TaxonomyDataManager taxonomyDataManager = new TaxonomyDataManager(this, this._mainpanel.getCurrentTreePanel(), phylogeny.copy(), false, true);
            new Thread(taxonomyDataManager).start();
        }
    }

    private void obtainDetailedTaxonomicInformationDelete() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            TaxonomyDataManager taxonomyDataManager = new TaxonomyDataManager(this, this._mainpanel.getCurrentTreePanel(), phylogeny.copy(), true, true);
            new Thread(taxonomyDataManager).start();
        }
    }

    private void obtainSequenceInformation() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            SequenceDataRetriver sequenceDataRetriver = new SequenceDataRetriver(this, this._mainpanel.getCurrentTreePanel(), phylogeny.copy());
            new Thread(sequenceDataRetriver).start();
        }
    }

    private void preProcessTreesUponReading(Phylogeny[] phylogenyArray) {
        for (Phylogeny phylogeny : phylogenyArray) {
            if (phylogeny == null || phylogeny.isEmpty()) continue;
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                Sequence sequence;
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (!phylogenyNode.isExternal() || !phylogenyNode.getNodeData().isHasSequence() || !ForesterUtil.isEmpty((sequence = phylogenyNode.getNodeData().getSequence()).getGeneName()) && !sequence.getGeneName().startsWith("LOC")) continue;
                if (sequence.getAccession() != null && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
                    sequence.setGeneName(sequence.getAccession().getValue());
                    continue;
                }
                if (ForesterUtil.isEmpty(phylogenyNode.getName())) continue;
                sequence.setGeneName(phylogenyNode.getName());
            }
        }
    }

    private void readPhylogeniesFromFile() {
        boolean bl = false;
        Phylogeny[] phylogenyArray = null;
        File file = this.getCurrentDir();
        if (file != null) {
            this._open_filechooser.setCurrentDirectory(file);
        }
        int n = this._open_filechooser.showOpenDialog(this._contentpane);
        File[] fileArray = this._open_filechooser.getSelectedFiles();
        this.setCurrentDir(this._open_filechooser.getCurrentDirectory());
        boolean bl2 = false;
        if (fileArray != null && fileArray.length > 0 && n == 0) {
            for (File file2 : fileArray) {
                if (file2 == null || file2.isDirectory()) continue;
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                if (this._open_filechooser.getFileFilter() == MainFrame.nhfilter || this._open_filechooser.getFileFilter() == MainFrame.nhxfilter) {
                    try {
                        NHXParser nHXParser = new NHXParser();
                        this.setSpecialOptionsForNhxParser(nHXParser);
                        phylogenyArray = PhylogenyMethods.readPhylogenies((PhylogenyParser)nHXParser, file2);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.xmlfilter) {
                    MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                    try {
                        PhyloXmlParser phyloXmlParser = this.createPhyloXmlParser();
                        phylogenyArray = PhylogenyMethods.readPhylogenies((PhylogenyParser)phyloXmlParser, file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.tolfilter) {
                    try {
                        phylogenyArray = PhylogenyMethods.readPhylogenies((PhylogenyParser)new TolParser(), file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == MainFrame.nexusfilter) {
                    try {
                        NexusPhylogeniesParser nexusPhylogeniesParser = new NexusPhylogeniesParser();
                        this.setSpecialOptionsForNexParser(nexusPhylogeniesParser);
                        phylogenyArray = PhylogenyMethods.readPhylogenies((PhylogenyParser)nexusPhylogeniesParser, file2);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else {
                    try {
                        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file2, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                        if (phylogenyParser instanceof NexusPhylogeniesParser) {
                            NexusPhylogeniesParser nexusPhylogeniesParser = (NexusPhylogeniesParser)phylogenyParser;
                            this.setSpecialOptionsForNexParser(nexusPhylogeniesParser);
                            bl2 = true;
                        } else if (phylogenyParser instanceof NHXParser) {
                            NHXParser nHXParser = (NHXParser)phylogenyParser;
                            this.setSpecialOptionsForNhxParser(nHXParser);
                            bl2 = true;
                        } else if (phylogenyParser instanceof PhyloXmlParser) {
                            MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                        }
                        phylogenyArray = PhylogenyMethods.readPhylogenies(phylogenyParser, file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
                if (bl || phylogenyArray == null || phylogenyArray.length <= 0) continue;
                boolean bl3 = false;
                if (bl2) {
                    for (Phylogeny phylogeny : phylogenyArray) {
                        if (this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                            PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "");
                        }
                        if (PhylogenyMethods.getMinimumDescendentsPerInternalNodes(phylogeny) != 1) continue;
                        bl3 = true;
                        break;
                    }
                }
                AptxUtil.addPhylogeniesToTabs(phylogenyArray, file2.getName(), file2.getAbsolutePath(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
                if (!bl2 || !bl3) continue;
                JOptionPane.showMessageDialog(this, "One or more trees contain (a) node(s) with one descendant, " + ForesterUtil.LINE_SEPARATOR + "possibly indicating illegal parentheses within node names.", "Warning: Possible Error in New Hampshire Formatted Data", 2);
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void readSpeciesTreeFromFile() {
        Phylogeny phylogeny = null;
        boolean bl = false;
        File file = this.getCurrentDir();
        this._open_filechooser_for_species_tree.setSelectedFile(new File(""));
        if (file != null) {
            this._open_filechooser_for_species_tree.setCurrentDirectory(file);
        }
        int n = this._open_filechooser_for_species_tree.showOpenDialog(this._contentpane);
        File file2 = this._open_filechooser_for_species_tree.getSelectedFile();
        if (file2 != null && n == 0) {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            try {
                phylogeny = phylogenyFactory.create(file2, ParserUtils.createParserDependingOnFileType(file2, true))[0];
            }
            catch (Exception exception) {
                bl = true;
                this.exceptionOccuredDuringOpenFile(exception);
            }
            if (!bl && phylogeny != null && !phylogeny.isRooted()) {
                bl = true;
                phylogeny = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted", "Species tree not loaded", 0);
            }
            if (!bl && phylogeny != null) {
                HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
                PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
                while (phylogenyNodeIterator.hasNext()) {
                    PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        bl = true;
                        phylogeny = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains external node(s) without taxonomy information", "Species tree not loaded", 0);
                        break;
                    }
                    if (hashSet.contains(phylogenyNode.getNodeData().getTaxonomy())) {
                        bl = true;
                        phylogeny = null;
                        JOptionPane.showMessageDialog(this, "Taxonomy [" + phylogenyNode.getNodeData().getTaxonomy().asSimpleText() + "] is not unique in species tree", "Species tree not loaded", 0);
                        break;
                    }
                    hashSet.add(phylogenyNode.getNodeData().getTaxonomy());
                }
            }
            if (!bl && phylogeny != null) {
                this.setSpeciesTree(phylogeny);
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded", "Species tree loaded", 1);
            }
            this._contentpane.repaint();
            System.gc();
        }
    }

    private void setArrowCursor() {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMinNotCollapseBlValue(double d) {
        this._min_not_collapse_bl = d;
    }

    private void setMinNotCollapseConfidenceValue(double d) {
        this._min_not_collapse = d;
    }

    private void setPhylogeneticInferenceOptions(PhylogeneticInferenceOptions phylogeneticInferenceOptions) {
        this._phylogenetic_inference_options = phylogeneticInferenceOptions;
    }

    private void setSpecialOptionsForNexParser(NexusPhylogeniesParser nexusPhylogeniesParser) {
        nexusPhylogeniesParser.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nexusPhylogeniesParser.setTaxonomyExtraction(this.getOptions().getTaxonomyExtraction());
        nexusPhylogeniesParser.setParseBeastStyleExtendedTags(this.getOptions().isParseBeastStyleExtendedNexusTags());
    }

    private void setSpecialOptionsForNhxParser(NHXParser nHXParser) {
        nHXParser.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nHXParser.setTaxonomyExtraction(this.getOptions().getTaxonomyExtraction());
        nHXParser.setAllowErrorsInDistanceToParent(this.getOptions().isAllowErrorsInDistanceToParent());
        nHXParser.setParseBeastStyleExtendedTags(this.getOptions().isParseBeastStyleExtendedNexusTags());
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        this._gsdi_item = new JMenuItem("GSDI (Generalized Speciation Duplication Inference)");
        this._analysis_menu.add(this._gsdi_item);
        this._gsdir_item = new JMenuItem("GSDIR (GSDI with re-rooting)");
        this._analysis_menu.add(this._gsdir_item);
        this._load_species_tree_item = new JMenuItem("Load Species Tree...");
        this._analysis_menu.add(this._load_species_tree_item);
        this.customizeJMenuItem(this._gsdi_item);
        this.customizeJMenuItem(this._gsdir_item);
        this.customizeJMenuItem(this._load_species_tree_item);
        this._analysis_menu.addSeparator();
        this._lineage_inference = new JMenuItem("Infer Ancestor Taxonomies");
        this._analysis_menu.add(this._lineage_inference);
        this.customizeJMenuItem(this._lineage_inference);
        this._lineage_inference.setToolTipText("Inference of ancestor taxonomies/lineages");
        this._jmenubar.add(this._analysis_menu);
    }

    @Override
    void buildFileMenu() {
        int n;
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_item = new JMenuItem("Read Tree from File...");
        this._file_jmenu.add(this._open_item);
        this._file_jmenu.addSeparator();
        this._open_url_item = new JMenuItem("Read Tree from URL/Webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        WebservicesManager webservicesManager = WebservicesManager.getInstance();
        this._load_phylogeny_from_webservice_menu_items = new JMenuItem[webservicesManager.getAvailablePhylogeniesWebserviceClients().size()];
        for (n = 0; n < webservicesManager.getAvailablePhylogeniesWebserviceClients().size(); ++n) {
            PhylogeniesWebserviceClient phylogeniesWebserviceClient = webservicesManager.getAvailablePhylogeniesWebserviceClient(n);
            this._load_phylogeny_from_webservice_menu_items[n] = new JMenuItem(phylogeniesWebserviceClient.getMenuName());
            this._file_jmenu.add(this._load_phylogeny_from_webservice_menu_items[n]);
        }
        if (this.getConfiguration().isEditable()) {
            this._file_jmenu.addSeparator();
            this._new_item = new JMenuItem("New");
            this._file_jmenu.add(this._new_item);
            this._new_item.setToolTipText("to create a new tree with one node, as source for manual tree construction");
        }
        this._file_jmenu.addSeparator();
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._save_all_item = new JMenuItem("Save All Trees As...");
        this._file_jmenu.add(this._save_all_item);
        this._save_all_item.setToolTipText("Write all phylogenies to one file.");
        this._save_all_item.setEnabled(false);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (AptxUtil.canWriteFormat("tif") || AptxUtil.canWriteFormat("tiff") || AptxUtil.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (AptxUtil.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (AptxUtil.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._close_item = new JMenuItem("Close Tab");
        this._file_jmenu.add(this._close_item);
        this._close_item.setToolTipText("To close the current pane.");
        this._close_item.setEnabled(true);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_item);
        this._open_item.setFont(new Font(this._open_item.getFont().getFontName(), 1, this._open_item.getFont().getSize() + 4));
        this.customizeJMenuItem(this._open_url_item);
        for (n = 0; n < webservicesManager.getAvailablePhylogeniesWebserviceClients().size(); ++n) {
            this.customizeJMenuItem(this._load_phylogeny_from_webservice_menu_items[n]);
        }
        this.customizeJMenuItem(this._save_item);
        if (this.getConfiguration().isEditable()) {
            this.customizeJMenuItem(this._new_item);
        }
        this.customizeJMenuItem(this._close_item);
        this.customizeJMenuItem(this._save_all_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplication.this._overview_placment_mi, MainFrameApplication.this.getOptions());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplication.this._switch_colors_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplication.this._choose_minimal_confidence_mi, MainFrameApplication.this.getOptions(), MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplication.this._choose_font_mi, MainFrame.createCurrentFontDesc(MainFrameApplication.this.getMainPanel().getTreeFontSet()));
                MainFrame.setTextForPdfLineWidthChooserMenuItem(MainFrameApplication.this._choose_pdf_width_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleNodeFillMenuItem(MainFrameApplication.this._cycle_node_fill_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleNodeShapeMenuItem(MainFrameApplication.this._cycle_node_shape_mi, MainFrameApplication.this.getOptions());
                MainFrame.setCycleDataReturnMenuItem(MainFrameApplication.this._cycle_data_return, MainFrameApplication.this.getOptions());
                MainFrame.setTextNodeSizeMenuItem(MainFrameApplication.this._choose_node_size_mi, MainFrameApplication.this.getOptions());
                try {
                    MainFrameApplication.this.getMainPanel().getControlPanel().setVisibilityOfDomainStrucureCB();
                    MainFrameApplication.this.getMainPanel().getControlPanel().setVisibilityOfX();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("Lined Up Cladogram");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladogram");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_default_node_shapes_internal_cbmi = new JCheckBoxMenuItem("Shapes for Internal Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_internal_cbmi);
        this._show_default_node_shapes_external_cbmi = new JCheckBoxMenuItem("Shapes for External Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_external_cbmi);
        this._show_default_node_shapes_for_marked_cbmi = new JCheckBoxMenuItem("Shapes for Nodes with Visual Data");
        this._options_jmenu.add(this._show_default_node_shapes_for_marked_cbmi);
        this._collapsed_with_average_height_cbmi = new JCheckBoxMenuItem("Proportional Height of Collapsed Subtrees");
        this._options_jmenu.add(this._collapsed_with_average_height_cbmi);
        this._show_abbreviated_labels_for_collapsed_nodes_cbmi = new JCheckBoxMenuItem("Add Abbreviated Labels to Collapsed Subtrees");
        this._options_jmenu.add(this._show_abbreviated_labels_for_collapsed_nodes_cbmi);
        this._line_up_renderable_data_cbmi = new JCheckBoxMenuItem("Line Up Diagrams (such as Domain Architectures)");
        this._options_jmenu.add(this._line_up_renderable_data_cbmi);
        if (this.getConfiguration().doDisplayOption(10)) {
            this._right_line_up_domains_cbmi = new JCheckBoxMenuItem("Right-align Domain Architectures");
            this._options_jmenu.add(this._right_line_up_domains_cbmi);
            this._show_domain_labels = new JCheckBoxMenuItem("Domain Labels");
            this._options_jmenu.add(this._show_domain_labels);
        }
        this._show_annotation_ref_source = new JCheckBoxMenuItem("Seq Annotation Ref Sources");
        this._options_jmenu.add(this._show_annotation_ref_source);
        this._show_confidence_stddev_cbmi = new JCheckBoxMenuItem("Confidence Standard Deviations");
        this._options_jmenu.add(this._show_confidence_stddev_cbmi);
        this._color_by_taxonomic_group_cbmi = new JCheckBoxMenuItem("Colorize by Taxonomic Group");
        this._options_jmenu.add(this._color_by_taxonomic_group_cbmi);
        this._color_labels_same_as_parent_branch = new JCheckBoxMenuItem("Colorize Labels Same as Parent Branch");
        this._options_jmenu.add(this._color_labels_same_as_parent_branch);
        this._color_labels_same_as_parent_branch.setToolTipText("To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent");
        this._abbreviate_scientific_names = new JCheckBoxMenuItem("Abbreviate Scientific Taxonomic Names");
        this._options_jmenu.add(this._abbreviate_scientific_names);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._cycle_node_shape_mi = new JMenuItem("Cycle Node Shapes");
        this._options_jmenu.add(this._cycle_node_shape_mi);
        this._cycle_node_fill_mi = new JMenuItem("Cycle Node Fill Type");
        this._options_jmenu.add(this._cycle_node_fill_mi);
        this._choose_node_size_mi = new JMenuItem("Choose Node Shape Size");
        this._options_jmenu.add(this._choose_node_size_mi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._cycle_data_return = new JMenuItem("Cycle Data Return");
        this._options_jmenu.add(this._cycle_data_return);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Match Case");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Words");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._search_with_regex_cbmi = new JCheckBoxMenuItem("Regex");
        this._options_jmenu.add(this._search_with_regex_cbmi);
        this._search_with_regex_cbmi.setToolTipText("To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.");
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Inverse");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._color_all_found_nodes_when_coloring_subtree_cbmi = new JCheckBoxMenuItem("Colorize All Found Nodes When Colorizing Subtree(s)");
        this._options_jmenu.add(this._color_all_found_nodes_when_coloring_subtree_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/NHX/Nexus Read:"), this.getConfiguration()));
        this._internal_number_are_confidence_for_nh_parsing_cbmi = new JCheckBoxMenuItem("Internal Node Names are Confidence Values");
        this._options_jmenu.add(this._internal_number_are_confidence_for_nh_parsing_cbmi);
        this._replace_underscores_cbmi = new JCheckBoxMenuItem("Replace Underscores with Spaces");
        this._options_jmenu.add(this._replace_underscores_cbmi);
        this._parse_beast_style_extended_nexus_tags_cbmi = new JCheckBoxMenuItem("Parse BEAST-style extended Newick/Nexus tags");
        this._options_jmenu.add(this._parse_beast_style_extended_nexus_tags_cbmi);
        this._parse_beast_style_extended_nexus_tags_cbmi.setToolTipText("to parse elements in the form of \"[&!color=#800080]\" in Newick/Nexus formatted trees");
        this._allow_errors_in_distance_to_parent_cbmi = new JCheckBoxMenuItem("Ignore Distance Values Format Errors");
        this._options_jmenu.add(this._allow_errors_in_distance_to_parent_cbmi);
        this._extract_taxonomy_no_rbmi = new JRadioButtonMenuItem("No Taxonomy Extraction");
        this._options_jmenu.add(this._extract_taxonomy_no_rbmi);
        this._extract_taxonomy_pfam_strict_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids from Pfam-style Node Names");
        this._options_jmenu.add(this._extract_taxonomy_pfam_strict_rbmi);
        this._extract_taxonomy_pfam_relaxed_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids from Pfam-style like Node Names");
        this._options_jmenu.add(this._extract_taxonomy_pfam_relaxed_rbmi);
        this._extract_taxonomy_agressive_rbmi = new JRadioButtonMenuItem("Extract Taxonomy Codes/Ids/Scientific Names from Node Names");
        this._options_jmenu.add(this._extract_taxonomy_agressive_rbmi);
        this._extract_taxonomy_pfam_strict_rbmi.setToolTipText("To extract taxonomy codes/ids from node names in the form of e.g. \"BCL2_MOUSE/123-304\" or \"BCL2_10090/123-304\"");
        this._extract_taxonomy_pfam_relaxed_rbmi.setToolTipText("To extract taxonomy codes/ids from node names in the form of e.g. \"bax_MOUSE\" or \"bax_10090\"");
        this._extract_taxonomy_agressive_rbmi.setToolTipText("To extract taxonomy codes/ids or scientific names from node names in the form of e.g. \"MOUSE\" or \"10090\" or \"xyz_Nematostella_vectensis\"");
        this._radio_group_2 = new ButtonGroup();
        this._radio_group_2.add(this._extract_taxonomy_no_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_pfam_strict_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_pfam_relaxed_rbmi);
        this._radio_group_2.add(this._extract_taxonomy_agressive_rbmi);
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/Nexus Save:"), this.getConfiguration()));
        this._use_brackets_for_conf_in_nh_export_cbmi = new JCheckBoxMenuItem("Use Brackets for Confidence Values");
        this._options_jmenu.add(this._use_brackets_for_conf_in_nh_export_cbmi);
        this._use_brackets_for_conf_in_nh_export_cbmi.setToolTipText("e.g. \"0.1[90]\" for a branch with support 90 and a length of 0.1");
        this._use_internal_names_for_conf_in_nh_export_cbmi = new JCheckBoxMenuItem("Use Internal Node Names for Confidence Values");
        this._options_jmenu.add(this._use_internal_names_for_conf_in_nh_export_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_external_cbmi, this.getOptions().isShowDefaultNodeShapesExternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_internal_cbmi, this.getOptions().isShowDefaultNodeShapesInternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_for_marked_cbmi, this.getOptions().isShowDefaultNodeShapesForMarkedNodes());
        this.customizeJMenuItem(this._cycle_node_shape_mi);
        this.customizeJMenuItem(this._cycle_node_fill_mi);
        this.customizeJMenuItem(this._choose_node_size_mi);
        this.customizeJMenuItem(this._cycle_data_return);
        this.customizeCheckBoxMenuItem(this._color_labels_same_as_parent_branch, this.getOptions().isColorLabelsSameAsParentBranch());
        this.customizeCheckBoxMenuItem(this._color_by_taxonomic_group_cbmi, this.getOptions().isColorByTaxonomicGroup());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._show_domain_labels, this.getOptions().isShowDomainLabels());
        this.customizeCheckBoxMenuItem(this._show_annotation_ref_source, this.getOptions().isShowAnnotationRefSource());
        this.customizeCheckBoxMenuItem(this._abbreviate_scientific_names, this.getOptions().isAbbreviateScientificTaxonNames());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeCheckBoxMenuItem(this._collapsed_with_average_height_cbmi, this.getOptions().isCollapsedWithAverageHeigh());
        this.customizeCheckBoxMenuItem(this._show_abbreviated_labels_for_collapsed_nodes_cbmi, this.getOptions().isShowAbbreviatedLabelsForCollapsedNodes());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.LINED_UP);
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._internal_number_are_confidence_for_nh_parsing_cbmi, this.getOptions().isInternalNumberAreConfidenceForNhParsing());
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_no_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.NO);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_pfam_strict_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_pfam_relaxed_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
        this.customizeRadioButtonMenuItem(this._extract_taxonomy_agressive_rbmi, this.getOptions().getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        this.customizeCheckBoxMenuItem(this._replace_underscores_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._allow_errors_in_distance_to_parent_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._search_with_regex_cbmi, this.getOptions().isSearchWithRegex());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._color_all_found_nodes_when_coloring_subtree_cbmi, this.getOptions().isColorAllFoundNodesWhenColoringSubtree());
        this.customizeCheckBoxMenuItem(this._parse_beast_style_extended_nexus_tags_cbmi, this.getOptions().isParseBeastStyleExtendedNexusTags());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._show_confidence_stddev_cbmi, this.getOptions().isShowConfidenceStddev());
        this.customizeCheckBoxMenuItem(this._use_brackets_for_conf_in_nh_export_cbmi, this.getOptions().getNhConversionSupportValueStyle() == PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS);
        this.customizeCheckBoxMenuItem(this._use_internal_names_for_conf_in_nh_export_cbmi, this.getOptions().getNhConversionSupportValueStyle() == PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES);
        this.customizeCheckBoxMenuItem(this._line_up_renderable_data_cbmi, this.getOptions().isLineUpRendarableNodeData());
        this.customizeCheckBoxMenuItem(this._right_line_up_domains_cbmi, this.getOptions().isRightLineUpDomains());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildPhylogeneticInferenceMenu() {
        InferenceManager inferenceManager = this.getInferenceManager();
        this._inference_menu = MainFrame.createMenu("Inference", this.getConfiguration());
        this._inference_from_msa_item = new JMenuItem("From Multiple Sequence Alignment...");
        this._inference_menu.add(this._inference_from_msa_item);
        this.customizeJMenuItem(this._inference_from_msa_item);
        this._inference_from_msa_item.setToolTipText("Basic phylogenetic inference from MSA");
        if (inferenceManager.canDoMsa()) {
            this._inference_from_seqs_item = new JMenuItem("From Unaligned Sequences...");
            this._inference_menu.add(this._inference_from_seqs_item);
            this.customizeJMenuItem(this._inference_from_seqs_item);
            this._inference_from_seqs_item.setToolTipText("Basic phylogenetic inference including multiple sequence alignment");
        } else {
            this._inference_from_seqs_item = new JMenuItem("From Unaligned Sequences (no program found)");
            this._inference_menu.add(this._inference_from_seqs_item);
            this.customizeJMenuItem(this._inference_from_seqs_item);
            this._inference_from_seqs_item.setEnabled(false);
        }
        this._jmenubar.add(this._inference_menu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrameApplication.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._color_rank_jmi = new JMenuItem("Colorize Subtrees via Taxonomic Rank");
        this._tools_menu.add(this._color_rank_jmi);
        this.customizeJMenuItem(this._color_rank_jmi);
        this._color_rank_jmi.setToolTipText("for example, at \"Class\" level, colorize mammal specific subtree red");
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._tools_menu.addSeparator();
        this._remove_visual_styles_item = new JMenuItem("Delete All Visual Styles From Nodes");
        this._tools_menu.add(this._remove_visual_styles_item);
        this._remove_visual_styles_item.setToolTipText("To remove all node visual styles (fonts, colors) from the current phylogeny");
        this.customizeJMenuItem(this._remove_visual_styles_item);
        this._remove_branch_color_item = new JMenuItem("Delete All Colors From Branches");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To remove all branch color values from the current phylogeny");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._annotate_item = new JMenuItem("Annotate Sequences of Selected Nodes");
        this._tools_menu.add(this._annotate_item);
        this.customizeJMenuItem(this._annotate_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._delete_selected_nodes_item = new JMenuItem("Delete Selected Nodes");
        this._tools_menu.add(this._delete_selected_nodes_item);
        this._delete_selected_nodes_item.setToolTipText("To delete all selected external nodes");
        this.customizeJMenuItem(this._delete_selected_nodes_item);
        this._delete_not_selected_nodes_item = new JMenuItem("Retain Selected Nodes");
        this._tools_menu.add(this._delete_not_selected_nodes_item);
        this._delete_not_selected_nodes_item.setToolTipText("To delete all not selected external nodes");
        this.customizeJMenuItem(this._delete_not_selected_nodes_item);
        this._tools_menu.addSeparator();
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Single Taxonomy-Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._collapse_species_specific_subtrees.setToolTipText("To (reversibly) collapse subtrees associated with only one taxonomy (such as species specific subtrees)");
        this._collapse_below_threshold = new JMenuItem("Collapse Branches with Confidence Below Threshold into Multifurcations");
        this._tools_menu.add(this._collapse_below_threshold);
        this.customizeJMenuItem(this._collapse_below_threshold);
        this._collapse_below_threshold.setToolTipText("To (permanently) collapse branches with confidence values below a threshold into multifurcations (in the case of multiple confidences per branch: without at least one confidence value above a threshold)");
        this._collapse_below_branch_length = new JMenuItem("Collapse Branches with Branch Lengths Below Threshold into Multifurcations");
        this._tools_menu.add(this._collapse_below_branch_length);
        this.customizeJMenuItem(this._collapse_below_branch_length);
        this._collapse_below_branch_length.setToolTipText("To (permanently) collapse branches with branches with branch lengths below a threshold into multifurcations");
        this._tools_menu.addSeparator();
        this._extract_tax_code_from_node_names_jmi = new JMenuItem("Extract Taxonomic Data from Node Names");
        this._tools_menu.add(this._extract_tax_code_from_node_names_jmi);
        this.customizeJMenuItem(this._extract_tax_code_from_node_names_jmi);
        this._extract_tax_code_from_node_names_jmi.setToolTipText("To extract SwissProt/Uniprot taxonomic codes (mnemonics) from nodes names in the form of 'xyz_CAEEL', Uniprot/NCBI identifiers form of 'xyz_6239', or scientific names form of 'xyz_Caenorhabditis_elegans'");
        this._move_node_names_to_tax_sn_jmi = new JMenuItem("Transfer Node Names to Taxonomic Scientific Names");
        this._tools_menu.add(this._move_node_names_to_tax_sn_jmi);
        this.customizeJMenuItem(this._move_node_names_to_tax_sn_jmi);
        this._move_node_names_to_tax_sn_jmi.setToolTipText("To interpret node names as taxonomic scientific names");
        this._move_node_names_to_seq_names_jmi = new JMenuItem("Transfer Node Names to Sequence Names");
        this._tools_menu.add(this._move_node_names_to_seq_names_jmi);
        this.customizeJMenuItem(this._move_node_names_to_seq_names_jmi);
        this._move_node_names_to_seq_names_jmi.setToolTipText("To interpret node names as sequence (protein, gene) names");
        this._tools_menu.addSeparator();
        this._obtain_seq_information_jmi = new JMenuItem("Obtain Sequence Information");
        this._tools_menu.add(this._obtain_seq_information_jmi);
        this.customizeJMenuItem(this._obtain_seq_information_jmi);
        this._obtain_seq_information_jmi.setToolTipText("To add additional sequence information");
        this._obtain_detailed_taxonomic_information_jmi = new JMenuItem("Obtain Detailed Taxonomic Information");
        this._tools_menu.add(this._obtain_detailed_taxonomic_information_jmi);
        this.customizeJMenuItem(this._obtain_detailed_taxonomic_information_jmi);
        this._obtain_detailed_taxonomic_information_jmi.setToolTipText("To add additional taxonomic information (from UniProt Taxonomy)");
        this._obtain_detailed_taxonomic_information_deleting_jmi = new JMenuItem("Obtain Detailed Taxonomic Information (deletes nodes!)");
        this._tools_menu.add(this._obtain_detailed_taxonomic_information_deleting_jmi);
        this.customizeJMenuItem(this._obtain_detailed_taxonomic_information_deleting_jmi);
        this._obtain_detailed_taxonomic_information_deleting_jmi.setToolTipText("To add additional taxonomic information, deletes nodes for which taxonomy cannot found (from UniProt Taxonomy)");
        this._tools_menu.addSeparator();
        this._read_values_jmi = new JMenuItem("Attach Vector/Expression Values");
        this._tools_menu.add(this._read_values_jmi);
        this.customizeJMenuItem(this._read_values_jmi);
        this._read_values_jmi.setToolTipText("To attach vector (e.g. gene expression) values to tree nodes (beta)");
        this._jmenubar.add(this._tools_menu);
        this._read_seqs_jmi = new JMenuItem("Attach Molecular Sequences");
        this._tools_menu.add(this._read_seqs_jmi);
        this.customizeJMenuItem(this._read_seqs_jmi);
        this._read_seqs_jmi.setToolTipText("To attach molecular sequences to tree nodes (from Fasta-formatted file) (beta)");
        this._jmenubar.add(this._tools_menu);
    }

    @Override
    void close() {
        int n;
        if (this.isUnsavedDataPresent() && (n = JOptionPane.showConfirmDialog(this, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0) {
            return;
        }
        this.exit();
    }

    void exit() {
        this.removeAllTextFrames();
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void readPhylogeniesFromURL() {
        URL uRL = null;
        Phylogeny[] phylogenyArray = null;
        String string = JOptionPane.showInputDialog(this, "Please enter a complete URL, for example \"http://purl.org/phylo/treebase/phylows/study/TB2:S15480?format=nexus\"", "Use URL/webservice to obtain a phylogeny", 3);
        boolean bl = false;
        if (string != null && string.length() > 0) {
            try {
                void exception;
                uRL = new URL(string);
                Object phylogenyParser = null;
                if (uRL.getHost().toLowerCase().indexOf("tolweb") >= 0) {
                    TolParser malformedURLException = new TolParser();
                } else {
                    PhylogenyParser iOException = ParserUtils.createParserDependingOnUrlContents(uRL, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                }
                if (exception instanceof NexusPhylogeniesParser) {
                    bl = true;
                } else if (exception instanceof NHXParser) {
                    bl = true;
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
                phylogenyArray = phylogenyFactory.create(uRL.openStream(), exception);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Malformed URL: " + uRL + "\n" + malformedURLException.getLocalizedMessage(), "Malformed URL", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Could not read from " + uRL + "\n" + ForesterUtil.wordWrap(iOException.getLocalizedMessage(), 80), "Failed to read URL", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(exception.getLocalizedMessage(), 80), "Unexpected Exception", 0);
            }
            finally {
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
            }
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                if (bl && this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                    for (Phylogeny phylogeny : phylogenyArray) {
                        PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "");
                    }
                }
                AptxUtil.addPhylogeniesToTabs(phylogenyArray, new File(uRL.getFile()).getName(), new File(uRL.getFile()).toString(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    void setMsa(Msa msa) {
        this._msa = msa;
    }

    void setMsaFile(File file) {
        this._msa_file = file;
    }

    void setSeqs(List<MolecularSequence> list) {
        this._seqs = list;
    }

    void setSeqsFile(File file) {
        this._seqs_file = file;
    }

    public static MainFrameApplication createInstance(Phylogeny[] phylogenyArray, Configuration configuration) {
        return new MainFrameApplication(phylogenyArray, configuration);
    }

    public static MainFrame createInstance(Phylogeny[] phylogenyArray, Configuration configuration, String string, File file) {
        return new MainFrameApplication(phylogenyArray, configuration, string, file);
    }

    static MainFrame createInstance(Phylogeny[] phylogenyArray, Configuration configuration, String string) {
        return new MainFrameApplication(phylogenyArray, configuration, string);
    }

    static MainFrame createInstance(Phylogeny[] phylogenyArray, String string, String string2) {
        return new MainFrameApplication(phylogenyArray, string, string2);
    }

    static void warnIfNotPhyloXmlValidation(Configuration configuration) {
        if (!configuration.isValidatePhyloXmlAgainstSchema()) {
            JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("phyloXML XSD-based validation is turned off [enable with line 'validate_against_phyloxml_xsd_schem: true' in configuration file]", 80), "Warning", 2);
        }
    }
}

