/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.ExtendedChart;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class ExtendedChartPanel
extends AbstractChartPanel {
    private boolean zoom_enabled = false;
    private int zoom_button = 1;
    private int autoscale_button = 3;
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private ExtendedChartPanel() {
    }

    public ExtendedChartPanel(ChartDataModel model, String title) {
        this();
        this.chart = new ExtendedChart(model, title);
    }

    public ExtendedChartPanel(ChartDataModel model, String title, int coord) {
        this();
        this.chart = new ExtendedChart(model, title, coord);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    @Override
    public void render(Graphics2D g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.zoom_enabled) {
            return;
        }
        this.updateSize(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.zoom_enabled) {
            return;
        }
        if (e.getButton() == this.zoom_button) {
            this.currentRect = new Rectangle(e.getX(), e.getY(), 0, 0);
            this.grRect = new Rectangle(e.getX(), e.getY(), 0, 0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.zoom_enabled) {
            return;
        }
        if (e.getButton() == this.zoom_button) {
            this.updateSize(e);
            if (this.chart instanceof ExtendedChart && this.grRect.getWidth() != 0.0 && this.grRect.getHeight() != 0.0) {
                ExtendedChart echart = (ExtendedChart)this.chart;
                echart.getChartDataModel().setAutoScale(false);
                echart.zoom(this.grRect);
            }
            this.currentRect = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.zoom_enabled) {
            return;
        }
        if (e.getButton() == this.autoscale_button) {
            this.performAutoScale();
        }
    }

    public void performAutoScale() {
        this.chart.getChartDataModel().setAutoScale(true);
        this.chart.getChartDataModel().fireChartDataModelChangedEvent(this);
        this.repaint();
    }

    public void enableZoom(boolean value) {
        this.zoom_enabled = value;
    }

    public boolean isEnableZoom() {
        return this.zoom_enabled;
    }

    public void setAutoscaleMouseButton(int button) {
        this.autoscale_button = button;
    }

    public void setZoomMouseButton(int button) {
        this.zoom_button = button;
    }

    private void updateSize(MouseEvent e) {
        if (this.currentRect == null || !this.zoom_enabled) {
            return;
        }
        int width = e.getX() - this.currentRect.x;
        int height = e.getY() - this.currentRect.y;
        this.currentRect.setSize(width, height);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + width), Math.min(this.currentRect.y, this.currentRect.y + height), Math.abs(width), Math.abs(height));
        } else {
            this.grRect.setSize(width, height);
        }
        this.repaint();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        int x = (int)pf.getImageableX();
        int y = (int)pf.getImageableY();
        this.chart.setBounds(new Rectangle(0, 0, (int)pf.getImageableWidth(), (int)pf.getImageableHeight()));
        g.translate(x, y);
        if (page == 0) {
            this.paint(g);
            this.repaint();
            return 0;
        }
        this.repaint();
        return 1;
    }
}

