/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StackedBarChartRenderer
extends AbstractChartRenderer {
    protected float boxWidth = 1.0f;

    public StackedBarChartRenderer(CoordSystem cs, AbstractChartDataModel model) {
        super(cs, model);
    }

    public StackedBarChartRenderer(CoordSystem cs, AbstractChartDataModel model, float boxWidth) {
        this(cs, model);
        this.boxWidth = boxWidth;
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ChartDataModel m = this.getChartDataModel();
        ChartDataModelConstraints con = m.getChartDataModelConstraints(0);
        System.out.println("** Maximum: " + con.getMaximumValue() + " Minimum: " + con.getMinimumValue());
        if (m.isColumnNumeric()) {
            return false;
        }
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = m.getDataSetNumber();
        int maximumDataSetLength = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.model.getDataSetNumber()) {
            maximumDataSetLength = Math.max(maximumDataSetLength, this.model.getDataSetLength(i));
            ++i;
        }
        Point2D pointzero = con.getMinimumValue().floatValue() > 0.0f ? yaxis1.transform(new Point2D.Float((float)con.getMinimumColumnValue(), con.getMinimumValue().floatValue()), null) : (con.getMaximumValue().floatValue() < 0.0f ? yaxis1.transform(new Point2D.Float((float)con.getMinimumColumnValue(), con.getMaximumValue().floatValue()), null) : yaxis1.transform(new Point2D.Float((float)con.getMinimumColumnValue(), 0.0f), null));
        Point2D point1 = yaxis1.transform(new Point2D.Float((float)con.getMinimumColumnValue(), con.getMaximumValue().floatValue()), null);
        Point2D point2 = yaxis1.transform(new Point2D.Float((float)con.getMaximumColumnValue(), con.getMaximumValue().floatValue()), null);
        Point2D value = point1;
        int dataunitwidth = (int)((point2.getX() - point1.getX()) / con.getMaximumColumnValue());
        int boxwidth = (int)((float)dataunitwidth * this.boxWidth);
        float margin = (float)((double)dataunitwidth * ((1.0 - (double)this.boxWidth) / 2.0));
        double currentvalue = 0.0;
        Rectangle2D.Float box = null;
        int j = 0;
        while (j < maximumDataSetLength && !this.getStopFlag()) {
            double minvalue = 0.0;
            double maxvalue = 0.0;
            Point2D oldmaxvalue = pointzero;
            Point2D oldminvalue = pointzero;
            int i2 = 0;
            while (i2 < m.getDataSetNumber() && !this.getStopFlag()) {
                currentvalue = j < m.getDataSetLength(i2) ? m.getValueAt(i2, j).doubleValue() : 0.0;
                if (currentvalue < 0.0) {
                    yaxis1.transform(new Point2D.Float(j, (float)(minvalue += currentvalue)), value);
                    box = new Rectangle2D.Float((float)value.getX(), (float)Math.min(value.getY(), oldminvalue.getY()), boxwidth, (float)Math.abs(oldminvalue.getY() - value.getY()));
                    oldminvalue = (Point2D)value.clone();
                } else {
                    yaxis1.transform(new Point2D.Float(j, (float)(maxvalue += currentvalue)), value);
                    box = new Rectangle2D.Float((float)value.getX(), (float)Math.min(value.getY(), oldmaxvalue.getY()), boxwidth, (float)Math.abs(oldmaxvalue.getY() - value.getY()));
                    oldmaxvalue = (Point2D)value.clone();
                }
                g.setColor(rcm.getColor(i2));
                g.fill(box);
                g.setColor(Color.black);
                g.draw(box);
                ++i2;
            }
            ++j;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

