/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.DataSet;
import com.approximatrix.charting.model.DefaultChartDataModelConstraints;
import com.approximatrix.charting.model.DefaultDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;

public class DefaultChartDataModel
extends AbstractChartDataModel {
    protected TreeSet columnSet = new TreeSet();
    protected ArrayList data = new ArrayList();
    protected HashMap valuesbyaxis = new HashMap();
    protected ChartDataModelConstraints constraints1;
    protected ChartDataModelConstraints constraints2;

    public DefaultChartDataModel() {
        TreeSet set1 = new TreeSet();
        this.valuesbyaxis.put(new Integer(0), set1);
        TreeSet set2 = new TreeSet();
        this.valuesbyaxis.put(new Integer(1), set2);
        this.constraints1 = new DefaultChartDataModelConstraints(this, 0);
        this.constraints2 = new DefaultChartDataModelConstraints(this, 1);
    }

    public DefaultChartDataModel(Number[][] data, double[] columns, String[] rows) {
        this();
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(columns)));
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, data);
        this.trimSet(set);
        int i = 0;
        while (i < data.length) {
            this.data.add(new DefaultDataSet(data[i], ChartUtilities.transformArray(columns), 0, rows[i]));
            ++i;
        }
    }

    public DefaultChartDataModel(int[][] data, double[] columns, String[] rows) {
        this();
        Number[][] numdata = ChartUtilities.transformArray(data);
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(columns)));
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, numdata);
        this.trimSet(set);
        int i = 0;
        while (i < data.length) {
            this.data.add(new DefaultDataSet(numdata[i], ChartUtilities.transformArray(columns), 0, rows[i]));
            ++i;
        }
    }

    public DefaultChartDataModel(double[][] data, double[] columns, String[] rows) {
        this();
        Number[][] numdata = ChartUtilities.transformArray(data);
        this.columnSet.addAll(Arrays.asList(ChartUtilities.transformArray(columns)));
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, numdata);
        this.trimSet(set);
        int i = 0;
        while (i < data.length) {
            this.data.add(new DefaultDataSet(numdata[i], ChartUtilities.transformArray(columns), 0, rows[i]));
            ++i;
        }
    }

    public DefaultChartDataModel(DataSet[] ds) {
        this();
        int i = 0;
        while (i < ds.length) {
            this.data.add(ds[i]);
            TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(ds[i].getYAxis()));
            int j = 0;
            while (j < ds[i].getDataSetLength()) {
                this.columnSet.add(ds[i].getColumnValueAt(j));
                set.add(ds[i].getValueAt(j));
                this.trimSet(set);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getDataSetLength(int set) {
        return ((DataSet)this.data.get(set)).getDataSetLength();
    }

    @Override
    public int getDataSetNumber() {
        return this.data.size();
    }

    @Override
    public String getDataSetName(int set) {
        return ((DataSet)this.data.get(set)).getTitle();
    }

    @Override
    public int getAxisBinding(int set) {
        return ((DataSet)this.data.get(set)).getYAxis();
    }

    @Override
    public boolean isColumnNumeric() {
        return true;
    }

    @Override
    public Class getColumnClass() {
        return Double.class;
    }

    @Override
    public Number getValueAt(int set, int index) {
        return (Number)((DataSet)this.data.get(set)).getValueAt(index);
    }

    @Override
    public Object getColumnValueAt(int col) {
        return null;
    }

    @Override
    public Object getColumnValueAt(int set, int col) {
        if (col < this.getDataSetLength(set)) {
            return new Double(((Number)((DataSet)this.data.get(set)).getColumnValueAt(col)).doubleValue());
        }
        return null;
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        if (axis == 0) {
            return this.constraints1;
        }
        return this.constraints2;
    }

    @Override
    public void setChartDataModelConstraints(int axis, ChartDataModelConstraints constraints) {
        if (axis == 0) {
            this.constraints1 = constraints;
        } else {
            this.constraints2 = constraints;
        }
    }

    protected void trimSet(TreeSet s) {
        while (((Number)s.first()).doubleValue() == Double.NEGATIVE_INFINITY) {
            s.remove(s.first());
        }
        double last = ((Number)s.last()).doubleValue();
        while (last == Double.POSITIVE_INFINITY || last != last) {
            s.remove(s.last());
            last = ((Number)s.last()).doubleValue();
        }
    }

    @Override
    protected TreeSet getOrderedValues(int axis) {
        return (TreeSet)this.valuesbyaxis.get(new Integer(axis));
    }

    @Override
    protected double getFirstColumnValue() {
        return ((Number)this.columnSet.first()).doubleValue();
    }

    @Override
    protected double getLastColumnValue() {
        return ((Number)this.columnSet.last()).doubleValue();
    }
}

