/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;

public abstract class AbstractChartDataModel
implements ChartDataModel {
    protected EventListenerList listener = new EventListenerList();
    protected boolean autoscale = true;
    protected double maxcolumn;
    protected double mincolumn;
    protected Number maxvalue;
    protected Number minvalue;

    @Override
    public void removeChartDataModelListener(ChartDataModelListener l) {
        this.listener.remove(ChartDataModelListener.class, l);
    }

    @Override
    public void addChartDataModelListener(ChartDataModelListener l) {
        Object[] ls = this.listener.getListenerList();
        boolean found = false;
        int i = ls.length - 1;
        while (i >= 1) {
            if (ls[i] == l) {
                found = true;
                break;
            }
            i -= 2;
        }
        if (!found) {
            this.listener.add(ChartDataModelListener.class, l);
        }
        this.listener.add(ChartDataModelListener.class, l);
    }

    @Override
    public boolean isColumnNumeric() {
        return false;
    }

    @Override
    public void setValueAt(int set, int index, Object value) {
    }

    @Override
    public Class getColumnClass() {
        return Object.class;
    }

    @Override
    public void fireChartDataModelChangedEvent(Object src) {
        ChartDataModelEvent e = new ChartDataModelEvent(src);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == ChartDataModelListener.class) {
                ((ChartDataModelListener)ls[i + 1]).chartDataChanged(e);
            }
            i -= 2;
        }
    }

    @Override
    public int getAxisBinding(int set) {
        return 0;
    }

    @Override
    public void setAxisBinding(int set, int axis) {
    }

    @Override
    public void setAutoScale(boolean b) {
        this.autoscale = b;
    }

    @Override
    public boolean isAutoScale() {
        return this.autoscale;
    }

    @Override
    public void setManualScale(boolean b) {
        this.autoscale = !b;
    }

    @Override
    public boolean isManualScale() {
        return !this.autoscale;
    }

    @Override
    public void setMaximumColumnValue(double d) {
        this.maxcolumn = d;
    }

    @Override
    public void setMinimumColumnValue(double d) {
        this.mincolumn = d;
    }

    @Override
    public void setMaximumValue(Number n) {
        this.maxvalue = n;
    }

    @Override
    public void setMinimumValue(Number n) {
        this.minvalue = n;
    }

    @Override
    public double getManualMaximumColumnValue() {
        return this.maxcolumn;
    }

    @Override
    public double getManualMinimumColumnValue() {
        return this.mincolumn;
    }

    @Override
    public Number getManualMaximumValue() {
        return this.maxvalue;
    }

    @Override
    public Number getManualMinimumValue() {
        return this.minvalue;
    }

    @Override
    public Number getManualMaximumX() {
        return new Double(this.maxcolumn);
    }

    @Override
    public Number getManualMaximumY() {
        return this.maxvalue;
    }

    @Override
    public Number getManualMinimumX() {
        return new Double(this.mincolumn);
    }

    @Override
    public Number getManualMinimumY() {
        return this.minvalue;
    }

    @Override
    public void setMaximumValueX(Number n) {
        if (n == null) {
            return;
        }
        this.maxcolumn = n.doubleValue();
    }

    @Override
    public void setMaximumValueY(Number n) {
        this.maxvalue = n;
    }

    @Override
    public void setMinimumValueX(Number n) {
        if (n == null) {
            return;
        }
        this.mincolumn = n.doubleValue();
    }

    @Override
    public void setMinimumValueY(Number n) {
        this.minvalue = n;
    }

    @Override
    public String getDataSetName(int set) {
        return "Dataset " + set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            AbstractChartDataModel model = (AbstractChartDataModel)o;
            if (this.getDataSetNumber() != model.getDataSetNumber()) {
                return false;
            }
            int i = 0;
            block2: while (true) {
                if (i >= this.getDataSetNumber()) {
                    return true;
                }
                if (!this.getDataSetName(i).equals(model.getDataSetName(i))) {
                    return false;
                }
                int j = 0;
                while (true) {
                    if (j >= this.getDataSetLength(j)) {
                        ++i;
                        continue block2;
                    }
                    if (!this.getColumnValueAt(j).equals(model.getColumnValueAt(j))) {
                        return false;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract TreeSet getOrderedValues(int var1);

    protected abstract double getFirstColumnValue();

    protected abstract double getLastColumnValue();
}

