/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.FACS_objects.FACS_panel;
import FCSalyzer.FACS_objects.FACS_plot;
import FCSalyzer.GUI.FACS_document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FACS_annotation
extends FACS_panel {
    private String annotationKeyword;
    private final JTextPane textArea = new JTextPane();
    private final int border = 5;
    private FACS_plot parentPlot;
    private boolean showLegend = false;
    public static final String XML_NAME = "FACS_annotation";
    private static final String XML_ANNOTATION_KEYWORD = "AnnotationKeyword";
    private static final String XML_IS_LEGEND = "isLegend";

    private FACS_annotation() {
    }

    public FACS_annotation(FACS_document paramDoc, FACS_plot paramPlot, String paramKeyword, boolean showLegend) {
        this.setFCS_Document(paramDoc);
        this.showLegend = showLegend;
        this.addMouseListener(this);
        this.textArea.setActionMap(null);
        this.addMouseMotionListener(this);
        this.textArea.addMouseListener(this);
        this.textArea.addMouseMotionListener(this);
        this.textArea.setForeground(Color.black);
        this.setOpaque(false);
        this.textArea.setOpaque(false);
        this.textArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(5), "East");
        this.add(Box.createHorizontalStrut(5), "West");
        this.add(Box.createVerticalStrut(5), "North");
        this.add(Box.createVerticalStrut(5), "South");
        this.add(this.textArea);
        this.annotationKeyword = paramKeyword;
        this.parentPlot = paramPlot;
        this.refresh();
    }

    public static FACS_annotation loadAnnotation(FACS_document paramDoc, FACS_plot paramPlot, Node storedData) throws NumberFormatException {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        Float fonts = null;
        String annoKey = "";
        Integer zo = null;
        boolean isLegend = false;
        NodeList nL = storedData.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            NodeList nL_temp;
            Node current = nL.item(i);
            String nameCurrent = current.getNodeName();
            if (nameCurrent.equals(XML_ANNOTATION_KEYWORD)) {
                annoKey = staticMethods.getNodeText(current);
                continue;
            }
            if (nameCurrent.equals(XML_IS_LEGEND)) {
                isLegend = staticMethods.getNodeBoolean(current);
                continue;
            }
            if (nameCurrent.equals("ZOrder")) {
                zo = staticMethods.getNodeInteger(current, zo);
                continue;
            }
            if (nameCurrent.equals("Font")) {
                nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (!curr2Name.equals("Size")) continue;
                    fonts = staticMethods.getNodeFloat(curr2, fonts);
                }
                continue;
            }
            if (!nameCurrent.equals("Bounds")) continue;
            nL_temp = current.getChildNodes();
            double x = 0.0;
            double y = 0.0;
            double width = 0.0;
            double height = 0.0;
            for (int j = 0; j < nL_temp.getLength(); ++j) {
                Node curr2 = nL_temp.item(j);
                String curr2Name = curr2.getNodeName();
                if (curr2Name.equals("X")) {
                    x = staticMethods.getNodeDouble(curr2, x);
                    continue;
                }
                if (curr2Name.equals("Y")) {
                    y = staticMethods.getNodeDouble(curr2, y);
                    continue;
                }
                if (curr2Name.equals("Width")) {
                    width = staticMethods.getNodeDouble(curr2, width);
                    continue;
                }
                if (!curr2Name.equals("Height")) continue;
                height = staticMethods.getNodeDouble(curr2, height);
            }
            bounds = new Rectangle((int)x, (int)y, (int)width, (int)height);
        }
        FACS_annotation newAnnotation = new FACS_annotation(paramDoc, paramPlot, annoKey, isLegend);
        newAnnotation.setBounds(bounds);
        if (fonts != null) {
            newAnnotation.setFontSize(fonts);
        }
        if (zo != null) {
            newAnnotation.rememberZOrder(zo);
        }
        return newAnnotation;
    }

    public String getAnnotationKeyword() {
        return this.annotationKeyword;
    }

    public Rectangle getTextAreaBounds() {
        return this.textArea.getBounds();
    }

    public boolean showsLegend() {
        return this.showLegend;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseReleased(e);
    }

    @Override
    public FACS_annotation duplicate() {
        FACS_annotation toReturn = new FACS_annotation(this.theDocument, this.parentPlot, this.annotationKeyword, this.showLegend);
        toReturn.setFontSize(this.getFontSize());
        toReturn.setBounds(this.getBounds());
        return toReturn;
    }

    public void setParentPlot(FACS_plot newParent, boolean refresh) {
        this.parentPlot = newParent;
        if (refresh) {
            this.refresh();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.textArea.setBounds(5, 5, this.getBounds().width - 5, this.getBounds().height - 5);
    }

    @Override
    public void setFontSize(Float newSize) {
        super.setFontSize(newSize);
        this.textArea.setFont(this.getFont());
    }

    public void refresh() {
        this.textArea.setText(null);
        this.textArea.setEditable(true);
        int currentPos = 0;
        for (int i = 0; i < this.parentPlot.getOverlayCount(); ++i) {
            if (this.showLegend) {
                this.textArea.insertIcon(new ImageIcon(this.parentPlot.getOverlayLegendImage(i)));
                this.textArea.setCaretPosition(++currentPos);
            }
            String n = this.parentPlot.getValueTEXT(i, this.annotationKeyword);
            this.textArea.replaceSelection(n);
            this.textArea.setCaretPosition(currentPos += n.length());
            if (i < this.parentPlot.getOverlayCount() - 1) {
                this.textArea.replaceSelection("\n");
            }
            ++currentPos;
        }
        this.textArea.setEditable(false);
    }

    public Object[][] getAnnotations() {
        Object[][] toReturn = new Object[this.parentPlot.getOverlayCount()][2];
        for (int i = 0; i < toReturn.length; ++i) {
            if (this.showLegend) {
                toReturn[i][0] = this.parentPlot.getOverlayLegendImage(i);
            }
            toReturn[i][1] = this.parentPlot.getValueTEXT(i, this.annotationKeyword);
        }
        return toReturn;
    }

    public void toXML(Node parent) {
        Node anno = staticMethods.addNode(parent, XML_NAME, null);
        Node bounds = staticMethods.addNode(anno, "Bounds", null);
        Rectangle r = this.getBounds();
        staticMethods.addNode(bounds, "X", r.getX());
        staticMethods.addNode(bounds, "Y", r.getY());
        staticMethods.addNode(bounds, "Width", r.getWidth());
        staticMethods.addNode(bounds, "Height", r.getHeight());
        staticMethods.addNode(anno, "ZOrder", this.theDocument.getComponentZOrder(this));
        Node font = staticMethods.addNode(anno, "Font", null);
        staticMethods.addNode(font, "Size", this.getFont().getSize());
        staticMethods.addNode(anno, XML_ANNOTATION_KEYWORD, this.annotationKeyword);
        staticMethods.addNode(anno, XML_IS_LEGEND, this.showLegend);
    }

    @Override
    public synchronized void delete() {
        if (this.parentPlot != null) {
            this.parentPlot.removeChild(this);
        }
        this.parentPlot = null;
        this.theDocument = null;
    }

    @Override
    public void removeListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.textArea.removeMouseListener(this);
        this.textArea.removeMouseMotionListener(this);
    }
}

