/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import staticStuff.Fileservice;

public class exportDialog
extends JDialog
implements ActionListener {
    public static final int exportPlots = 0;
    public static final int exportDocument = 1;
    private JList theFileList = new JList();
    private ArrayList<File> theFiles = new ArrayList();
    public static final Double factorNo = 0.0;
    public static final String noPNG = "Don't export PNG";
    public static final Double factor72 = 1.0;
    public static final String dpi72 = "72 DPI";
    public static final Double factor150 = 2.0833333333333335;
    public static final String dpi150 = "150 DPI";
    public static final Double factor300 = 4.166666666666667;
    public static final String dpi300 = "300 DPI";
    public static final Double factor600 = 8.333333333333334;
    public static final String dpi600 = "600 DPI";
    public static final Double factor900 = 12.5;
    public static final String dpi900 = "900 DPI";
    public static final String[] dpi = new String[]{"Don't export PNG", "72 DPI", "150 DPI", "300 DPI", "600 DPI", "900 DPI"};
    public static final Double[] dpiFloat = new Double[]{factorNo, factor72, factor150, factor300, factor600, factor900};
    private static final String noCSV = "Don't export data values";
    public static final int CSVnoExport = 0;
    private static final String calculatedData = "Data as used for statistics calculations";
    public static final int CSVcalculatedData = 1;
    private static final String rawData = "Raw data as stored in FCS file";
    public static final int CSVrawData = 2;
    private static final String[] data = new String[]{"Don't export data values", "Data as used for statistics calculations", "Raw data as stored in FCS file"};
    private JComboBox pngOptions = new JComboBox<String>(dpi);
    private JComboBox csvOptions = new JComboBox<String>(data);
    private JCheckBox svgOption = new JCheckBox("Export SVG", false);
    private JCheckBox printOption = new JCheckBox("Print document", false);
    private JCheckBox statisticsOption = new JCheckBox("Export statistics", false);
    private JCheckBox combineDataOption = new JCheckBox("Combine data into one file", true);
    private JButton addFiles = new JButton("Add Files");
    private JButton removeFiles = new JButton("Remove Files");
    private JButton cancelDialog = new JButton("Cancel");
    private JButton OKDialog = new JButton("Export");
    private File exportPath;
    JLabel pathLabel = new JLabel("<none selected>");
    JButton selectPath = new JButton("Select directory");
    private boolean export = false;
    private static final String helpTextPlots = "<html><body><h2>Simple export, batch export, and export options</h2><h3>Simple export</h3><p>Simple export takes place, if the file list to the left remains empty: the selected plot(s), their data and their statistics will simply be exported as they currently appear.</p><h3>Batch export</h3><p><b>Left file list:</b>Add FCS data files for batch exporting. The files will be applied to the selected plots as a batch operation.<br><u>Important:</u> all files in the list will use the transformation and compensation that is used by the file currently shown in the plot(s) - even, if a file is already used by the document and uses a different transformation and/or compensation! Please make sure that all files 'fit together'  in terms of parameter type and parameter count, or the batch results might not fit your expectations. Also, batch export <u>will not work for derived or attached parameters</u>.<br>For plots with multiple overlays, only the first overlay will be changed during batch export.</p><h3>Export options</h3><p><b>PNG options:</b> Please select if and at which DPI the selected plot(s) shall be exported.<br><b>CSV options:</b> Please select which kind of data shall be exported for the selected plot(s): <i>Data as used for statistics calculations</i> is event data prepared for analysis, including compensation. <i>Raw data as stored in FCS file</i> is the event data exactly as stored in the FCS data file, i.e. pure raw data.<br><b>Export SVG:</b> If checked, selected plot(s) will be exported as SVG. Please note that text might be slightly different compared to the way it looks in FCSaylzer.<br><b>Export statistics:</b> If checked, the statistics of selected plot(s) will be exported into a text file.<br><b>Select directory:</b> Please select the path for the exported files. The file names will be put together from the FCS data file names, plot numbers and overlay counts. When exporting documents, each page will be a separate PNG; when exporting selected plots, each plot will be a separate PNG. Existing files with the same name will be overwritten! It's best to select an empty directory for the export.</p></body></html>";
    private static final String helpTextDocument = "<html><body><h2>Simple export, batch export, and export options</h2><h3>Simple export</h3><p>Simple export takes place, if the file list to the left remains empty. Then, the existing document with its plots, data and statistics will simply be exported as it currently appears.</p><h3>Batch export</h3><p><b>Left file list:</b>Add FCS data files for batch exporting. The files will be applied to the selected plots as a batch operation.<br><b>Plots for batch operation:</b> If plots are selected, only those plots will be changed during batching. If no plots are selected, all plots are treated as 'selected'.<br><u>Important:</u> all files in the list will use the transformation and compensation that is used by the file currently shown in the plot(s) - even, if a file is already used by the document and uses a different transformation and/or compensation! Please make sure that all files 'fit together'  in terms of parameter type and parameter count, or the batch results might not fit your expectations. Also, batch export <u>will not work for derived or attached parameters</u>.<br>For plots with multiple overlays, only the first overlay will be changed during batch export.</p><h3>Export options</h3><p><b>PNG options:</b> Please select if and at which DPI the document shall be exported.<br><b>CSV options:</b> Please select which kind of data shall be exported for the selected plot(s): <i>Data as used for statistics calculations</i> is event data prepared for analysis, including compensation. <i>Raw data as stored in FCS file</i> is the event data exactly as stored in the FCS data file, i.e. pure raw data.<br><b>Export SVG:</b> If checked, the document will be exported as SVG. Please note that text might be slightly different compared to the way it looks in FCSaylzer.<br><b>Export statistics:</b> If checked, the statistics of selected plot(s) will be exported into a text file.<br><b>Print document:</b> The document can also be (batch-)printed.<br><b>Select directory:</b> Please select the path for the exported files. The file names will be put together from the FCS data file names, plot numbers and overlay counts. Each document page will be a separate PNG. Existing files with the same name will be overwritten! It's best to select an empty directory for the export.</p></body></html>";

    public exportDialog(int type, File startPath) {
        if (startPath != null) {
            this.exportPath = startPath;
            this.pathLabel.setText(this.exportPath.getAbsolutePath());
        }
        this.addFiles.addActionListener(this);
        this.removeFiles.addActionListener(this);
        this.selectPath.addActionListener(this);
        this.cancelDialog.addActionListener(this);
        this.OKDialog.addActionListener(this);
        JPanel fileArea = new JPanel(new BorderLayout());
        JPanel fileAreaButtons = new JPanel();
        JScrollPane fileScroller = new JScrollPane(this.theFileList);
        fileArea.add((Component)fileScroller, "Center");
        fileAreaButtons.add(this.addFiles);
        fileAreaButtons.add(this.removeFiles);
        fileArea.add((Component)fileAreaButtons, "South");
        JPanel optionsArea = new JPanel();
        BoxLayout newBox = new BoxLayout(optionsArea, 1);
        optionsArea.setLayout(newBox);
        optionsArea.add(Box.createVerticalGlue());
        JLabel pngLabel = new JLabel("Please select the PNG export option:");
        pngLabel.setAlignmentX(0.0f);
        optionsArea.add(pngLabel);
        this.pngOptions.setAlignmentX(0.0f);
        optionsArea.add(this.pngOptions);
        optionsArea.add(Box.createVerticalStrut(5));
        JLabel exportLabel = new JLabel("Please select the data export option:");
        exportLabel.setAlignmentX(0.0f);
        optionsArea.add(exportLabel);
        this.csvOptions.setAlignmentX(0.0f);
        optionsArea.add(this.csvOptions);
        optionsArea.add(Box.createVerticalStrut(5));
        JPanel checkBoxes = new JPanel(new GridLayout(0, 2, 5, 5));
        checkBoxes.setAlignmentX(0.0f);
        this.svgOption.setAlignmentX(0.0f);
        checkBoxes.add(this.svgOption);
        this.statisticsOption.setAlignmentX(0.0f);
        checkBoxes.add(this.statisticsOption);
        this.combineDataOption.setAlignmentX(0.0f);
        checkBoxes.add(this.combineDataOption);
        if (type == 1) {
            this.printOption.setAlignmentX(0.0f);
            checkBoxes.add(this.printOption);
        }
        optionsArea.add(checkBoxes);
        optionsArea.add(Box.createVerticalGlue());
        JPanel buttonsArea = new JPanel();
        buttonsArea.add(this.cancelDialog);
        buttonsArea.add(this.OKDialog);
        JEditorPane helpArea = new JEditorPane();
        helpArea.setContentType("text/html");
        if (type == 0) {
            helpArea.setText(helpTextPlots);
        }
        helpArea.setText(helpTextDocument);
        helpArea.setCaretPosition(0);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsArea, "South");
        JSplitPane holder_top = new JSplitPane(1);
        holder_top.add(fileArea);
        JSplitPane holder_right = new JSplitPane(0);
        JPanel optionsHolder = new JPanel(new BorderLayout());
        optionsHolder.add((Component)optionsArea, "Center");
        optionsHolder.add(Box.createVerticalStrut(10), "North");
        optionsHolder.add(Box.createVerticalStrut(10), "South");
        optionsHolder.add(Box.createHorizontalStrut(10), "East");
        optionsHolder.add(Box.createHorizontalStrut(10), "West");
        JPanel holderOptionFile = new JPanel(new BorderLayout());
        holderOptionFile.add((Component)optionsHolder, "Center");
        JPanel pathHolder = new JPanel(new FlowLayout(0));
        this.selectPath.setAlignmentX(0.0f);
        pathHolder.add(this.selectPath);
        this.pathLabel.setAlignmentX(0.0f);
        pathHolder.add(this.pathLabel);
        holderOptionFile.add((Component)pathHolder, "South");
        holder_right.add(holderOptionFile);
        holder_right.add(new JScrollPane(helpArea));
        holder_top.add(holder_right);
        this.add((Component)holder_top, "Center");
        this.setSize(800, 500);
        this.setModal(true);
        this.setLocationByPlatform(true);
        this.setTitle("Select export options");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        File[] addF;
        File newF;
        Object source = e.getSource();
        if (source == this.cancelDialog) {
            this.setVisible(false);
        }
        if (source == this.OKDialog) {
            if (this.pngOptions.getSelectedIndex() > 0 || this.csvOptions.getSelectedIndex() > 0 || this.statisticsOption.isSelected() || this.printOption.isSelected() || this.svgOption.isSelected()) {
                if (this.exportPath != null) {
                    this.export = true;
                    this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(this, "Please select a directory for the exported files!", "Export path missing", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select something to export!", "Export options missing", 0);
            }
        }
        if (source == this.selectPath && (newF = Fileservice.getDirectory()) != null) {
            this.exportPath = newF;
            this.pathLabel.setText(this.exportPath.getAbsolutePath());
        }
        if (source == this.addFiles && (addF = Fileservice.getFiles()) != null) {
            for (File current : addF) {
                boolean exists = false;
                for (File test : this.theFiles) {
                    if (!test.getAbsolutePath().equals(current.getAbsolutePath())) continue;
                    exists = true;
                }
                if (exists) continue;
                this.theFiles.add(current);
            }
            String[] files = new String[this.theFiles.size()];
            for (i = 0; i < files.length; ++i) {
                files[i] = this.theFiles.get(i).getAbsolutePath();
            }
            this.theFileList.setListData(files);
        }
        if (source == this.removeFiles) {
            int[] toRemove = this.theFileList.getSelectedIndices();
            Arrays.sort(toRemove);
            for (int i2 = toRemove.length - 1; i2 > -1; --i2) {
                this.theFiles.remove(toRemove[i2]);
            }
            String[] files = new String[this.theFiles.size()];
            for (i = 0; i < files.length; ++i) {
                files[i] = this.theFiles.get(i).getAbsolutePath();
            }
            this.theFileList.setListData(files);
        }
    }

    public ArrayList<File> getFileList() {
        return this.theFiles;
    }

    public Double getPNGOption() {
        if (this.pngOptions.getSelectedIndex() == -1) {
            return factorNo;
        }
        return dpiFloat[this.pngOptions.getSelectedIndex()];
    }

    public int getCSVOption() {
        return this.csvOptions.getSelectedIndex();
    }

    public boolean getSVGOption() {
        return this.svgOption.isSelected();
    }

    public boolean getStatisticsOption() {
        return this.statisticsOption.isSelected();
    }

    public boolean getPrintOption() {
        return this.printOption.isSelected();
    }

    public boolean shallExport() {
        return this.export;
    }

    public boolean getCombineData() {
        return this.combineDataOption.isSelected();
    }

    public File getPath() {
        return this.exportPath;
    }
}

