/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.Tagger;

public class ManualTaggerAdapter
implements Tagger {
    private final ManualTagger manualTagger;

    public ManualTaggerAdapter(ManualTagger manualTagger) {
        this.manualTagger = manualTagger;
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            List manualTags = this.manualTagger.tag(word.toLowerCase());
            for (TaggedWord manualTag : manualTags) {
                l.add(new AnalyzedToken(word, manualTag.getPosTag(), manualTag.getLemma()));
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    public AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }
}

