/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.target;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.normalize.DataNormalization;
import org.encog.util.normalize.NormalizationError;
import org.encog.util.normalize.target.NormalizationStorage;

public class NormalizationStorageCSV
implements NormalizationStorage {
    private File outputFile;
    private transient PrintWriter output;
    private CSVFormat format;

    public NormalizationStorageCSV(CSVFormat format, File file) {
        this.format = format;
        this.outputFile = file;
    }

    public NormalizationStorageCSV() {
        this.format = CSVFormat.EG_FORMAT;
    }

    public NormalizationStorageCSV(File file) {
        this.format = CSVFormat.ENGLISH;
        this.outputFile = file;
    }

    @Override
    public void close() {
        this.output.close();
    }

    @Override
    public void open(DataNormalization norm) {
        try {
            FileWriter outFile = new FileWriter(this.outputFile);
            this.output = new PrintWriter(outFile);
        }
        catch (IOException e) {
            throw new NormalizationError(e);
        }
    }

    @Override
    public void write(double[] data, int inputCount) {
        StringBuilder result = new StringBuilder();
        NumberList.toList(this.format, result, data);
        this.output.println(result.toString());
    }
}

