/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.kmeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.encog.util.kmeans.CentroidFactory;
import org.encog.util.kmeans.Cluster;

public class KMeansUtil<K extends CentroidFactory<? super K>> {
    private final ArrayList<Cluster<K>> clusters;
    private final int k;

    public KMeansUtil(int theK, List<? extends K> theElements) {
        this.k = theK;
        this.clusters = new ArrayList(theK);
        this.initRandomClusters(theElements);
    }

    private void initRandomClusters(List<? extends K> elements) {
        CentroidFactory element;
        int elementIndex;
        int clusterIndex = 0;
        for (elementIndex = 0; elementIndex < elements.size() && clusterIndex < this.k && elements.size() - elementIndex > this.k - clusterIndex; ++elementIndex) {
            element = (CentroidFactory)elements.get(elementIndex);
            boolean added = false;
            for (int i = 0; i < clusterIndex; ++i) {
                Cluster<K> cluster = this.clusters.get(i);
                if (cluster.centroid().distance(element) != 0.0) continue;
                cluster.add(element);
                added = true;
                break;
            }
            if (added) continue;
            this.clusters.add(new Cluster<CentroidFactory>((CentroidFactory)elements.get(elementIndex)));
            ++clusterIndex;
        }
        while (clusterIndex < this.k && elementIndex < elements.size()) {
            this.clusters.add(new Cluster<CentroidFactory>((CentroidFactory)elements.get(elementIndex)));
            ++elementIndex;
            ++clusterIndex;
        }
        while (clusterIndex < this.k) {
            this.clusters.add(new Cluster());
            ++clusterIndex;
        }
        while (elementIndex < elements.size()) {
            element = (CentroidFactory)elements.get(elementIndex);
            this.nearestCluster(element).add(element);
            ++elementIndex;
        }
    }

    public void process() {
        boolean done;
        do {
            done = true;
            for (int i = 0; i < this.k; ++i) {
                Cluster<K> thisCluster = this.clusters.get(i);
                List<K> thisElements = thisCluster.getContents();
                for (int j = 0; j < thisElements.size(); ++j) {
                    Cluster<CentroidFactory> nearestCluster;
                    CentroidFactory thisElement = (CentroidFactory)thisElements.get(j);
                    if (!(thisCluster.centroid().distance(thisElement) > 0.0) || thisCluster == (nearestCluster = this.nearestCluster(thisElement))) continue;
                    nearestCluster.add(thisElement);
                    thisCluster.remove(j);
                    done = false;
                }
            }
        } while (!done);
    }

    private Cluster<K> nearestCluster(K element) {
        double distance = Double.MAX_VALUE;
        Cluster<K> result = null;
        for (int i = 0; i < this.clusters.size(); ++i) {
            double thisDistance = this.clusters.get(i).centroid().distance(element);
            if (!(distance > thisDistance)) continue;
            distance = thisDistance;
            result = this.clusters.get(i);
        }
        return result;
    }

    public Collection<K> get(int index) {
        return this.clusters.get(index).getContents();
    }

    public int size() {
        return this.clusters.size();
    }

    public Cluster<K> getCluster(int i) {
        return this.clusters.get(i);
    }
}

