/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.hyperneat.substrate;

import org.encog.neural.hyperneat.substrate.Substrate;
import org.encog.neural.hyperneat.substrate.SubstrateNode;

public class SubstrateFactory {
    public static Substrate factorSandwichSubstrate(int inputEdgeSize, int outputEdgeSize) {
        Substrate result = new Substrate(3);
        double inputTick = 2.0 / (double)inputEdgeSize;
        double outputTick = 2.0 / (double)inputEdgeSize;
        double inputOrig = -1.0 + inputTick / 2.0;
        double outputOrig = -1.0 + inputTick / 2.0;
        for (int row = 0; row < inputEdgeSize; ++row) {
            for (int col = 0; col < inputEdgeSize; ++col) {
                SubstrateNode inputNode = result.createInputNode();
                inputNode.getLocation()[0] = -1.0;
                inputNode.getLocation()[1] = inputOrig + (double)row * inputTick;
                inputNode.getLocation()[2] = inputOrig + (double)col * inputTick;
            }
        }
        for (int orow = 0; orow < outputEdgeSize; ++orow) {
            for (int ocol = 0; ocol < outputEdgeSize; ++ocol) {
                SubstrateNode outputNode = result.createOutputNode();
                outputNode.getLocation()[0] = 1.0;
                outputNode.getLocation()[1] = outputOrig + (double)orow * outputTick;
                outputNode.getLocation()[2] = outputOrig + (double)ocol * outputTick;
                for (SubstrateNode inputNode : result.getInputNodes()) {
                    result.createLink(inputNode, outputNode);
                }
            }
        }
        return result;
    }
}

