/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public class ComplexNumber {
    private final double x;
    private final double y;

    public ComplexNumber(double u, double v) {
        this.x = u;
        this.y = v;
    }

    public ComplexNumber(ComplexNumber other) {
        this.x = other.getReal();
        this.y = other.getImaginary();
    }

    public double getReal() {
        return this.x;
    }

    public double getImaginary() {
        return this.y;
    }

    public double mod() {
        if (this.x != 0.0 || this.y != 0.0) {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return 0.0;
    }

    public double arg() {
        return Math.atan2(this.y, this.x);
    }

    public ComplexNumber conj() {
        return new ComplexNumber(this.x, -this.y);
    }

    public ComplexNumber plus(ComplexNumber w) {
        return new ComplexNumber(this.x + w.getReal(), this.y + w.getImaginary());
    }

    public ComplexNumber minus(ComplexNumber w) {
        return new ComplexNumber(this.x - w.getReal(), this.y - w.getImaginary());
    }

    public ComplexNumber times(ComplexNumber w) {
        return new ComplexNumber(this.x * w.getReal() - this.y * w.getImaginary(), this.x * w.getImaginary() + this.y * w.getReal());
    }

    public ComplexNumber div(ComplexNumber w) {
        double den = Math.pow(w.mod(), 2.0);
        return new ComplexNumber((this.x * w.getReal() + this.y * w.getImaginary()) / den, (this.y * w.getReal() - this.x * w.getImaginary()) / den);
    }

    public ComplexNumber exp() {
        return new ComplexNumber(Math.exp(this.x) * Math.cos(this.y), Math.exp(this.x) * Math.sin(this.y));
    }

    public ComplexNumber log() {
        return new ComplexNumber(Math.log(this.mod()), this.arg());
    }

    public ComplexNumber sqrt() {
        double r = Math.sqrt(this.mod());
        double theta = this.arg() / 2.0;
        return new ComplexNumber(r * Math.cos(theta), r * Math.sin(theta));
    }

    private double cosh(double theta) {
        return (Math.exp(theta) + Math.exp(-theta)) / 2.0;
    }

    private double sinh(double theta) {
        return (Math.exp(theta) - Math.exp(-theta)) / 2.0;
    }

    public ComplexNumber sin() {
        return new ComplexNumber(this.cosh(this.y) * Math.sin(this.x), this.sinh(this.y) * Math.cos(this.x));
    }

    public ComplexNumber cos() {
        return new ComplexNumber(this.cosh(this.y) * Math.cos(this.x), -this.sinh(this.y) * Math.sin(this.x));
    }

    public ComplexNumber sinh() {
        return new ComplexNumber(this.sinh(this.x) * Math.cos(this.y), this.cosh(this.x) * Math.sin(this.y));
    }

    public ComplexNumber cosh() {
        return new ComplexNumber(this.cosh(this.x) * Math.cos(this.y), this.sinh(this.x) * Math.sin(this.y));
    }

    public ComplexNumber tan() {
        return this.sin().div(this.cos());
    }

    public ComplexNumber chs() {
        return new ComplexNumber(-this.x, -this.y);
    }

    public String toString() {
        if (this.x != 0.0 && this.y > 0.0) {
            return this.x + " + " + this.y + "i";
        }
        if (this.x != 0.0 && this.y < 0.0) {
            return this.x + " - " + -this.y + "i";
        }
        if (this.y == 0.0) {
            return String.valueOf(this.x);
        }
        if (this.x == 0.0) {
            return this.y + "i";
        }
        return this.x + " + i*" + this.y;
    }
}

