/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class QueryParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public QueryParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
        super(mpep, locator, Parameter.Source.QUERY);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new QueryParamValueFactory(e, !parameter.isEncoded());
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<QueryParam> {
        public InjectionResolver() {
            super(QueryParamValueFactoryProvider.class);
        }
    }

    private static final class QueryParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        QueryParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        public Object provide() {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)this.getContainerRequest().getUriInfo().getQueryParameters(this.decode));
            }
            catch (ExtractorException e) {
                throw new ParamException.QueryParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

