/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.ConnectorService;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
public class AppSpecificConnectorClassLoaderUtil {
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    @Named(value="default-instance-name")
    private Provider<ConnectorService> connectorServiceProvider;
    @Inject
    private Provider<ConnectorsClassLoaderUtil> connectorsClassLoaderUtilProvider;
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private Provider<Applications> applicationsProvider;
    private static final Logger _logger = LogDomains.getLogger(AppSpecificConnectorClassLoaderUtil.class, (String)"javax.enterprise.resource.resourceadapter");

    public void detectReferredRARs(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            throw new IllegalStateException("ApplicationInfo is not available for application [ " + appName + " ]");
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (!appInfo.isJavaEEApp()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Application [" + appName + "] is not a Java EE application, skipping " + "resource-adapter references detection");
            }
            return;
        }
        this.processDescriptorForRAReferences(app, null, (JndiNameEnvironment)app);
        Set bundleDescriptors = app.getBundleDescriptors();
        for (BundleDescriptor bundleDesc : bundleDescriptors) {
            String moduleName = this.getModuleName(bundleDesc, app);
            this.processDescriptorForRAReferences(app, (Descriptor)bundleDesc, moduleName);
            Collection dds = bundleDesc.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.processDescriptorForRAReferences(app, (Descriptor)dd, moduleName);
            }
        }
    }

    private void processDescriptorForRAReferences(Application app, Descriptor descriptor, String moduleName) {
        if (descriptor instanceof JndiNameEnvironment) {
            this.processDescriptorForRAReferences(app, moduleName, (JndiNameEnvironment)descriptor);
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                EjbMessageBeanDescriptor messageBeanDesc;
                String raMid;
                this.processDescriptorForRAReferences(app, moduleName, (JndiNameEnvironment)ejbDescriptor);
                if (!(ejbDescriptor instanceof EjbMessageBeanDescriptor) || (raMid = (messageBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor).getResourceAdapterMid()) == null) continue;
                app.addResourceAdapter(raMid);
            }
            Set ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                this.processDescriptorForRAReferences(app, moduleName, (JndiNameEnvironment)ejbInterceptor);
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                this.processDescriptorForRAReferences(app, moduleName, (JndiNameEnvironment)mbd);
            }
        }
    }

    private String getModuleName(BundleDescriptor bundleDesc, Application app) {
        Set moduleDescriptors = app.getModules();
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDesc : moduleDescriptors) {
                if (!bundleDesc.equals(moduleDesc.getDescriptor())) continue;
                return moduleDesc.getModuleName();
            }
        }
        return null;
    }

    public Set<String> getRARsReferredByApplication(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            Application app = (Application)appInfo.getMetaData(Application.class);
            if (appInfo.isJavaEEApp()) {
                return app.getResourceAdapters();
            }
        }
        return new HashSet<String>();
    }

    private void processDescriptorForRAReferences(Application app, String moduleName, JndiNameEnvironment jndiEnv) {
        String jndiName;
        for (Object resourceRef : jndiEnv.getResourceReferenceDescriptors()) {
            ResourceReferenceDescriptor resRefDesc = (ResourceReferenceDescriptor)resourceRef;
            jndiName = resRefDesc.getJndiName();
            if (jndiName == null) continue;
            this.detectResourceInRA(app, moduleName, jndiName);
        }
        for (Object resourceEnvRef : jndiEnv.getResourceEnvReferenceDescriptors()) {
            ResourceEnvReferenceDescriptor resourceEnvRefDesc = (ResourceEnvReferenceDescriptor)resourceEnvRef;
            jndiName = resourceEnvRefDesc.getJndiName();
            if (jndiName == null) continue;
            this.detectResourceInRA(app, moduleName, jndiName);
        }
    }

    private void detectResourceInRA(Application app, String moduleName, String jndiName) {
        ApplicationInfo appInfo;
        Resource res = null;
        if (jndiName.startsWith("java:app/")) {
            appInfo = this.appRegistry.get(app.getName());
            res = this.getApplicationScopedResource(jndiName, BindableResource.class, appInfo);
        } else if (jndiName.startsWith("java:module/")) {
            appInfo = this.appRegistry.get(app.getName());
            res = this.getModuleScopedResource(jndiName, moduleName, BindableResource.class, appInfo);
        } else {
            res = ConnectorsUtil.getResourceByName(this.getResources(), BindableResource.class, jndiName);
        }
        if (res != null) {
            if (ConnectorResource.class.isAssignableFrom(res.getClass())) {
                ConnectorResource connResource = (ConnectorResource)res;
                String poolName = connResource.getPoolName();
                ApplicationInfo appInfo2 = this.appRegistry.get(app.getName());
                Resource pool = jndiName.startsWith("java:app/") ? this.getApplicationScopedResource(poolName, ResourcePool.class, appInfo2) : (jndiName.startsWith("java:module/") ? this.getModuleScopedResource(poolName, moduleName, ResourcePool.class, appInfo2) : ConnectorsUtil.getResourceByName(this.getResources(), ResourcePool.class, poolName));
                if (ConnectorConnectionPool.class.isAssignableFrom(pool.getClass())) {
                    String raName = ((ConnectorConnectionPool)pool).getResourceAdapterName();
                    app.addResourceAdapter(raName);
                }
            } else if (AdminObjectResource.class.isAssignableFrom(res.getClass())) {
                String raName = ((AdminObjectResource)res).getResAdapter();
                app.addResourceAdapter(raName);
            }
        } else {
            boolean found = false;
            List applications = this.getApplications().getApplicationsWithSnifferType("connector", true);
            block0: for (com.sun.enterprise.config.serverbeans.Application application : applications) {
                String appName = application.getName();
                ApplicationInfo appInfo3 = this.appRegistry.get(appName);
                Application dolApp = (Application)appInfo3.getMetaData(Application.class);
                Set rarDescriptors = dolApp.getBundleDescriptors(ConnectorDescriptor.class);
                for (ConnectorDescriptor desc : rarDescriptors) {
                    SunConnector sunraDesc = desc.getSunDescriptor();
                    if (sunraDesc != null) {
                        String sunRAJndiName = (String)sunraDesc.getResourceAdapter().getValue("JndiName");
                        if (!jndiName.equals(sunRAJndiName)) continue;
                        app.addResourceAdapter(desc.getName());
                        found = true;
                        continue block0;
                    }
                    if (!desc.getDefaultResourcesNames().contains(jndiName)) continue;
                    app.addResourceAdapter(desc.getName());
                    found = true;
                    continue block0;
                }
            }
            if (!found && DOLUtils.getDefaultLogger().isLoggable(Level.FINEST)) {
                DOLUtils.getDefaultLogger().log(Level.FINEST, "could not find resource by name : " + jndiName);
            }
        }
    }

    private <T> Resource getApplicationScopedResource(String name, Class<T> type, ApplicationInfo appInfo) {
        Resource foundRes = null;
        if (appInfo != null) {
            com.sun.enterprise.config.serverbeans.Application app = (com.sun.enterprise.config.serverbeans.Application)appInfo.getTransientAppMetaData("application", com.sun.enterprise.config.serverbeans.Application.class);
            Resources resources = null;
            if (app != null) {
                resources = (Resources)appInfo.getTransientAppMetaData(app.getName() + "-resources", Resources.class);
            }
            if (resources != null) {
                boolean bindableResource = BindableResource.class.isAssignableFrom(type);
                boolean poolResource = ResourcePool.class.isAssignableFrom(type);
                boolean workSecurityMap = WorkSecurityMap.class.isAssignableFrom(type);
                boolean rac = ResourceAdapterConfig.class.isAssignableFrom(type);
                Iterator itr = resources.getResources().iterator();
                while (itr.hasNext()) {
                    String resourceName = null;
                    Resource res = (Resource)itr.next();
                    if (bindableResource && res instanceof BindableResource) {
                        resourceName = ((BindableResource)res).getJndiName();
                    } else if (poolResource && res instanceof ResourcePool) {
                        resourceName = ((ResourcePool)res).getName();
                    } else if (rac && res instanceof ResourceAdapterConfig) {
                        resourceName = ((ResourceAdapterConfig)res).getName();
                    } else if (workSecurityMap && res instanceof WorkSecurityMap) {
                        resourceName = ((WorkSecurityMap)res).getName();
                    }
                    if (resourceName == null) continue;
                    if (!resourceName.startsWith("java:app/")) {
                        resourceName = "java:app/" + resourceName;
                    }
                    if (!name.startsWith("java:app/")) {
                        name = "java:app/" + name;
                    }
                    if (!name.equals(resourceName)) continue;
                    foundRes = res;
                    break;
                }
            }
        }
        return foundRes;
    }

    private <T> Resource getModuleScopedResource(String name, String moduleName, Class<T> type, ApplicationInfo appInfo) {
        Resource foundRes = null;
        if (appInfo != null) {
            com.sun.enterprise.config.serverbeans.Application app = (com.sun.enterprise.config.serverbeans.Application)appInfo.getTransientAppMetaData("application", com.sun.enterprise.config.serverbeans.Application.class);
            Resources resources = null;
            if (app != null) {
                Module module = null;
                List modules = app.getModule();
                for (Module m : modules) {
                    if (!ConnectorsUtil.getActualModuleName(m.getName()).equals(moduleName)) continue;
                    module = m;
                    break;
                }
                if (module != null) {
                    resources = (Resources)appInfo.getTransientAppMetaData(module.getName() + "-resources", Resources.class);
                }
            }
            if (resources != null) {
                boolean bindableResource = BindableResource.class.isAssignableFrom(type);
                boolean poolResource = ResourcePool.class.isAssignableFrom(type);
                boolean workSecurityMap = WorkSecurityMap.class.isAssignableFrom(type);
                boolean rac = ResourceAdapterConfig.class.isAssignableFrom(type);
                Iterator itr = resources.getResources().iterator();
                while (itr.hasNext()) {
                    String resourceName = null;
                    Resource res = (Resource)itr.next();
                    if (bindableResource && res instanceof BindableResource) {
                        resourceName = ((BindableResource)res).getJndiName();
                    } else if (poolResource && res instanceof ResourcePool) {
                        resourceName = ((ResourcePool)res).getName();
                    } else if (rac && res instanceof ResourceAdapterConfig) {
                        resourceName = ((ResourceAdapterConfig)res).getName();
                    } else if (workSecurityMap && res instanceof WorkSecurityMap) {
                        resourceName = ((WorkSecurityMap)res).getName();
                    }
                    if (resourceName == null) continue;
                    if (!resourceName.startsWith("java:module/")) {
                        resourceName = "java:module/" + resourceName;
                    }
                    if (!name.startsWith("java:module/")) {
                        name = "java:module/" + name;
                    }
                    if (!name.equals(resourceName)) continue;
                    foundRes = res;
                    break;
                }
            }
        }
        return foundRes;
    }

    public Collection<ConnectorClassFinder> getSystemRARClassLoaders() {
        try {
            return this.getConnectorsClassLoaderUtil().getSystemRARClassLoaders();
        }
        catch (ConnectorRuntimeException cre) {
            throw new RuntimeException(cre.getMessage(), cre);
        }
    }

    public boolean useGlobalConnectorClassLoader() {
        String classLoadingPolicy;
        boolean flag = false;
        ConnectorService connectorService = this.connectorServiceProvider.get();
        if (connectorService != null && (classLoadingPolicy = connectorService.getClassLoadingPolicy()) != null && classLoadingPolicy.equals("global")) {
            flag = true;
        }
        return flag;
    }

    public Collection<String> getRequiredResourceAdapters(String appName) {
        Property property;
        ConnectorService connectorService;
        ArrayList<String> requiredRars = new ArrayList<String>();
        if (appName != null && (connectorService = this.connectorServiceProvider.get()) != null && appName.trim().length() > 0 && (property = connectorService.getProperty(appName.trim())) != null) {
            String requiredRarsString = property.getValue();
            StringTokenizer tokenizer = new StringTokenizer(requiredRarsString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                requiredRars.add(token);
            }
        }
        return requiredRars;
    }

    private ConnectorsClassLoaderUtil getConnectorsClassLoaderUtil() {
        return this.connectorsClassLoaderUtilProvider.get();
    }

    private Resources getResources() {
        return this.domainProvider.get().getResources();
    }

    private Applications getApplications() {
        return this.applicationsProvider.get();
    }
}

