/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors.handler;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.el.PermissionChecker;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.ELOutputType;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.layout.descriptors.handler.OutputMapping;
import com.sun.jsftemplating.layout.descriptors.handler.OutputType;
import com.sun.jsftemplating.layout.event.UIComponentHolder;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.TypeConverter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class Handler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HandlerDefinition _handlerDef = null;
    private String _condition = null;
    private List<Handler> _childHandlers = _emptyList;
    private Map<String, Object> _inputs = new HashMap<String, Object>();
    private Map<String, OutputMapping> _outputs = new HashMap<String, OutputMapping>();
    private static final List<Handler> _emptyList = new ArrayList<Handler>(0);

    public Handler(HandlerDefinition handlerDef) {
        this.setHandlerDefinition(handlerDef);
    }

    public HandlerDefinition getHandlerDefinition() {
        return this._handlerDef;
    }

    protected void setHandlerDefinition(HandlerDefinition handler) {
        this._handlerDef = handler;
    }

    public void setInputValue(String name, Object value) {
        IODescriptor inDesc = this.getHandlerDefinition().getInputDef(name);
        if (inDesc == null) {
            throw new RuntimeException("Attempted to set input value '" + name + "' with value '" + value + "', however, '" + name + "' is not a declared input parameter in HandlerDefinition '" + this.getHandlerDefinition().getId() + "'!");
        }
        this._inputs.put(name, value);
    }

    protected Map<String, Object> getInputMap() {
        return this._inputs;
    }

    public Object getInputValue(String name) {
        return this._inputs.get(name);
    }

    public Object getInputValue(HandlerContext ctx, String name) {
        Object src;
        IODescriptor inDesc = this.getHandlerDefinition().getInputDef(name);
        FacesContext facesCtx = ctx.getFacesContext();
        if (inDesc == null) {
            throw new RuntimeException("Attempted to get input value '" + name + "', however, this is not a declared input " + "parameter in handler definition '" + this.getHandlerDefinition().getId() + "'!  Check your handler " + " and/or the XML (near LayoutElement '" + ctx.getLayoutElement().getId(facesCtx, null) + "')");
        }
        Object value = this.getInputValue(name);
        if (value == null) {
            if (inDesc.isRequired()) {
                throw new RuntimeException("'" + name + "' is required for handler '" + this.getHandlerDefinition().getId() + "'!");
            }
            value = inDesc.getDefault();
        }
        EventObject event = ctx.getEventObject();
        UIComponent component = null;
        if (event instanceof UIComponentHolder) {
            component = ((UIComponentHolder)((Object)event)).getUIComponent();
        } else if (event != null && (src = event.getSource()) instanceof UIComponent) {
            component = (UIComponent)src;
        }
        value = ComponentUtil.getInstance(facesCtx).resolveValue(facesCtx, ctx.getLayoutElement(), component, value);
        value = TypeConverter.asType(inDesc.getType(), value);
        return value;
    }

    public Object getOutputValue(HandlerContext context, String name) {
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        IODescriptor outIODesc = handlerDef.getOutputDef(name);
        if (outIODesc == null) {
            throw new RuntimeException("Attempted to get output value '" + name + "' from handler '" + handlerDef.getId() + "', however, this is not a declared output parameter!  " + "Check your handler and/or the XML.");
        }
        OutputMapping outputDesc = this.getOutputValue(name);
        return outputDesc.getOutputType().getValue(context, outIODesc, outputDesc.getOutputKey());
    }

    public void setOutputValue(HandlerContext context, String name, Object value) {
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        IODescriptor outIODesc = handlerDef.getOutputDef(name);
        if (outIODesc == null) {
            throw new RuntimeException("Attempted to set output value '" + name + "' from handler '" + handlerDef.getId() + "', however, this is not a declared output parameter!  " + "Check your handler and/or the XML.");
        }
        OutputMapping outputMapping = this.getOutputValue(name);
        if (outputMapping == null) {
            return;
        }
        value = TypeConverter.asType(outIODesc.getType(), value);
        EventObject event = context.getEventObject();
        UIComponent component = null;
        if (event instanceof UIComponentHolder) {
            component = ((UIComponentHolder)((Object)event)).getUIComponent();
        }
        OutputType outType = outputMapping.getOutputType();
        String outputKey = outputMapping.getOutputKey();
        if (!(outType instanceof ELOutputType)) {
            FacesContext ctx = context.getFacesContext();
            outputKey = "" + ComponentUtil.getInstance(ctx).resolveValue(ctx, context.getLayoutElement(), component, outputKey);
        }
        outType.setValue(context, outIODesc, outputKey, value);
    }

    public void setOutputMapping(String outputName, String targetKey, String targetType) {
        if (this.getHandlerDefinition().getOutputDef(outputName) == null) {
            throw new IllegalArgumentException("Handler named '" + this.getHandlerDefinition().getId() + "' does not declare output " + "mapping named '" + outputName + "'.");
        }
        if (targetKey != null && (targetKey = targetKey.trim()).length() == 0) {
            targetKey = null;
        }
        targetType = targetType.trim();
        try {
            this._outputs.put(outputName, new OutputMapping(outputName, targetKey, targetType));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to create OutputMapping with given information: outputName='" + outputName + "', targetKey='" + targetKey + "', targetType=" + targetType + "'", ex);
        }
    }

    public OutputMapping getOutputValue(String name) {
        return this._outputs.get(name);
    }

    public String getCondition() {
        return this._condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        this._condition = cond;
    }

    public boolean isStatic() {
        return this.getHandlerDefinition().isStatic();
    }

    public void addChildHandler(Handler desc) {
        if (this._childHandlers == _emptyList) {
            this._childHandlers = new ArrayList<Handler>();
        }
        this._childHandlers.add(desc);
    }

    public void setChildHandlers(List<Handler> childHandlers) {
        if (childHandlers == null || childHandlers.size() == 0) {
            childHandlers = _emptyList;
        }
        this._childHandlers = childHandlers;
    }

    public List<Handler> getChildHandlers() {
        return this._childHandlers;
    }

    public Object invoke(HandlerContext handlerContext) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        if (this.hasPermission(handlerContext)) {
            Method method = handlerDef.getHandlerMethod();
            if (method != null) {
                Object instance = null;
                if (!this.isStatic()) {
                    instance = method.getDeclaringClass().newInstance();
                }
                result = method.invoke(instance, handlerContext);
            }
            if (result == null || !result.toString().equals("false")) {
                List<Handler> handlers = handlerDef.getChildHandlers();
                Object retVal = null;
                LayoutElement elt = handlerContext.getLayoutElement();
                if (handlers.size() > 0 && (retVal = elt.dispatchHandlers(handlerContext, handlers)) != null) {
                    result = retVal;
                }
                if ((handlers = this.getChildHandlers()).size() > 0 && (retVal = elt.dispatchHandlers(handlerContext, handlers)) != null) {
                    result = retVal;
                }
            }
        } else if (LogUtil.finerEnabled()) {
            LogUtil.finer("Handler '" + handlerDef.getId() + "' skipped because condition not met: '" + this.getCondition() + "'.");
        }
        return result;
    }

    public boolean hasPermission(HandlerContext handlerContext) {
        String cond = this.getCondition();
        if (cond == null || cond.equals("")) {
            return true;
        }
        UIComponent comp = null;
        Object obj = handlerContext.getEventObject().getSource();
        if (obj instanceof UIComponent) {
            comp = (UIComponent)obj;
        }
        PermissionChecker checker = new PermissionChecker(handlerContext.getLayoutElement(), comp, cond);
        return checker.hasPermission();
    }
}

