/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.HashableKey;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.shoal.adapter.store.ReplicatedBackingStore;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.TouchCommand;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.mapper.DefaultKeyMapper;

public class CommandManagerShell {
    BackingStore<MyKey, SimpleMetadata> ds;
    ConcurrentHashMap<MyKey, SimpleMetadata> cache = new ConcurrentHashMap();
    CommandManager<MyKey, SimpleMetadata> cm;
    int counter = 0;

    public static void main(String[] args) throws Exception {
        DefaultKeyMapper keyMapper = new DefaultKeyMapper(args[0], args[1]);
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        conf.setStoreName("shoal-cache").setInstanceName(args[0]).setClusterName(args[1]).setKeyClazz(MyKey.class).setValueClazz(SimpleMetadata.class).setClassLoader(ClassLoader.getSystemClassLoader());
        Map map = conf.getVendorSpecificSettings();
        map.put("start.gms", true);
        map.put("class.loader", ClassLoader.getSystemClassLoader());
        map.put("async.replication", false);
        BackingStore ds = new ReplicatedBackingStoreFactory().createBackingStore(conf);
        CommandManagerShell main = new CommandManagerShell();
        main.runShell(ds);
    }

    private void runShell(BackingStore<MyKey, SimpleMetadata> ds) {
        this.cm = ((ReplicatedBackingStore)ds).getDataStoreContext().getCommandManager();
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (BackingStoreException bsEx) {
                bsEx.printStackTrace();
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print("" + this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) throws DataStoreException, BackingStoreException {
        if ("save".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], params[0]);
            long now = System.currentTimeMillis();
            String[] versionString = params[1].split(",");
            int sz = versionString.length;
            SimpleMetadata[] smds = new SimpleMetadata[sz];
            long[] versions = new long[sz];
            for (int i = 0; i < sz; ++i) {
                versions[i] = Long.valueOf(versionString[i]);
                smds[i] = new SimpleMetadata(versions[i], System.currentTimeMillis(), 600000L, ("Value::" + versions[i]).getBytes());
                SimpleMetadata st = smds[i];
                SaveCommand<MyKey, SimpleMetadata> sc = new SaveCommand<MyKey, SimpleMetadata>(key, st, st.getVersion(), st.getLastAccessTime(), st.getMaxInactiveInterval());
                this.cm.execute(sc);
                System.out.println("Saved: " + st);
            }
        } else if ("load".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], null);
            SimpleMetadata st = (SimpleMetadata)this.ds.load((Serializable)key, params.length > 1 ? params[1] : null);
            if (st != null) {
                System.out.println("get(" + params[0] + ") => " + st + " ==> " + st);
                this.cache.put(key, st);
            } else {
                System.out.println("get(" + params[0] + ") NOT FOUND ==> null");
            }
        } else if ("touch".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], params[0]);
            long now = System.currentTimeMillis();
            long version = Long.valueOf(params[1]);
            TouchCommand tc = new TouchCommand(key, version, now, 3000000L);
            this.cm.execute(tc);
            System.out.println("Touched: " + tc);
        } else if ("remove".equalsIgnoreCase(command)) {
            MyKey key = new MyKey(params[0], null);
            this.ds.remove((Serializable)key);
        }
    }

    private static class MyKey
    implements Serializable,
    HashableKey {
        String myKey;
        String rootKey;

        MyKey(String myKey, String rootKey) {
            this.myKey = myKey;
            this.rootKey = rootKey;
        }

        public Object getHashKey() {
            return this.rootKey;
        }

        public int hashCode() {
            return this.myKey.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof MyKey) {
                MyKey k2 = (MyKey)other;
                return k2.myKey.equals(this.myKey);
            }
            return false;
        }

        public String toString() {
            return this.myKey;
        }
    }
}

