/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.AnnotationUtil;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.ParamDefaultCalculator;
import org.glassfish.api.UnknownOptionsAreOperands;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.config.ModelBinding;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;

public class CommandModelImpl
extends CommandModel {
    private final Map<String, CommandModel.ParamModel> params;
    private final String commandName;
    private final Class<?> commandClass;
    private final ExecuteOn execOn;
    private final I18n i18n;
    private final boolean dashOk;
    private final LocalStringManager localStrings;
    private boolean managedJob;

    public CommandModelImpl(Class<?> commandType) {
        Service service = commandType.getAnnotation(Service.class);
        this.commandName = service != null ? service.name() : null;
        this.commandClass = commandType;
        this.i18n = commandType.getAnnotation(I18n.class);
        this.execOn = commandType.getAnnotation(ExecuteOn.class);
        this.localStrings = new LocalStringManagerImpl(commandType);
        this.managedJob = AnnotationUtil.presentTransitive(ManagedJob.class, commandType);
        this.params = CommandModelImpl.init(commandType, this.i18n, this.localStrings);
        boolean found = false;
        for (Class<?> currentClazz = commandType; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            if (!currentClazz.isAnnotationPresent(UnknownOptionsAreOperands.class)) continue;
            found = true;
        }
        this.dashOk = found;
    }

    public static Map<String, CommandModel.ParamModel> init(Class commandType, I18n i18n, LocalStringManager localStrings) {
        LinkedHashMap<String, CommandModel.ParamModel> results = new LinkedHashMap<String, CommandModel.ParamModel>();
        for (Class currentClazz = commandType; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            I18n fieldI18n;
            for (Field field : currentClazz.getDeclaredFields()) {
                fieldI18n = field.getAnnotation(I18n.class);
                if (fieldI18n != null) {
                    localStrings = new LocalStringManagerImpl(commandType);
                }
                CommandModelImpl.add(results, field, i18n, localStrings);
            }
            for (AccessibleObject accessibleObject : currentClazz.getDeclaredMethods()) {
                fieldI18n = ((Method)accessibleObject).getAnnotation(I18n.class);
                if (fieldI18n != null) {
                    localStrings = new LocalStringManagerImpl(commandType);
                }
                CommandModelImpl.add(results, accessibleObject, i18n, localStrings);
            }
        }
        return results;
    }

    public String getLocalizedDescription() {
        if (this.i18n != null) {
            return this.localStrings.getLocalString(this.i18n.value(), "");
        }
        return null;
    }

    public String getUsageText() {
        if (this.i18n != null) {
            return this.localStrings.getLocalString(this.i18n.value() + ".usagetext", null);
        }
        return null;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandModel.ParamModel getModelFor(String paramName) {
        return this.params.get(paramName);
    }

    public Collection<String> getParametersNames() {
        return this.params.keySet();
    }

    public Class<?> getCommandClass() {
        return this.commandClass;
    }

    public ExecuteOn getClusteringAttributes() {
        return this.execOn;
    }

    public boolean isManagedJob() {
        return this.managedJob;
    }

    public void setManagedJob(boolean value) {
        this.managedJob = value;
    }

    public boolean unknownOptionsAreOperands() {
        return this.dashOk;
    }

    public void addParam(String name, CommandModel.ParamModel param) {
        this.params.put(name, param);
    }

    private static void add(Map<String, CommandModel.ParamModel> results, AnnotatedElement e, I18n parentI18n, LocalStringManager localStrings) {
        Param param = e.getAnnotation(Param.class);
        if (param != null) {
            ParamModelImpl model;
            String defaultValue = param.defaultValue();
            ModelBinding mb = e.getAnnotation(ModelBinding.class);
            if (mb != null && defaultValue.isEmpty()) {
                Attribute attr;
                Method m = null;
                try {
                    m = mb.type().getMethod(mb.getterMethodName(), new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
                if (m != null && (attr = m.getAnnotation(Attribute.class)) != null) {
                    defaultValue = attr.defaultValue();
                }
            }
            if (!results.containsKey((model = new ParamModelImpl(e, defaultValue, parentI18n, localStrings)).getName())) {
                results.put(model.getName(), model);
            }
        }
    }

    public void add(CommandModel.ParamModel model) {
        if (!this.params.containsKey(model.getName())) {
            this.params.put(model.getName(), model);
        }
    }

    private static class ParamModelImpl
    extends CommandModel.ParamModel {
        private final String name;
        private final Param param;
        private final I18n i18n;
        private final I18n parentI18n;
        private final LocalStringManager localStrings;
        private final Class type;
        private final String defaultValue;

        ParamModelImpl(AnnotatedElement e, String defaultValue, I18n parentI18n, LocalStringManager localStrings) {
            Param p = e.getAnnotation(Param.class);
            this.parentI18n = parentI18n;
            this.localStrings = localStrings;
            this.name = CommandModel.getParamName((Param)p, (AnnotatedElement)e);
            this.defaultValue = defaultValue;
            this.param = p;
            this.i18n = e.getAnnotation(I18n.class);
            this.type = e instanceof Method ? ((Method)e).getReturnType() : (e instanceof Field ? ((Field)e).getType() : String.class);
        }

        public String getName() {
            return this.name;
        }

        public Param getParam() {
            return new Param(){

                public String name() {
                    return ParamModelImpl.this.param.name();
                }

                public String acceptableValues() {
                    return ParamModelImpl.this.param.acceptableValues();
                }

                public boolean optional() {
                    return ParamModelImpl.this.param.optional();
                }

                public String shortName() {
                    return ParamModelImpl.this.param.shortName();
                }

                public boolean primary() {
                    return ParamModelImpl.this.param.primary();
                }

                public String defaultValue() {
                    return ParamModelImpl.this.defaultValue;
                }

                public Class<? extends ParamDefaultCalculator> defaultCalculator() {
                    return ParamModelImpl.this.param.defaultCalculator();
                }

                public boolean password() {
                    return ParamModelImpl.this.param.password();
                }

                public char separator() {
                    return ParamModelImpl.this.param.separator();
                }

                public boolean multiple() {
                    return ParamModelImpl.this.param.multiple();
                }

                public boolean obsolete() {
                    return ParamModelImpl.this.param.obsolete();
                }

                public String alias() {
                    return ParamModelImpl.this.param.alias();
                }

                public Class<? extends Annotation> annotationType() {
                    return ParamModelImpl.this.param.annotationType();
                }
            };
        }

        private String getLocalizedString(String type) {
            String paramDesc = null;
            if (this.i18n != null) {
                paramDesc = this.localStrings.getLocalString(this.i18n.value() + type, "");
            } else if (this.parentI18n != null) {
                paramDesc = this.localStrings.getLocalString(this.parentI18n.value() + "." + this.name + type, "");
            }
            if (paramDesc == null) {
                paramDesc = "";
            }
            return paramDesc;
        }

        public String getLocalizedDescription() {
            return this.getLocalizedString("");
        }

        public String getLocalizedPrompt() {
            return this.getLocalizedString(".prompt");
        }

        public String getLocalizedPromptAgain() {
            return this.getLocalizedString(".promptAgain");
        }

        public I18n getI18n() {
            return this.i18n;
        }

        public Class getType() {
            return this.type;
        }
    }
}

