/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class DelegatingClassLoader
extends ClassLoader {
    private String name;
    private List<ClassFinder> delegates = new ArrayList<ClassFinder>();

    public DelegatingClassLoader(ClassLoader parent, List<ClassFinder> delegates) throws IllegalArgumentException {
        super(parent);
        for (ClassFinder d : delegates) {
            this.checkDelegate(d);
        }
        this.delegates.addAll(delegates);
    }

    public DelegatingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized boolean addDelegate(ClassFinder d) throws IllegalStateException, IllegalArgumentException {
        this.checkDelegate(d);
        if (this.delegates.contains(d)) {
            return false;
        }
        return this.delegates.add(d);
    }

    private void checkDelegate(ClassFinder d) throws IllegalArgumentException {
        ClassLoader p;
        ClassLoader dp = d.getParent();
        if (dp != (p = this.getParent()) && (dp != null && !dp.equals(p) || !p.equals(dp))) {
            throw new IllegalArgumentException("Delegation hierarchy mismatch");
        }
    }

    public synchronized boolean removeDelegate(ClassFinder d) {
        return this.delegates.remove(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassFinder d : this.delegates) {
            try {
                Class<?> c = null;
                ClassFinder classFinder = d;
                synchronized (classFinder) {
                    c = d.findExistingClass(name);
                    if (c == null) {
                        c = d.findClass(name);
                    }
                }
                return c;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassFinder d : this.delegates) {
            URL u = d.findResource(name);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
        for (ClassFinder delegate : this.delegates) {
            Enumeration<URL> enumerator = delegate.findResources(name);
            enumerators.add(enumerator);
        }
        return new CompositeEnumeration(enumerators);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ClassFinder> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public static interface ClassFinder {
        public ClassLoader getParent();

        public Class<?> findClass(String var1) throws ClassNotFoundException;

        public Class<?> findExistingClass(String var1);

        public URL findResource(String var1);

        public Enumeration<URL> findResources(String var1) throws IOException;
    }
}

