/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.io;

import com.sun.enterprise.deployment.node.J2EEDocumentBuilder;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.SaxParserHandlerFactory;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DeploymentDescriptorFile<T extends Descriptor> {
    public static final String FULL_VALIDATION = "full";
    public static final String PARSING_VALIDATION = "parsing";
    private boolean xmlValidation = true;
    private String validationLevel = "parsing";
    private String errorReportingString = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentDescriptorFile.class);
    private ArchiveType archiveType;

    public SAXParser getSAXParser() {
        return this.getSAXParser(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAXParser getSAXParser(boolean validating) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(validating);
            if (spf.getClass().getName().indexOf("xerces") != -1) {
                spf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            } else {
                DOLUtils.getDefaultLogger().log(Level.WARNING, "modify your java command line to include the -Djava.endorsed.dirs option");
            }
            try {
                if (!validating && this.getDeploymentDescriptorPath().indexOf("weblogic") != -1) {
                    spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                spf.setFeature("http://apache.org/xml/features/validation/schema", validating);
                SAXParser sp = spf.newSAXParser();
                String path = this.getDefaultSchemaSource();
                if (path != null) {
                    sp.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", path);
                }
                sp.getXMLReader().setFeature("http://apache.org/xml/features/validation/dynamic", validating);
                SAXParser sAXParser = sp;
                return sAXParser;
            }
            catch (SAXNotRecognizedException x) {
                try {
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "INFO: JAXP SAXParser property not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "Check to see if parser conforms to JAXP 1.2 spec.");
                    Thread.currentThread().setContextClassLoader(currentLoader);
                }
                catch (Exception e) {
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        return null;
    }

    public DocumentBuilder getDocumentBuilder(boolean validating) {
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            System.clearProperty("javax.xml.parsers.DocumentBuilderFactory");
            dbf.setNamespaceAware(true);
            dbf.setValidating(validating);
            try {
                String path = this.getDefaultSchemaSource();
                if (path != null) {
                    dbf.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", path);
                }
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException x) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "Error: JAXP DOMParser property not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "Check to see if parser conforms to JAXP 1.2 spec.");
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
        }
        return null;
    }

    public T read(InputStream is) throws IOException, SAXParseException {
        return this.read(null, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(T descriptor, File in) throws IOException, SAXParseException {
        try (FileInputStream fis = new FileInputStream(in);){
            T t = this.read(descriptor, fis);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(T descriptor, ReadableArchive in) throws IOException, SAXParseException {
        try (InputStream is = in.getEntry(this.getDeploymentDescriptorPath());){
            T t = this.read(descriptor, is);
            return t;
        }
    }

    public T read(T descriptor, InputStream is) throws IOException, SAXParseException {
        this.errorReportingString = FileUtils.revertFriendlyFilenameExtension((String)this.errorReportingString);
        String error = this.errorReportingString == null ? this.errorReportingString : new File(this.errorReportingString).getName();
        String errorReporting = localStrings.getLocalString("enterprise.deployment.io.errorcontext", "archive {0} and deployment descriptor file {1}", new Object[]{error, this.getDeploymentDescriptorPath()});
        SAXParser sp = this.getSAXParser(this.getXMLValidation());
        SaxParserHandler dh = SaxParserHandlerFactory.newInstance();
        if (this.validationLevel.equals(FULL_VALIDATION)) {
            dh.setStopOnError(true);
        }
        if (descriptor != null) {
            dh.setTopNode(this.getRootXMLNode(descriptor));
        }
        dh.setErrorReportingString(errorReporting);
        InputSource input = new InputSource(is);
        try {
            sp.parse(input, (DefaultHandler)dh);
        }
        catch (SAXParseException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            errorReporting = errorReporting + "  " + e.getLocalizedMessage();
            SAXParseException spe = new SAXParseException(errorReporting, e.getSystemId(), e.getPublicId(), e.getLineNumber(), e.getColumnNumber(), e);
            throw spe;
        }
        catch (SAXException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "Error occurred", e);
            return null;
        }
        catch (IOException e) {
            Object[] objectArray;
            Logger logger = DOLUtils.getDefaultLogger();
            if (e.getMessage() == null) {
                objectArray = "";
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = e.getMessage();
            }
            logger.log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", (Object)objectArray);
            for (StackTraceElement stElement : e.getStackTrace()) {
                if (!stElement.getClassName().equals("java.net.Socket") || !stElement.getMethodName().equals("connect")) continue;
                String msg = localStrings.getLocalString("enterprise.deployment.can_not_locate_dtd", "Unable to locate the DTD to validate your deployment descriptor file [{1}] in archive [{0}]. Please make sure the DOCTYPE is correct (no typo in public ID or system ID) and you have proper access to the Internet.", new Object[]{error, this.getDeploymentDescriptorPath()});
                IOException ioe = new IOException(msg);
                ioe.initCause(e);
                throw ioe;
            }
            IOException ioe = new IOException(localStrings.getLocalString("enterprise.deployment.backend.error_parsing_descr", "Error parsing descriptor: {0}", new Object[]{errorReporting}));
            ioe.initCause(e);
            throw ioe;
        }
        if (dh.getTopNode() != null) {
            return (T)((Descriptor)((RootXMLNode)dh.getTopNode()).getDescriptor());
        }
        return null;
    }

    public Document getDocument(T descriptor) {
        return J2EEDocumentBuilder.getDocument(descriptor, this.getRootXMLNode(descriptor));
    }

    public void write(T descriptor, OutputStream os) throws IOException {
        try {
            J2EEDocumentBuilder.write(descriptor, this.getRootXMLNode(descriptor), os);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void write(T descriptor, String path) throws IOException {
        boolean ok;
        String dir;
        String fileName = this.getDeploymentDescriptorPath();
        if (fileName.lastIndexOf(47) != -1) {
            dir = path + File.separator + fileName.substring(0, fileName.lastIndexOf(47));
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        } else {
            dir = path;
        }
        File dirs = new File(dir.replace('/', File.separatorChar));
        if (!dirs.exists() && !(ok = dirs.mkdirs())) {
            throw new IOException(dirs.getAbsolutePath() + " not created");
        }
        File out = new File(dirs, fileName);
        this.write(descriptor, out);
    }

    public void write(T descriptor, File out) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(out);){
            this.write(descriptor, fos);
        }
    }

    public abstract String getDeploymentDescriptorPath();

    public abstract RootXMLNode<T> getRootXMLNode(T var1);

    protected boolean getXMLValidation() {
        return this.xmlValidation;
    }

    public void setXMLValidation(boolean validate) {
        this.xmlValidation = validate;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    protected String getDefaultSchemaSource() {
        List<String> systemIDs;
        RootXMLNode<Object> node = this.getRootXMLNode(null);
        if (node != null && (systemIDs = node.getSystemIDs()) != null) {
            StringBuilder path = new StringBuilder();
            for (String systemID : systemIDs) {
                if (path.length() > 0) {
                    path.append(' ');
                }
                path.append(systemID);
            }
            return path.toString();
        }
        return null;
    }

    public void setErrorReportingString(String s) {
        this.errorReportingString = s;
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(ArchiveType type) {
        this.archiveType = type;
    }
}

