/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;
import org.glassfish.logging.annotation.LogMessageInfo;

public class JDBCStore
extends StoreBase {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="SQL Error {0}", level="FINE")
    public static final String SQL_ERROR = "AS-WEB-CORE-00343";
    @LogMessageInfo(message="Loading Session {0} from database {1}", level="FINE")
    public static final String LOADING_SESSION = "AS-WEB-CORE-00344";
    @LogMessageInfo(message="Removing Session {0} at database {1}", level="FINE")
    public static final String REMOVING_SESSION = "AS-WEB-CORE-00345";
    @LogMessageInfo(message="Saving Session {0} to database {1}", level="FINE")
    public static final String SAVING_SESSION = "AS-WEB-CORE-00346";
    @LogMessageInfo(message="The database connection is null or was found to be closed. Trying to re-open it.", level="FINE")
    public static final String DATABASE_CONNECTION_CLOSED = "AS-WEB-CORE-00347";
    @LogMessageInfo(message="The re-open on the database failed. The database could be down.", level="FINE")
    public static final String RE_OPEN_DATABASE_FAILED = "AS-WEB-CORE-00348";
    @LogMessageInfo(message="A SQL exception occurred {0}", level="FINE")
    public static final String SQL_EXCEPTION = "AS-WEB-CORE-00349";
    @LogMessageInfo(message="JDBC driver class not found {0}", level="FINE")
    public static final String JDBC_DRIVER_CLASS_NOT_FOUND = "AS-WEB-CORE-00350";
    protected static final String info = "JDBCStore/1.0";
    private String name = null;
    protected static final String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connString = null;
    private Connection conn = null;
    protected String driverName = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionAppCol = "app";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    @Override
    public String getInfo() {
        return info;
    }

    public String getName() {
        if (this.name == null) {
            Container container = this.manager.getContainer();
            String contextName = container.getName();
            String hostName = "";
            String engineName = "";
            if (container.getParent() != null) {
                Container host = container.getParent();
                hostName = host.getName();
                if (host.getParent() != null) {
                    engineName = host.getParent().getName();
                }
            }
            this.name = "/" + engineName + "/" + hostName + contextName;
        }
        return this.name;
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    public void setDriverName(String driverName) {
        String oldDriverName = this.driverName;
        this.driverName = driverName;
        this.support.firePropertyChange("driverName", oldDriverName, this.driverName);
        this.driverName = driverName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setConnectionURL(String connectionURL) {
        String oldConnString = this.connString;
        this.connString = connectionURL;
        this.support.firePropertyChange("connString", oldConnString, this.connString);
    }

    public String getConnectionURL() {
        return this.connString;
    }

    public void setSessionTable(String sessionTable) {
        String oldSessionTable = this.sessionTable;
        this.sessionTable = sessionTable;
        this.support.firePropertyChange("sessionTable", oldSessionTable, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String sessionAppCol) {
        String oldSessionAppCol = this.sessionAppCol;
        this.sessionAppCol = sessionAppCol;
        this.support.firePropertyChange("sessionAppCol", oldSessionAppCol, this.sessionAppCol);
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        String oldSessionIdCol = this.sessionIdCol;
        this.sessionIdCol = sessionIdCol;
        this.support.firePropertyChange("sessionIdCol", oldSessionIdCol, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String sessionDataCol) {
        String oldSessionDataCol = this.sessionDataCol;
        this.sessionDataCol = sessionDataCol;
        this.support.firePropertyChange("sessionDataCol", oldSessionDataCol, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        String oldSessionValidCol = this.sessionValidCol;
        this.sessionValidCol = sessionValidCol;
        this.support.firePropertyChange("sessionValidCol", oldSessionValidCol, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        String oldSessionMaxInactiveCol = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
        this.support.firePropertyChange("sessionMaxInactiveCol", oldSessionMaxInactiveCol, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        String oldSessionLastAccessedCol = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = sessionLastAccessedCol;
        this.support.firePropertyChange("sessionLastAccessedCol", oldSessionLastAccessedCol, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] keys() throws IOException {
        String keysSql = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        ResultSet rst = null;
        String[] keys = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return new String[0];
            }
            try {
                if (this.preparedKeysSql == null) {
                    this.preparedKeysSql = _conn.prepareStatement(keysSql);
                }
                this.preparedKeysSql.setString(1, this.getName());
                rst = this.preparedKeysSql.executeQuery();
                ArrayList<String> tmpkeys = new ArrayList<String>();
                if (rst != null) {
                    while (rst.next()) {
                        tmpkeys.add(rst.getString(1));
                    }
                }
                keys = tmpkeys.toArray(new String[tmpkeys.size()]);
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            finally {
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e) {}
                this.release(_conn);
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        ResultSet rst = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return size;
            }
            try {
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = _conn.prepareStatement(sizeSql);
                }
                this.preparedSizeSql.setString(1, this.getName());
                rst = this.preparedSizeSql.executeQuery();
                if (rst.next()) {
                    size = rst.getInt(1);
                }
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            finally {
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e) {}
                this.release(_conn);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        ResultSet rst = null;
        StandardSession _session = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream ois = null;
        BufferedInputStream bis = null;
        Container container = this.manager.getContainer();
        String loadSql = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return null;
            }
            try {
                if (this.preparedLoadSql == null) {
                    this.preparedLoadSql = _conn.prepareStatement(loadSql);
                }
                this.preparedLoadSql.setString(1, id);
                this.preparedLoadSql.setString(2, this.getName());
                rst = this.preparedLoadSql.executeQuery();
                if (rst.next()) {
                    bis = new BufferedInputStream(rst.getBinaryStream(2));
                    if (container != null) {
                        loader = container.getLoader();
                    }
                    if (loader != null) {
                        classLoader = loader.getClassLoader();
                    }
                    ois = classLoader != null ? new CustomObjectInputStream(bis, classLoader) : new ObjectInputStream(bis);
                    if (this.debug > 0) {
                        String msg = MessageFormat.format(rb.getString(LOADING_SESSION), id, this.sessionTable);
                        this.log(msg);
                    }
                    _session = StandardSession.deserialize(ois, this.manager);
                    _session.setManager(this.manager);
                } else if (this.debug > 0) {
                    this.log(this.getStoreName() + ": No persisted data object found");
                }
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            finally {
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException e) {}
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {}
                }
                this.release(_conn);
            }
        }
        return _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) throws IOException {
        String removeSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return;
            }
            try {
                if (this.preparedRemoveSql == null) {
                    this.preparedRemoveSql = _conn.prepareStatement(removeSql);
                }
                this.preparedRemoveSql.setString(1, id);
                this.preparedRemoveSql.setString(2, this.getName());
                this.preparedRemoveSql.execute();
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            finally {
                this.release(_conn);
            }
        }
        if (this.debug > 0) {
            String msg = MessageFormat.format(rb.getString(REMOVING_SESSION), id, this.sessionTable);
            this.log(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        String clearSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return;
            }
            try {
                if (this.preparedClearSql == null) {
                    this.preparedClearSql = _conn.prepareStatement(clearSql);
                }
                this.preparedClearSql.setString(1, this.getName());
                this.preparedClearSql.execute();
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            finally {
                this.release(_conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        String saveSql = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        InputStream in = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            Connection _conn = this.getConnection();
            if (_conn == null) {
                return;
            }
            this.remove(session.getIdInternal());
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                oos.writeObject(session);
                oos.close();
                byte[] obs = bos.toByteArray();
                int size = obs.length;
                bis = new ByteArrayInputStream(obs, 0, size);
                in = new BufferedInputStream(bis, size);
                if (this.preparedSaveSql == null) {
                    this.preparedSaveSql = _conn.prepareStatement(saveSql);
                }
                this.preparedSaveSql.setString(1, session.getIdInternal());
                this.preparedSaveSql.setString(2, this.getName());
                this.preparedSaveSql.setBinaryStream(3, in, size);
                this.preparedSaveSql.setString(4, session.isValid() ? "1" : "0");
                this.preparedSaveSql.setInt(5, session.getMaxInactiveInterval());
                this.preparedSaveSql.setLong(6, session.getLastAccessedTime());
                this.preparedSaveSql.execute();
            }
            catch (SQLException e) {
                String msg = MessageFormat.format(rb.getString(SQL_ERROR), e);
                this.log(msg);
            }
            catch (IOException e) {
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
                this.release(_conn);
            }
        }
        if (this.debug > 0) {
            String msg = MessageFormat.format(rb.getString(SAVING_SESSION), session.getIdInternal(), this.sessionTable);
            this.log(msg);
        }
    }

    protected Connection getConnection() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Class.forName(this.driverName);
                String databaseConnClosedMsg = rb.getString(DATABASE_CONNECTION_CLOSED);
                this.log(databaseConnClosedMsg);
                this.conn = DriverManager.getConnection(this.connString);
                this.conn.setAutoCommit(true);
                if (this.conn == null || this.conn.isClosed()) {
                    String openDatabaseFailedMsg = rb.getString(RE_OPEN_DATABASE_FAILED);
                    this.log(openDatabaseFailedMsg);
                }
            }
        }
        catch (SQLException ex) {
            String msg = MessageFormat.format(rb.getString(SQL_EXCEPTION), ex.toString());
            this.log(msg);
        }
        catch (ClassNotFoundException ex) {
            String msg = MessageFormat.format(rb.getString(JDBC_DRIVER_CLASS_NOT_FOUND), ex.toString());
            this.log(msg);
        }
        return this.conn;
    }

    protected void release(Connection conn) {
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
        this.conn = this.getConnection();
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (this.preparedSizeSql != null) {
                try {
                    this.preparedSizeSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this.preparedKeysSql != null) {
                try {
                    this.preparedKeysSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this.preparedSaveSql != null) {
                try {
                    this.preparedSaveSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this.preparedClearSql != null) {
                try {
                    this.preparedClearSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this.preparedRemoveSql != null) {
                try {
                    this.preparedRemoveSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (this.preparedLoadSql != null) {
                try {
                    this.preparedLoadSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.preparedSizeSql = null;
            this.preparedKeysSql = null;
            this.preparedSaveSql = null;
            this.preparedClearSql = null;
            this.preparedRemoveSql = null;
            this.preparedLoadSql = null;
            this.conn = null;
        }
    }
}

