/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class Util {
    private static Logger logger = LogFacade.BOOTSTRAP_LOGGER;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    private Util() {
    }

    public static Logger getLogger() {
        return logger;
    }

    static String getPropertyOrSystemProperty(Properties properties, String propertyName, String defaultValue) {
        String value = properties.getProperty(propertyName);
        return value != null ? value : System.getProperty(propertyName, defaultValue);
    }

    static String getPropertyOrSystemProperty(Properties properties, String propertyName) {
        return Util.getPropertyOrSystemProperty(properties, propertyName, null);
    }

    static boolean deleteRecursive(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                f.delete();
                continue;
            }
            Util.deleteRecursive(f);
        }
        return dir.delete();
    }

    static long getLastModified(File directory, long current) {
        for (File file : directory.listFiles()) {
            long lastModified = file.isDirectory() ? Util.getLastModified(file, current) : file.lastModified();
            if (lastModified <= current) continue;
            current = lastModified;
        }
        return current;
    }

    static void copyFile(File fin, File fout) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fin));
        FileOutputStream fos = new FileOutputStream(fout);
        Util.copy(inStream, fos, fin.length());
    }

    static void copyWithoutClose(InputStream in, FileOutputStream out, long size) throws IOException {
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileChannel outChannel = out.getChannel();
        outChannel.transferFrom(inChannel, 0L, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream in, FileOutputStream out, long size) throws IOException {
        try {
            Util.copyWithoutClose(in, out, size);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    static URI whichJar(Class clazz) {
        URL url = clazz.getClassLoader().getResource(clazz.getName().replace(".", "/") + ".class");
        if (url != null) {
            URLConnection con = null;
            try {
                con = url.openConnection();
                if (con instanceof JarURLConnection) {
                    return ((JarURLConnection)JarURLConnection.class.cast(con)).getJarFileURL().toURI();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    static File getJDKToolsJar() {
        File javaHome = new File(System.getProperty("java.home"));
        File jdktools = null;
        if (javaHome.getParent() != null) {
            jdktools = new File(javaHome.getParent(), "lib" + File.separator + "tools.jar");
        }
        return jdktools;
    }

    private static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        int startDelim = -1;
        do {
            int idx;
            if ((stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1)) < 0) {
                return val;
            }
            startDelim = val.indexOf(DELIM_START);
            if (startDelim < 0) {
                return val;
            }
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim > stopDelim && stopDelim >= 0);
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Util.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    public static void substVars(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Util.substVars(props.getProperty(name), name, null, props));
        }
    }

    public static void overrideBySystemProps(Properties platformConf, Collection<String> excluding) {
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : platformConf.entrySet()) {
            Object systemPropValue;
            if (excluding.contains(entry.getKey()) || (systemPropValue = sysProps.get(entry.getKey())) == null || systemPropValue.equals(entry.getValue())) continue;
            platformConf.put(entry.getKey(), systemPropValue);
        }
    }
}

