/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.UnconfiguredComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;

public class ComponentRegistry
implements ScrService {
    private final Map m_componentsByName = new HashMap();
    private final Map m_componentsById = new HashMap();
    private volatile long m_componentCounter = -1L;
    private ServiceRegistration m_registration;
    static /* synthetic */ Class class$org$apache$felix$scr$ScrService;

    protected ComponentRegistry(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Management Agent");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService(new String[]{(class$org$apache$felix$scr$ScrService == null ? (class$org$apache$felix$scr$ScrService = ComponentRegistry.class$("org.apache.felix.scr.ScrService")) : class$org$apache$felix$scr$ScrService).getName()}, (Object)this, props);
    }

    public void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponents() {
        Map map = this.m_componentsById;
        synchronized (map) {
            if (this.m_componentsById.isEmpty()) {
                return null;
            }
            return this.m_componentsById.values().toArray(new Component[this.m_componentsById.size()]);
        }
    }

    public Component[] getComponents(Bundle bundle) {
        Component[] all = this.getComponents();
        if (all == null || all.length == 0) {
            return null;
        }
        long bundleId = bundle.getBundleId();
        ArrayList<Component> perBundle = new ArrayList<Component>();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].getBundle().getBundleId() != bundleId) continue;
            perBundle.add(all[i]);
        }
        if (perBundle.isEmpty()) {
            return null;
        }
        return perBundle.toArray(new Component[perBundle.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            return (Component)this.m_componentsById.get(new Long(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager componentManager) {
        long componentId;
        Map map = this.m_componentsById;
        synchronized (map) {
            ++this.m_componentCounter;
            componentId = this.m_componentCounter;
            this.m_componentsById.put(new Long(componentId), componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(new Long(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkComponentName(String name) {
        Object existingRegistration;
        Map map = this.m_componentsByName;
        synchronized (map) {
            existingRegistration = this.m_componentsByName.get(name);
            if (existingRegistration == null) {
                this.m_componentsByName.put(name, name);
            }
        }
        if (existingRegistration != null) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration instanceof ComponentHolder) {
                ComponentHolder c = (ComponentHolder)existingRegistration;
                Bundle cBundle = c.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = c.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponent(String name, ComponentHolder component) {
        Map map = this.m_componentsByName;
        synchronized (map) {
            if (!name.equals(this.m_componentsByName.get(name))) {
                throw new ComponentException("The component name '" + name + "' has already been registered.");
            }
            this.m_componentsByName.put(name, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder getComponent(String name) {
        Object entry;
        Map map = this.m_componentsByName;
        synchronized (map) {
            entry = this.m_componentsByName.get(name);
        }
        if (entry instanceof ComponentHolder) {
            return (ComponentHolder)entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponent(String name) {
        Map map = this.m_componentsByName;
        synchronized (map) {
            this.m_componentsByName.remove(name);
        }
    }

    public ComponentHolder createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        if (metadata.isFactory()) {
            return new ComponentFactoryImpl(activator, metadata);
        }
        return new UnconfiguredComponentHolder(activator, metadata);
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle.getState() == 32) {
            return true;
        }
        if (bundle.getState() == 8) {
            return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

