/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSI18n;
import org.jsampler.LSConsoleModel;
import org.jsampler.LscpUtils;
import org.jsampler.event.LSConsoleEvent;
import org.jsampler.event.LSConsoleListener;
import org.jsampler.task.EnhancedTask;
import org.jsampler.task.LSConsoleConnect;

public class DefaultLSConsoleModel
implements LSConsoleModel {
    private Socket socket;
    private LscpOutputStream out;
    private final String[] cmdList = LscpUtils.getCommandList();
    private String cmdLine = "";
    private final LinkedList<String> cmdHistory = new LinkedList();
    private int cmdHistoryIdx = -1;
    private int commandHistorySize = 1000;
    private final LSConsoleThread lsConsoleThread = new LSConsoleThread();
    private final Vector<String> sessionHistory = new Vector();
    private String currentCmd = "";
    private final Vector<LSConsoleListener> listeners = new Vector();
    private Vector<String> tmpVector = new Vector();

    public DefaultLSConsoleModel() {
        CC.addReconnectListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultLSConsoleModel.this.reconnect();
            }
        });
        this.lsConsoleThread.start();
    }

    private Socket getSocket() {
        return this.socket;
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
    }

    private void reconnect() {
        final LSConsoleConnect lSConsoleConnect = new LSConsoleConnect(this.getSocket());
        lSConsoleConnect.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                DefaultLSConsoleModel.this.changeSocket((Socket)lSConsoleConnect.getResult());
            }
        });
        CC.getTaskQueue().add(lSConsoleConnect);
    }

    public void disconnect() {
        try {
            if (this.getSocket() != null) {
                this.getSocket().close();
            }
        }
        catch (Exception exception) {
            CC.getLogger().info(HF.getErrorMessage(exception));
        }
    }

    private void changeSocket(Socket socket) {
        this.setSocket(socket);
        try {
            LscpInputStream lscpInputStream = socket == null ? null : new LscpInputStream(socket.getInputStream());
            this.out = socket == null ? null : new LscpOutputStream(socket.getOutputStream());
            this.lsConsoleThread.setInputStream(lscpInputStream);
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    @Override
    public void addLSConsoleListener(LSConsoleListener lSConsoleListener) {
        this.listeners.add(lSConsoleListener);
    }

    @Override
    public void removeLSConsoleListener(LSConsoleListener lSConsoleListener) {
        this.listeners.remove(lSConsoleListener);
    }

    @Override
    public void execCommand() {
        String string = this.getCommandLineText();
        this.sessionHistory.add(string);
        if (string.trim().length() > 0 && !string.startsWith("#")) {
            this.addToCommandHistory(string);
        }
        while (this.cmdHistory.size() > this.getCommandHistorySize()) {
            this.cmdHistory.removeFirst();
        }
        this.setCommandLineText("");
        this.currentCmd = "";
        this.cmdHistoryIdx = -1;
        if (this.getSocket() == null || this.getSocket().isClosed() || !this.getSocket().isConnected() || this.getSocket().isOutputShutdown() || this.out == null) {
            this.fireResponseReceived(JSI18n.i18n.getMessage("DefaultLSConsoleModel.notConnected"));
        } else {
            CC.getTaskQueue().add(new LSConsoleExecCommand(string));
        }
        this.fireCommandExecuted();
    }

    @Override
    public String getLastExecutedCommand() {
        int n = this.sessionHistory.size();
        return n == 0 ? "" : this.sessionHistory.get(n - 1);
    }

    @Override
    public void setCommandLineText(String string) {
        if (this.cmdLine.equals(string)) {
            return;
        }
        String string2 = this.cmdLine;
        this.cmdLine = string;
        this.fireCommandLineTextChanged(string2);
    }

    @Override
    public String getCommandLineText() {
        return this.cmdLine;
    }

    @Override
    public String[] getSessionHistory() {
        return this.sessionHistory.toArray(new String[this.sessionHistory.size()]);
    }

    @Override
    public void clearSessionHistory() {
        this.sessionHistory.removeAllElements();
    }

    @Override
    public void addToCommandHistory(String string) {
        this.cmdHistory.add(string);
    }

    @Override
    public String[] getCommandHistory() {
        return this.cmdHistory.toArray(new String[this.cmdHistory.size()]);
    }

    @Override
    public void clearCommandHistory() {
        this.cmdHistory.clear();
        this.cmdHistoryIdx = -1;
    }

    @Override
    public int getCommandHistorySize() {
        return this.commandHistorySize;
    }

    @Override
    public void setCommandHistorySize(int n) {
        this.commandHistorySize = n;
    }

    @Override
    public String[] getCommandList() {
        return this.cmdList;
    }

    @Override
    public void browseCommandHistoryUp() {
        if (this.cmdHistory.size() == 0) {
            return;
        }
        if (this.cmdHistoryIdx == -1) {
            this.currentCmd = this.getCommandLineText();
            this.cmdHistoryIdx = this.cmdHistory.size() - 1;
            this.setCommandLineText(this.cmdHistory.get(this.cmdHistoryIdx));
            return;
        }
        if (this.cmdHistoryIdx == 0) {
            return;
        }
        this.setCommandLineText(this.cmdHistory.get(--this.cmdHistoryIdx));
    }

    @Override
    public void browseCommandHistoryDown() {
        if (this.cmdHistory.size() == 0 || this.cmdHistoryIdx == -1) {
            return;
        }
        if (this.cmdHistoryIdx == this.cmdHistory.size() - 1) {
            this.cmdHistoryIdx = -1;
            this.setCommandLineText(this.currentCmd);
            this.currentCmd = "";
            return;
        }
        this.setCommandLineText(this.cmdHistory.get(++this.cmdHistoryIdx));
    }

    @Override
    public void browseCommandHistoryFirst() {
        if (this.cmdHistory.size() == 0) {
            return;
        }
        this.cmdHistoryIdx = 0;
        this.setCommandLineText(this.cmdHistory.get(this.cmdHistoryIdx));
    }

    @Override
    public void browseCommandHistoryLast() {
        if (this.cmdHistory.size() == 0) {
            return;
        }
        this.cmdHistoryIdx = this.cmdHistory.size() - 1;
        this.setCommandLineText(this.cmdHistory.get(this.cmdHistoryIdx));
    }

    @Override
    public String[] searchCommandHistory() {
        return this.searchCommandHistory(this.getCommandLineText());
    }

    @Override
    public String[] searchCommandHistory(String string) {
        this.tmpVector.removeAllElements();
        for (String string2 : this.cmdHistory) {
            if (string2.indexOf(string) == -1) continue;
            this.tmpVector.add(string2);
        }
        return this.tmpVector.toArray(new String[this.tmpVector.size()]);
    }

    @Override
    public String[] searchCommandList() {
        return this.searchCommandList(this.getCommandLineText());
    }

    @Override
    public String[] searchCommandList(String string) {
        this.tmpVector.removeAllElements();
        for (String string2 : this.cmdList) {
            if (string2.indexOf(string) == -1) continue;
            this.tmpVector.add(string2);
        }
        return this.tmpVector.toArray(new String[this.tmpVector.size()]);
    }

    @Override
    public void quit() {
        this.disconnect();
    }

    private void fireCommandLineTextChanged(String string) {
        LSConsoleEvent lSConsoleEvent = new LSConsoleEvent(this, null, string);
        for (LSConsoleListener lSConsoleListener : this.listeners) {
            lSConsoleListener.commandLineTextChanged(lSConsoleEvent);
        }
    }

    private void fireCommandExecuted() {
        LSConsoleEvent lSConsoleEvent = new LSConsoleEvent(this);
        for (LSConsoleListener lSConsoleListener : this.listeners) {
            lSConsoleListener.commandExecuted(lSConsoleEvent);
        }
    }

    private void fireResponseReceived(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LSConsoleEvent lSConsoleEvent = new LSConsoleEvent(this, string);
                for (LSConsoleListener lSConsoleListener : DefaultLSConsoleModel.this.listeners) {
                    lSConsoleListener.responseReceived(lSConsoleEvent);
                }
            }
        });
    }

    class LscpOutputStream {
        private OutputStream out;

        public LscpOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void writeLine(String string) throws IOException {
            try {
                this.out.write(string.getBytes("US-ASCII"));
                this.out.write(13);
                this.out.write(10);
                this.out.flush();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(unsupportedEncodingException), unsupportedEncodingException);
            }
        }
    }

    class LscpInputStream {
        private InputStream in;
        private StringBuffer buf = new StringBuffer();

        public LscpInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public synchronized String readLine() throws IOException {
            int n;
            this.buf.setLength(0);
            while ((n = this.in.read()) != -1) {
                if (n == 13) {
                    this.checkLF();
                    break;
                }
                this.buf.append((char)n);
            }
            if (n == -1) {
                if (this.buf.length() > 0) {
                    throw new IOException("Unexpected end of line!");
                }
                return null;
            }
            return this.buf.toString();
        }

        public synchronized int available() throws IOException {
            return this.in.available();
        }

        private void checkLF() throws IOException {
            int n = this.in.read();
            if (n == -1) {
                throw new IOException("Unexpected end of file!");
            }
            if (n != 10) {
                throw new IOException("Unexpected end of line!");
            }
        }
    }

    class LSConsoleThread
    extends Thread {
        LscpInputStream in;
        private boolean terminate;

        LSConsoleThread() {
            super("LS-Console-Thread");
            this.terminate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.mustTerminate()) {
                try {
                    this.processInput();
                }
                catch (Exception exception) {
                    CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
                }
                try {
                    LSConsoleThread lSConsoleThread = this;
                    synchronized (lSConsoleThread) {
                        this.wait(100L);
                    }
                }
                catch (Exception exception) {
                    CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
                }
            }
        }

        private synchronized boolean mustTerminate() {
            return this.terminate;
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notifyAll();
        }

        private synchronized void processInput() throws IOException {
            while (this.in != null && this.in.available() > 0) {
                String string = this.in.readLine();
                DefaultLSConsoleModel.this.fireResponseReceived(string);
            }
        }

        public synchronized void setInputStream(LscpInputStream lscpInputStream) {
            this.in = lscpInputStream;
        }
    }

    private class LSConsoleExecCommand
    extends EnhancedTask {
        private String cmd;

        public LSConsoleExecCommand(String string) {
            this.setTitle("LSConsoleExecCommand_task");
            this.setDescription(JSI18n.i18n.getMessage("LSConsoleExecCommand.description"));
            this.cmd = string;
        }

        @Override
        public void exec() throws Exception {
            DefaultLSConsoleModel.this.out.writeLine(this.cmd);
        }
    }
}

