/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.Semaphore;
import org.jboss.remoting3.remote.RemoteConnection;

final class OutboundStream {
    private final int id;
    private final RemoteConnection remoteConnection;
    private final Semaphore semaphore = new Semaphore(3);
    private State state = State.WAITING;

    OutboundStream(int id, RemoteConnection remoteConnection) {
        this.id = id;
        this.remoteConnection = remoteConnection;
    }

    ByteBuffer getBuffer() {
        ByteBuffer buffer = this.remoteConnection.allocate();
        buffer.position(4);
        buffer.put((byte)32);
        buffer.putInt(this.id);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ByteBuffer buffer) throws IOException {
        try {
            OutboundStream outboundStream = this;
            synchronized (outboundStream) {
                block15: while (true) {
                    switch (1.$SwitchMap$org$jboss$remoting3$remote$OutboundStream$State[this.state.ordinal()]) {
                        case 1: {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new InterruptedIOException();
                            }
                        }
                        continue block15;
                        case 2: {
                            this.state = State.CLOSED;
                            this.sendEof();
                            throw new AsynchronousCloseException();
                        }
                        case 3: {
                            this.state = State.CLOSED;
                            throw new AsynchronousCloseException();
                        }
                        case 4: 
                        case 5: {
                            throw new AsynchronousCloseException();
                        }
                        case 6: {
                            break block15;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
            }
            this.remoteConnection.sendBlocking(buffer, true);
        }
        finally {
            this.remoteConnection.free(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEof() {
        OutboundStream outboundStream = this;
        synchronized (outboundStream) {
            switch (this.state) {
                case WAITING: {
                    this.state = State.CLOSE_WAIT;
                    return;
                }
                case ASYNC_CLOSE: 
                case ASYNC_EXCEPTION: {
                    this.state = State.CLOSED;
                }
            }
            this.doSend((byte)34);
        }
    }

    private void doSend(byte code) {
        ByteBuffer buffer = this.remoteConnection.allocate();
        buffer.position(4);
        buffer.put(code);
        buffer.putInt(this.id);
        buffer.flip();
        try {
            this.remoteConnection.sendBlocking(buffer, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendException() {
        OutboundStream outboundStream = this;
        synchronized (outboundStream) {
            if (this.state == State.WAITING) {
                this.state = State.WAITING_EXCEPTION;
                return;
            }
            this.state = State.CLOSE_WAIT;
            this.doSend((byte)33);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncStart() {
        OutboundStream outboundStream = this;
        synchronized (outboundStream) {
            switch (this.state) {
                case WAITING: {
                    this.state = State.RUNNING;
                    this.notifyAll();
                    return;
                }
                case WAITING_EXCEPTION: {
                    this.state = State.CLOSE_WAIT;
                    this.notifyAll();
                    this.sendException();
                }
            }
            if (this.state == State.WAITING_EXCEPTION) {
                this.state = State.CLOSED;
                this.doSend((byte)33);
                return;
            }
        }
    }

    void ack() {
        this.semaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncClose() {
        OutboundStream outboundStream = this;
        synchronized (outboundStream) {
            switch (this.state) {
                case WAITING: 
                case RUNNING: {
                    this.doSend((byte)34);
                    this.state = State.CLOSED;
                    this.notifyAll();
                    return;
                }
            }
        }
    }

    void asyncException() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WAITING,
        WAITING_EXCEPTION,
        RUNNING,
        ASYNC_CLOSE,
        ASYNC_EXCEPTION,
        CLOSE_WAIT,
        CLOSED;

    }
}

