/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.Domain;
import org.jboss.ejb3.interceptors.container.AbstractContainer;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.logging.Logger;

public class ProxyContainer<T>
extends AbstractContainer<T, ProxyContainer<T>> {
    private static final Logger log = Logger.getLogger(ProxyContainer.class);

    public ProxyContainer(String name, Domain domain, Class<? extends T> beanClass) {
        super(name, domain, beanClass);
    }

    public ProxyContainer(String name, String domainName, Class<? extends T> beanClass) {
        super(name, domainName, beanClass);
    }

    public <I> I constructProxy(Class<?>[] interfaces) throws Throwable {
        Constructor constructor = this.getBeanClass().getConstructor(new Class[0]);
        BeanContext instance = this.construct(constructor, new Object[0]);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new ProxyInvocationHandler(instance));
        return (I)proxy;
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private BeanContext<T> target;

        public ProxyInvocationHandler(BeanContext<T> target) {
            assert (target != null) : "target is null";
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ProxyContainer.this.invoke(this.target, method, args);
        }
    }
}

