/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.integration.deployer.env.AbstractDeploymentDeployer;
import org.jboss.weld.integration.deployer.env.BootstrapInfo;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.DeploymentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDeploymentDeployer
extends AbstractDeploymentDeployer {
    public JBossDeploymentDeployer() {
        this.addInput(ArchiveInfo.class);
    }

    @Override
    protected boolean isRelevant(DeploymentUnit unit) {
        return unit.isAttachmentPresent(ArchiveInfo.class);
    }

    @Override
    protected Class<? extends Deployment> getDeploymentClass() {
        return DeploymentImpl.class;
    }

    @Override
    protected void buildDeployment(DeploymentUnit unit, BootstrapInfo info, BeanMetaDataBuilder builder) {
        builder.addConstructorParameter(String.class.getName(), unit.getName());
        builder.addConstructorParameter(Collection.class.getName(), this.getArchiveInfos(unit));
        builder.addConstructorParameter(Collection.class.getName(), builder.createInject(info.getEjbServices().getUnderlyingValue(), "ejbs"));
        builder.addConstructorParameter(BeanFactory.class.getName(), builder.createInject((Object)"JBossEjbServices"));
        builder.addUninstall("undeploy");
    }

    private Collection<ArchiveInfo> getArchiveInfos(DeploymentUnit unit) {
        ArrayList<ArchiveInfo> archiveInfos = new ArrayList<ArchiveInfo>();
        this.fill(archiveInfos, unit);
        return archiveInfos;
    }

    private void fill(Collection<ArchiveInfo> archiveInfos, DeploymentUnit unit) {
        ArchiveInfo archiveInfo = (ArchiveInfo)unit.getAttachment(ArchiveInfo.class);
        if (archiveInfo != null) {
            archiveInfos.add(archiveInfo);
        }
        for (DeploymentUnit child : unit.getChildren()) {
            this.fill(archiveInfos, child);
        }
    }
}

