/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;
import org.jboss.util.id.SerialVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebResourcePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID;
    private static TreeSet<String> ALL_HTTP_METHODS;
    static final String ENCODED_COLON = "%3A";
    private static final ObjectStreamField[] serialPersistentFields;
    private transient URLPatternSpec urlSpec;
    private transient TreeSet<String> httpMethods;
    private transient String httpMethodsString;
    private transient TreeSet<String> httpExceptionList;
    private transient String httpExceptionString;

    public WebResourcePermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), request.getMethod());
    }

    public WebResourcePermission(String name, String actions) {
        super(name == null ? "/" : name);
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        this.parseActions(actions);
    }

    public WebResourcePermission(String urlPatternSpec, String[] httpMethods) {
        super(urlPatternSpec);
        this.urlSpec = new URLPatternSpec(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
    }

    @Override
    public boolean equals(Object p) {
        if (!(p instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission perm = (WebResourcePermission)p;
        return this.implies(perm) && perm.implies(this);
    }

    @Override
    public String getActions() {
        return this.httpMethodsString;
    }

    @Override
    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.urlSpec.hashCode();
        if (this.httpMethods != null) {
            hashCode = 37 * hashCode + this.httpMethods.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission perm = (WebResourcePermission)permission;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies) {
            if (this.httpExceptionList != null) {
                implies = WebResourcePermission.matchExceptionList(this.httpExceptionList, perm.httpExceptionList);
            }
            if (this.httpMethods != null && perm.httpMethods != null) {
                implies = this.httpMethods.containsAll(perm.httpMethods);
            }
        }
        return implies;
    }

    static String requestURI(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri != null) {
            int length;
            String contextPath = request.getContextPath();
            int n = length = contextPath == null ? 0 : contextPath.length();
            if (length > 0) {
                uri = uri.substring(length);
            }
            if (uri.equals("/")) {
                uri = "";
            }
        } else {
            uri = "";
        }
        if (uri.indexOf(58) > 0) {
            uri = uri.replaceAll(":", ENCODED_COLON);
        }
        return uri;
    }

    static Object[] canonicalMethods(String methods) {
        String[] methodsArray = null;
        if (methods != null && methods.length() > 0) {
            methodsArray = methods.split(",");
        }
        return WebResourcePermission.canonicalMethods(methodsArray);
    }

    static Object[] canonicalMethods(String[] methods) {
        TreeSet<String> actions = new TreeSet<String>();
        if (methods != null) {
            for (String method : methods) {
                actions.add(method);
            }
        }
        return WebResourcePermission.canonicalMethods(actions);
    }

    static Object[] canonicalMethods(TreeSet<String> actions) {
        Object[] info = new Object[]{ALL_HTTP_METHODS, null};
        if (actions.equals(ALL_HTTP_METHODS) || actions.size() == 0) {
            return info;
        }
        info[0] = actions;
        StringBuffer tmp = new StringBuffer();
        for (String action : actions) {
            tmp.append(action);
            tmp.append(',');
        }
        if (tmp.length() > 0) {
            tmp.setLength(tmp.length() - 1);
        }
        info[1] = tmp.toString();
        return info;
    }

    private void parseActions(String actions) {
        boolean exclusionListNeeded;
        boolean bl = exclusionListNeeded = actions != null && actions.startsWith("!");
        if (exclusionListNeeded) {
            actions = actions.substring(1);
        }
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
        if (exclusionListNeeded) {
            this.httpExceptionList = (TreeSet)methodInfo[0];
            this.httpExceptionString = (String)methodInfo[1];
        } else {
            this.httpMethods = (TreeSet)methodInfo[0];
            this.httpMethodsString = (String)methodInfo[1];
        }
    }

    static boolean matchExceptionList(TreeSet<String> myExceptionList, TreeSet<String> matchingExceptionList) {
        boolean onenull;
        boolean bothnull = myExceptionList == null && matchingExceptionList == null;
        boolean bl = onenull = myExceptionList == null && matchingExceptionList != null || myExceptionList != null && matchingExceptionList == null;
        if (bothnull) {
            return true;
        }
        if (onenull) {
            return false;
        }
        for (String httpMethod : matchingExceptionList) {
            if (!myExceptionList.contains(httpMethod)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions = (String)fields.get("actions", null);
        this.parseActions(actions);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }

    static {
        ALL_HTTP_METHODS = new TreeSet();
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
        ALL_HTTP_METHODS.add("GET");
        ALL_HTTP_METHODS.add("POST");
        ALL_HTTP_METHODS.add("PUT");
        ALL_HTTP_METHODS.add("DELETE");
        ALL_HTTP_METHODS.add("HEAD");
        ALL_HTTP_METHODS.add("OPTIONS");
        ALL_HTTP_METHODS.add("TRACE");
        serialVersionUID = SerialVersion.version == 0 ? 141000L : 1L;
    }
}

