/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.utils.MemorySize;

public class MessageReferenceImpl
implements MessageReference {
    private static final Logger log = Logger.getLogger(MessageReferenceImpl.class);
    private volatile int deliveryCount;
    private volatile long scheduledDeliveryTime;
    private final ServerMessage message;
    private final Queue queue;
    private static final int memoryOffset = MemorySize.is64bitArch() ? 48 : 32;

    public MessageReferenceImpl() {
        this.queue = null;
        this.message = null;
    }

    public MessageReferenceImpl(MessageReferenceImpl other, Queue queue) {
        this.deliveryCount = other.deliveryCount;
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.message = other.message;
        this.queue = queue;
    }

    protected MessageReferenceImpl(ServerMessage message, Queue queue) {
        this.message = message;
        this.queue = queue;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new MessageReferenceImpl(this, queue);
    }

    public static int getMemoryEstimate() {
        return memoryOffset;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    @Override
    public void incrementDeliveryCount() {
        ++this.deliveryCount;
    }

    @Override
    public void decrementDeliveryCount() {
        --this.deliveryCount;
    }

    @Override
    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    @Override
    public ServerMessage getMessage() {
        return this.message;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public void handled() {
        this.queue.referenceHandled();
    }

    public String toString() {
        return "Reference[" + this.getMessage().getMessageID() + "]:" + (this.getMessage().isDurable() ? "RELIABLE" : "NON-RELIABLE");
    }
}

