/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.scheduler.ScheduleManagerMBean;

public class ScheduleManager
extends ServiceMBeanSupport
implements ScheduleManagerMBean {
    public static String DEFAULT_TIMER_NAME = "jboss:service=Timer";
    private static SynchronizedInt sCounter = new SynchronizedInt(0);
    private static final int NOTIFICATION = 0;
    private static final int DATE = 1;
    private static final int REPETITIONS = 2;
    private static final int SCHEDULER_NAME = 3;
    private static final int NULL = 4;
    private static final int ID = 5;
    private static final int NEXT_DATE = 6;
    private String mTimerName = DEFAULT_TIMER_NAME;
    private ObjectName mTimerObjectName;
    private TimerMBean mTimer;
    private NotificationEmitter mTimerEmitter;
    private boolean mStartOnStart = true;
    private boolean mFixedRate = false;
    private SynchronizedBoolean mIsPaused = new SynchronizedBoolean(false);
    private List mProviders = Collections.synchronizedList(new ArrayList());
    private Map mSchedules = new ConcurrentReaderHashMap();

    public void startSchedules() {
        this.log.debug((Object)"startSchedules()");
        if (!this.isStarted()) {
            for (ScheduleInstance lInstance : this.mSchedules.values()) {
                try {
                    lInstance.start();
                }
                catch (JMException e) {
                    this.log.error((Object)("Could not start: " + lInstance), (Throwable)e);
                }
            }
        }
    }

    public void stopSchedules(boolean pDoItNow) {
        if (this.isStarted()) {
            for (ScheduleInstance lInstance : this.mSchedules.values()) {
                try {
                    lInstance.stop();
                }
                catch (JMException e) {
                    this.log.error((Object)("Could not stop: " + lInstance), (Throwable)e);
                }
            }
        }
    }

    public void restartSchedule() {
        this.stopSchedules(true);
        this.startSchedules();
    }

    public void registerProvider(String pProviderObjectName) {
        try {
            this.registerProvider(new ObjectName(pProviderObjectName));
        }
        catch (JMException jme) {
            this.log.error((Object)("Could not call startProviding() on " + pProviderObjectName), (Throwable)jme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProvider(ObjectName pProviderObjectName) throws JMException {
        if (pProviderObjectName == null) {
            throw new MalformedObjectNameException("Provider must not be null");
        }
        List list = this.mProviders;
        synchronized (list) {
            if (this.mProviders.contains(pProviderObjectName)) {
                throw new JMException("Already registered: " + pProviderObjectName);
            }
            this.mProviders.add(pProviderObjectName);
        }
        this.server.invoke(pProviderObjectName, "startProviding", new Object[0], new String[0]);
    }

    public void unregisterProvider(String pProviderObjectName) {
        try {
            this.unregisterProvider(new ObjectName(pProviderObjectName));
        }
        catch (JMException jme) {
            this.log.error((Object)("Could not call stopProviding() on " + pProviderObjectName), (Throwable)jme);
        }
    }

    public void unregisterProvider(ObjectName pProviderObjectName) throws JMException {
        if (!this.mProviders.remove(pProviderObjectName)) {
            return;
        }
        this.server.invoke(pProviderObjectName, "stopProviding", new Object[0], new String[0]);
    }

    public int addSchedule(ObjectName pProvider, ObjectName pTarget, String pMethodName, String[] pMethodSignature, Date pStartDate, long pPeriod, int pRepetitions) {
        ScheduleInstance lInstance = new ScheduleInstance(pProvider, pTarget, pMethodName, pMethodSignature, pStartDate, pRepetitions, pPeriod);
        if (this.isStarted()) {
            try {
                lInstance.start();
            }
            catch (JMException jme) {
                this.log.error((Object)("Could not start " + lInstance), (Throwable)jme);
            }
        }
        int lID = lInstance.getID();
        this.mSchedules.put(new Integer(lID), lInstance);
        return lID;
    }

    public void removeSchedule(int pIdentification) {
        ScheduleInstance lInstance = (ScheduleInstance)this.mSchedules.get(new Integer(pIdentification));
        try {
            if (lInstance == null) {
                throw new InstanceNotFoundException();
            }
            lInstance.stop();
        }
        catch (JMException e) {
            this.log.error((Object)("Could not stop " + lInstance), (Throwable)e);
        }
        this.mSchedules.remove(new Integer(pIdentification));
    }

    public String getSchedules() {
        Iterator i = this.mSchedules.values().iterator();
        StringBuffer lReturn = new StringBuffer();
        boolean lFirst = true;
        while (i.hasNext()) {
            ScheduleInstance lInstance = (ScheduleInstance)i.next();
            if (lFirst) {
                lReturn.append(lInstance.mIdentification);
                lFirst = false;
                continue;
            }
            lReturn.append(",").append(lInstance.mIdentification);
        }
        return lReturn.toString();
    }

    public boolean isPaused() {
        return this.mIsPaused.get();
    }

    public void setPaused(boolean pIsPaused) {
        this.mIsPaused.set(pIsPaused);
    }

    public boolean isStarted() {
        return this.getState() == 3;
    }

    public void setStartAtStartup(boolean pStartAtStartup) {
        this.mStartOnStart = pStartAtStartup;
    }

    public boolean isStartAtStartup() {
        return this.mStartOnStart;
    }

    public void setTimerName(String pTimerName) {
        this.mTimerName = pTimerName;
    }

    public String getTimerName() {
        return this.mTimerName;
    }

    public void setFixedRate(boolean fixedRate) {
        this.mFixedRate = fixedRate;
    }

    public boolean getFixedRate() {
        return this.mFixedRate;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? OBJECT_NAME : pName;
    }

    protected void startService() throws Exception {
        this.mTimerObjectName = new ObjectName(this.mTimerName);
        if (!this.getServer().isRegistered(this.mTimerObjectName)) {
            this.getServer().createMBean(Timer.class.getName(), this.mTimerObjectName);
        }
        this.mTimer = MBeanServerInvocationHandler.newProxyInstance(this.getServer(), this.mTimerObjectName, TimerMBean.class, true);
        this.mTimerEmitter = (NotificationEmitter)((Object)this.mTimer);
        if (!this.mTimer.isActive()) {
            this.mTimer.start();
        }
        this.startSchedules();
    }

    protected void stopService() {
        this.stopSchedules(true);
    }

    protected void destroyService() {
        for (ScheduleInstance lInstance : this.mSchedules.values()) {
            this.unregisterProvider(lInstance.mProvider.toString());
        }
    }

    private class ScheduleInstance {
        private final Logger log = Logger.getLogger(ScheduleInstance.class);
        private int mIdentification;
        private MBeanListener mListener;
        public int mNotificationID;
        public ObjectName mProvider;
        public ObjectName mTarget;
        public long mInitialRepetitions;
        public long mRemainingRepetitions = 0L;
        public Date mStartDate;
        public long mPeriod;
        public String mMethodName;
        public int[] mSchedulableMBeanArguments;
        public String[] mSchedulableMBeanArgumentTypes;

        public ScheduleInstance(ObjectName pProvider, ObjectName pTarget, String pMethodName, String[] pMethodArguments, Date pStartDate, int pRepetitions, long pPeriod) {
            this.mProvider = pProvider;
            this.mTarget = pTarget;
            this.mInitialRepetitions = pRepetitions;
            this.mStartDate = pStartDate;
            this.mPeriod = pPeriod;
            this.mMethodName = pMethodName;
            this.mSchedulableMBeanArguments = new int[pMethodArguments.length];
            this.mSchedulableMBeanArgumentTypes = new String[pMethodArguments.length];
            for (int i = 0; i < pMethodArguments.length; ++i) {
                String lToken = pMethodArguments[i];
                if (lToken.equals("ID")) {
                    this.mSchedulableMBeanArguments[i] = 5;
                    this.mSchedulableMBeanArgumentTypes[i] = Integer.class.getName();
                    continue;
                }
                if (lToken.equals("NOTIFICATION")) {
                    this.mSchedulableMBeanArguments[i] = 0;
                    this.mSchedulableMBeanArgumentTypes[i] = Notification.class.getName();
                    continue;
                }
                if (lToken.equals("NEXT_DATE")) {
                    this.mSchedulableMBeanArguments[i] = 6;
                    this.mSchedulableMBeanArgumentTypes[i] = Date.class.getName();
                    continue;
                }
                if (lToken.equals("DATE")) {
                    this.mSchedulableMBeanArguments[i] = 1;
                    this.mSchedulableMBeanArgumentTypes[i] = Date.class.getName();
                    continue;
                }
                if (lToken.equals("REPETITIONS")) {
                    this.mSchedulableMBeanArguments[i] = 2;
                    this.mSchedulableMBeanArgumentTypes[i] = Long.TYPE.getName();
                    continue;
                }
                if (lToken.equals("SCHEDULER_NAME")) {
                    this.mSchedulableMBeanArguments[i] = 3;
                    this.mSchedulableMBeanArgumentTypes[i] = ObjectName.class.getName();
                    continue;
                }
                this.mSchedulableMBeanArguments[i] = 4;
                this.mSchedulableMBeanArgumentTypes[i] = lToken;
            }
            this.mIdentification = sCounter.increment();
        }

        public void start() throws JMException {
            Date lStartDate = null;
            if (this.mStartDate.getTime() < new Date().getTime() && this.mPeriod > 0L) {
                long lNow = new Date().getTime() + 100L;
                long lSkipRepeats = (lNow - this.mStartDate.getTime()) / this.mPeriod + 1L;
                this.log.debug((Object)("Old start date: " + this.mStartDate + ", now: " + new Date(lNow) + ", Skip repeats: " + lSkipRepeats));
                if (this.mInitialRepetitions > 0L) {
                    if (lSkipRepeats >= this.mInitialRepetitions) {
                        this.log.warn((Object)"No repetitions left because start date is in the past and could not be reached by Initial Repetitions * Schedule Period");
                        return;
                    }
                    this.mRemainingRepetitions = this.mInitialRepetitions - lSkipRepeats;
                } else {
                    this.mRemainingRepetitions = this.mInitialRepetitions == 0L ? 0L : -1L;
                }
                lStartDate = new Date(this.mStartDate.getTime() + lSkipRepeats * this.mPeriod);
            } else {
                lStartDate = this.mStartDate;
                this.mRemainingRepetitions = this.mInitialRepetitions;
            }
            this.mNotificationID = ScheduleManager.this.mTimer.addNotification("Schedule", "Scheduler Notification", new Integer(this.getID()), lStartDate, new Long(this.mPeriod), this.mRemainingRepetitions < 0L ? new Long(0L) : new Long(this.mRemainingRepetitions), ScheduleManager.this.mFixedRate);
            this.mListener = new MBeanListener(this);
            ScheduleManager.this.mTimerEmitter.addNotificationListener(this.mListener, new IdNotificationFilter(this.mNotificationID), null);
            this.log.debug((Object)("start(), add Notification to Timer with ID: " + this.mNotificationID));
        }

        public void stop() throws JMException {
            this.log.debug((Object)("stopSchedule(), notification id: " + this.mNotificationID));
            ScheduleManager.this.mTimerEmitter.removeNotificationListener(this.mListener);
            try {
                ScheduleManager.this.mTimer.removeNotification(this.mNotificationID);
            }
            catch (InstanceNotFoundException e) {
                this.log.trace((Object)e);
            }
        }

        public int getID() {
            return this.mIdentification;
        }

        public String toString() {
            return "Schedule target=" + this.getTargetString();
        }

        public String getTargetString() {
            return this.mTarget + " " + this.mMethodName + "" + Arrays.asList(this.mSchedulableMBeanArgumentTypes);
        }
    }

    static class IdNotificationFilter
    implements NotificationFilter {
        private static final Logger log = Logger.getLogger(IdNotificationFilter.class);
        private Integer filterId;

        public IdNotificationFilter(int filterId) {
            this.filterId = new Integer(filterId);
        }

        public boolean isNotificationEnabled(Notification pNotification) {
            if (!(pNotification instanceof TimerNotification)) {
                return false;
            }
            TimerNotification lTimerNotification = (TimerNotification)pNotification;
            if (log.isTraceEnabled()) {
                log.trace((Object)("isNotificationEnabled(), filterId=" + this.filterId + ", notification=" + pNotification + ", notificationId=" + lTimerNotification.getNotificationID() + ", timestamp=" + lTimerNotification.getTimeStamp() + ", message=" + lTimerNotification.getMessage()));
            }
            return lTimerNotification.getNotificationID().equals(this.filterId);
        }
    }

    public class MBeanListener
    implements NotificationListener {
        private final Logger log = Logger.getLogger(MBeanListener.class);
        private ScheduleInstance mSchedule;

        public MBeanListener(ScheduleInstance pSchedule) {
            this.mSchedule = pSchedule;
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("MBeanListener.handleNotification: " + pNotification));
            }
            try {
                if (!ScheduleManager.this.isStarted()) {
                    this.log.trace((Object)"Scheduler not started");
                    this.mSchedule.stop();
                    return;
                }
                if (this.mSchedule.mRemainingRepetitions == 0L) {
                    this.log.trace((Object)"No more repetitions");
                    this.mSchedule.stop();
                    return;
                }
                if (ScheduleManager.this.mIsPaused.get()) {
                    this.log.trace((Object)"Paused");
                    return;
                }
                if (this.mSchedule.mRemainingRepetitions > 0L) {
                    --this.mSchedule.mRemainingRepetitions;
                    if (trace) {
                        this.log.trace((Object)("Remaining repetitions: " + this.mSchedule.mRemainingRepetitions));
                    }
                }
                Object[] lArguments = this.getArguments(pNotification);
                if (trace) {
                    this.log.trace((Object)("invoke " + this.mSchedule));
                    this.log.trace((Object)("arguments are: " + Arrays.asList(lArguments)));
                }
                ObjectName on = this.mSchedule.mTarget;
                String mn = this.mSchedule.mMethodName;
                ScheduleManager.this.getServer().invoke(on, mn, lArguments, this.mSchedule.mSchedulableMBeanArgumentTypes);
            }
            catch (Exception e) {
                this.log.error((Object)("Invoke failed: " + this.mSchedule.getTargetString()), (Throwable)e);
            }
        }

        private Object[] getArguments(Notification pNotification) {
            Object[] lArguments = new Object[this.mSchedule.mSchedulableMBeanArguments.length];
            Date lTimeStamp = new Date(pNotification.getTimeStamp());
            block8: for (int i = 0; i < lArguments.length; ++i) {
                switch (this.mSchedule.mSchedulableMBeanArguments[i]) {
                    case 5: {
                        lArguments[i] = pNotification.getUserData();
                        continue block8;
                    }
                    case 0: {
                        lArguments[i] = pNotification;
                        continue block8;
                    }
                    case 1: {
                        lArguments[i] = lTimeStamp;
                        continue block8;
                    }
                    case 2: {
                        lArguments[i] = new Long(this.mSchedule.mRemainingRepetitions);
                        continue block8;
                    }
                    case 3: {
                        lArguments[i] = ScheduleManager.this.getServiceName();
                        continue block8;
                    }
                    case 6: {
                        lArguments[i] = new Date(lTimeStamp.getTime() + this.mSchedule.mPeriod);
                        continue block8;
                    }
                    default: {
                        lArguments[i] = null;
                    }
                }
            }
            return lArguments;
        }
    }
}

