/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.actions;

import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.management.ManagementAction;
import org.jboss.profileservice.spi.action.management.ManagementActionContext;

public class RemoveComponentAction
extends AbstractTwoPhaseModificationAction<ManagementActionContext>
implements ManagementAction<ManagementActionContext> {
    private ManagedComponent component;
    private PersistenceRepository persistenceRepository;

    public RemoveComponentAction(ManagedComponent component, PersistenceRepository persistenceRepository, ManagementActionContext modificationContext) {
        super((ProfileModificationContext)modificationContext);
        this.component = component;
        this.persistenceRepository = persistenceRepository;
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            if (this.persistenceRepository.isSupportPersistence(this.component)) {
                ManagedDeployment deployment = this.component.getDeployment();
                this.persistenceRepository.removeComponent(deployment.getName(), this.component);
            }
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }
}

