/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.weld;

import java.util.Collection;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.helpers.VoidScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.scanning.weld.WeldScanningPlugin;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldScanningPluginFactory
implements DeploymentScanningPluginFactory<VoidScanningHandle, Object> {
    public boolean isRelevant(DeploymentUnit unit) {
        boolean hasCp;
        Collection wbFiles = (Collection)unit.getAttachment("WELD_FILES", Collection.class);
        boolean hasWB = wbFiles != null && !wbFiles.isEmpty();
        Collection cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class);
        boolean bl = hasCp = cpFiles != null && !cpFiles.isEmpty();
        if (hasWB || hasCp) {
            DeploymentUnit topUnit = unit.getTopLevel();
            WeldDiscoveryEnvironment environment = (WeldDiscoveryEnvironment)topUnit.getAttachment(WeldDiscoveryEnvironment.class);
            if (environment == null) {
                environment = new WeldDiscoveryEnvironment();
                topUnit.addAttachment(WeldDiscoveryEnvironment.class, (Object)environment);
            }
            if (hasWB) {
                Collection xmls = environment.getWeldXml();
                try {
                    for (VirtualFile file : wbFiles) {
                        xmls.add(file.toURL());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return hasCp;
    }

    public String getPluginOutput() {
        return null;
    }

    public ScanningPlugin<VoidScanningHandle, Object> create(DeploymentUnit unit) {
        Collection cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class);
        WeldDiscoveryEnvironment environment = (WeldDiscoveryEnvironment)unit.getTopLevel().getAttachment(WeldDiscoveryEnvironment.class);
        return new WeldScanningPlugin(environment, cpFiles);
    }
}

