/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtils {
    public static <T> T[] copyOfRange(T[] arr, int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException(to + "<" + from);
        }
        int newSize = Math.min(arr.length - from, to - from);
        Object[] copy = (Object[])Array.newInstance(arr.getClass().getComponentType(), newSize);
        System.arraycopy(arr, from, copy, 0, newSize);
        return copy;
    }

    public static int[] copyOfRange(int[] arr, int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException(to + "<" + from);
        }
        int newSize = Math.min(arr.length - from, to - from);
        int[] copy = new int[newSize];
        System.arraycopy(arr, from, copy, 0, newSize);
        return copy;
    }

    public static int[] unwrapCollection(Collection<Integer> input) {
        if (input == null) {
            return null;
        }
        Integer[] intermediate = input.toArray(new Integer[input.size()]);
        return ArrayUtils.unwrapArray(intermediate);
    }

    public static int[] unwrapArray(Integer[] input) {
        if (input == null) {
            return null;
        }
        int[] output = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static Integer[] wrapInArray(int[] input) {
        if (input == null) {
            return null;
        }
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static List<Integer> wrapInList(int[] input) {
        if (input == null) {
            return null;
        }
        Integer[] intermediate = ArrayUtils.wrapInArray(input);
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Integer next : intermediate) {
            results.add(next);
        }
        return results;
    }
}

