/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.FilterMetaData;

@XmlType(name="parentPolicy", propOrder={"beforeFilter", "afterFilter", "description"})
@XmlRootElement(name="parent-policy", namespace="urn:jboss:classloading:1.0")
public class ParentPolicyMetaData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name;
    private FilterMetaData beforeFilter;
    private FilterMetaData afterFilter;
    private String description;
    private transient ParentPolicy parentPolicy;

    public ParentPolicy createParentPolicy() {
        if (this.parentPolicy == null) {
            if (this.name != null) {
                String upper = this.name.toUpperCase();
                try {
                    Field instance = ParentPolicy.class.getField(upper);
                    this.parentPolicy = (ParentPolicy)instance.get(null);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot create parent-policy, wrong name perhaps? - " + this.name, t);
                }
            } else {
                ClassFilter before = this.beforeFilter != null ? this.beforeFilter.createFilter() : ClassFilterUtils.EVERYTHING;
                ClassFilter after = this.afterFilter != null ? this.afterFilter.createFilter() : ClassFilterUtils.NOTHING;
                this.parentPolicy = new ParentPolicy(before, after, this.description);
            }
        }
        return this.parentPolicy;
    }

    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    public FilterMetaData getBeforeFilter() {
        return this.beforeFilter;
    }

    @XmlElement(name="before-filter")
    public void setBeforeFilter(FilterMetaData beforeFilter) {
        this.beforeFilter = beforeFilter;
    }

    public FilterMetaData getAfterFilter() {
        return this.afterFilter;
    }

    @XmlElement(name="after-filter")
    public void setAfterFilter(FilterMetaData afterFilter) {
        this.afterFilter = afterFilter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return ParentPolicyMetaData.hash(this.name) + 3 * ParentPolicyMetaData.hash(this.beforeFilter) + 7 * ParentPolicyMetaData.hash(this.afterFilter) + 11 * ParentPolicyMetaData.hash(this.description);
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParentPolicyMetaData)) {
            return false;
        }
        ParentPolicyMetaData other = (ParentPolicyMetaData)obj;
        if (!ClassLoadingMetaData.equals(this.name, other.name)) {
            return false;
        }
        if (!ClassLoadingMetaData.equals(this.beforeFilter, other.beforeFilter)) {
            return false;
        }
        if (!ClassLoadingMetaData.equals(this.afterFilter, other.afterFilter)) {
            return false;
        }
        return ClassLoadingMetaData.equals(this.description, other.description);
    }

    public ParentPolicyMetaData clone() {
        try {
            ParentPolicyMetaData clone = (ParentPolicyMetaData)super.clone();
            clone.beforeFilter = this.beforeFilter.clone();
            clone.afterFilter = this.afterFilter.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }
}

