/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.instantiator.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.ejb3.instantiator.spi.BeanInstantiationException;
import org.jboss.ejb3.instantiator.spi.BeanInstantiator;
import org.jboss.ejb3.instantiator.spi.InvalidConstructionParamsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb31SpecBeanInstantiator
implements BeanInstantiator {
    private static final Logger log = Logger.getLogger(Ejb31SpecBeanInstantiator.class.getName());
    private static final String MSG_PREFIX_INSTANTIATION_EXCEPTION = "Could not create new instance with no arguments of: ";

    public <T> T create(Class<T> implClass, Object[] parameters) throws IllegalArgumentException, InvalidConstructionParamsException, BeanInstantiationException {
        T obj;
        if (parameters != null && parameters.length > 0) {
            throw InvalidConstructionParamsException.newInstance((String)("EJB Specification requires a no-argument constructor be invoked for bean instances on " + implClass.getName()));
        }
        try {
            obj = implClass.newInstance();
        }
        catch (InstantiationException e) {
            throw BeanInstantiationException.newInstance((String)(MSG_PREFIX_INSTANTIATION_EXCEPTION + implClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw BeanInstantiationException.newInstance((String)(MSG_PREFIX_INSTANTIATION_EXCEPTION + implClass), (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Created: " + obj + "; instance of " + implClass.getName());
        }
        return obj;
    }
}

