#ifndef __MAIN_H__
#define __MAIN_H__

#include <stdio.h>

#include <QApplication>
#include <QClipboard>
#include <QObject>
#include <QWidget>
#include <QDialog>
#include <QtGlobal>

#include <QDomNode>
#include <QTreeView>
#include <QTextEdit>
#include <QPushButton>
#include <QVBoxLayout>
#include <QSizePolicy>
#include <QToolBar>

using namespace std;

// ----------------------------------------------------------
// MyTetra - программа для накопления осмысленной информации
// Волгодонск, 2010 г.
// Контакты: xintrea@gmail.com, www.webhamster.ru
// Данный исходный код распространяется под лицензией GPL v.3
// © Степанов С. М. 2010
// ----------------------------------------------------------

// 0.1 - Первая версия с приблизительной формой

// 0.14 - Основана на версиях 0.1-0.13
//      - В классе xmltree реализован обход DOM дерева на предмет поиска
//        элементов node и record

// 0.17 - Основана на версиях 0.14-0.16
//      - Класс treeitem стал промежуточным абстрактным классом
//      - Введен класс treenode который хранит дерево папок, в котором должны будут
//        отсутсвовать элементы - конечные записи

// 0.39 - Основана на версиях 0.17-0.38
//       - Сделано добавление записи с сохранением изменений

// 0.101 - Основана на версиях 0.39-0.100
//       - Сделан основной функционал
//         Добавление ветки
//         Добавление подветки
//         Редактирование названия ветки
//         Удаление ветки
//         Полное раскрытие ветки
//         Полное схлопывание ветки
//         Перемещение ветки вверх и вниз в пределах уровня вложенности
//         Добавление записи
//         Редактирование записи в поле просмотра/редактора
//         Редактирование заголовка записи
//         Удаление записи
//         Вырезка записей
//         Копирование записей
//         Вставка записей
//         Перемещение записей вверх и вниз

// 0.104 - Основана на версиях 0.101-0.103
//       - Добавлен запрет редактирования записи если в таблице нет
//         ни одной записи, этот режим в данный момент уже невидим
//       - Если в ветке нет ни одной записи, показывается пустой список и пустые
//         поля редактирования
//       - При клике на ветку меняется курсор, так как эта операция может
//         быть длительной

// 0.114 - Основана на версиях 0.104-0.113
//       - Добавлен прототип виджета поиска по базе, настроены кнопки
//         его появления и сокрытия. Сделаны основные кнопки поиска

// 0.144 - Основана на версиях 0.115-0.113
//       - Редактор сделан в виде отдельного объекта
//       - Поиск в редакторе сделан в виде отдельного объекта
//       - Добавлен механизм обновления конфига в редакторе

// 0.145 - Основана на версии 0.144
//       - Добавлена кнопка "Форматировние кода"
//       - Добавлены элементы настройки кнопки форматирования кода


// 1.00 - Первое сохранение в бекап систему

// 1.01 - Основана на версии 1.00
//      - Сохранение в бекап систему с накопленной базой данных

// 1.02 - Основана на версии 1.01
//      - Промежуточное сохранение

// 1.03 - Основана на версии 1.02
//      - Сделано сохранение картинок в редакторе WyEdit

// 1.04 - Основана на версии 1.03
//      - Доработано сохранение картинок в редакторе WyEdit

// 1.05 - Основана на версии 1.04
//      - При запуске сделана проверка, не запущена ли еще одна
//        копия программы. Если уже есть копия программы, новая программа
//        запущена не будет. Реализовано через QtSingleApplication

// 1.06 - Основана на версии 1.05
//      - Промежуточное сохранение

// 1.07 - Основана на версии 1.06
//      - Сделан режим удаления нескольких выбранных в дереве веток

// 1.08 - Основана на версии 1.07
//      - Сделан режим копирования ветки в буфер обмена

// 1.09 - Основана на версии 1.08
//      - Сделан режим вставки ветки из буфера обмена, базовый функционал

// 1.10 - Основана на версии 1.09
//      - Промежуточное сохранение

// 1.11 - Основана на версии 1.10
//      - Доделан режим вставки ветки из буфера обмена

// 1.12 - Основана на версии 1.11
//      - Сделан режим "cut" для ветки
//      - Сделана автоматическая установка курсора в поле ввода поиска по базе

// 1.13 - Основана на версии 1.12
//      - Изменен механизм обновления версии конфига, добавлен специальный
//        класс, контролирующий обновление конфиг-файла
//      - Удалены лишние пункты в меню
//      - Измены виджеты настроек, оставлены только те, которые нужны программе

// 1.14 - Основана на версии 1.13
//      - Добавлен раздел меню Help
//      - Сделаны пункты меню
//        About MyTetra
//        About Qt
//      - Изменена подсистема вывода отладочной информации, в конфиг-файл
//        добавлен флаг отображения отладочной информации printdebugmessages
//      - Формат конфиг-файла изменен на версию 3
//      - В окне настройки Misc добавлена настройка вывода отладочных
//        сообщений в консоль

// 1.15 - Основана на версии 1.14
//      - Доработаны режимы удаления записей и веток
//        чтобы небыло ошибок при удалении всех записей и всех веток

// 1.16 - Основана на версии 1.15
//      - Сделан правильный старт програмы в случае, если в конфигурации
//        находится недопустимое значение параметра tree_position.
//        Это может произойти, когда программа переключена
//        на другой каталог базы данных
//      - Сделано сохранение картинок в случае, если картинки вставлялись
//        в текст в предварительном окне добавления записи

// 1.17 - Основана на версии 1.16
//      - Промежуточная версия с попыткой передавать записи через
//        буфер обмена с помощью объекта QTextDocumentFragment

// 1.18 - Основана на версии 1.16
//      - Изменения, сделанные в предыдущей версии, удалены
//      - Сделана передача картинок в буфере обмена вместе с текстом
//        когда идет копирование и вставка конечных записей

// 1.19 - Основана на версии 1.18
//      - Сделана передача картинок в буфере обмена вместе с текстом,
//        когда идет копирование и вставка веток

// 1.20 - Основана на версии 1.19
//      - Ревизия кода, обработаны файлы
//        xmltree.*
//        treescreen.*

// 1.21 - Основана на версии 1.20
//      - Сделана ревизия кода в соответсвии с конвенциями наименования C++,
//        обработаны все файлы MyTetra корневого каталога сырцов

// 1.22 - Основана на версии 1.21
//      - Сделана ревизия кода в соответсвии с конвенциями наименования C++,
//        обработаны все файлы редактора WyEdit

// 1.23 - Основана на версии 1.22
//      - Сделана ревизия кода в файлах main.h и main.cpp

// 1.24 - Основана на версии 1.23
//      - Исправлена проблема удаления ветки с записью, в которой
//        небыло завершено редактирование

// 1.25 - Основана на версии 1.24
//      - В классах, обслуживающих таблицу конечных записей удалены
//        свойства, запоминающие директорию и имя файла текущей записи.
//        Вместо них происходит установка директории и файла в редакторе
//      - Из класса MainWindow исключен метод save_current_record_text()
//        использующийся для сохранения текста записи, теперь для этого
//        вызывается метод редактора save_textarea_full()
//      - Добавлено сохранение текщей записи перед началом поиска по всей
//        базе чтобы и в только что введенном тексте были найдены
//        совпадения, если они есть

// 1.26 - Основана на версии 1.25
//      - Исправлено подключение заголовочных файлов Qt-фреймверка,
//        вместо
//        #include <qt4/QtCore/qdir.h>
//        #include <qt4/QtCore/qsettings.h>
//        прописано
//        #include <QDir>
//        #include <QSettings>
//      - Сделано более точное восстановление геометрии окна
//      - Добавлена возможность запуска в системах, в которых отсутсвует
//        системный трей

// 1.27 - Основана на версии 1.26
//      - Исправлены все английские фразы
//      - Добавлены ресурсы с русским языком
//      - Добавлен объект globalParameters
//      - Сделан механизм поиска рабочей директории
//      - Добавлена поддержка переключения языка
//      - Сделано добавление картинок из файлов, есть возможность
//        группового добавления
//      - Исправлен баг с необновлением линейки отступа в некоторых ситуациях
//      - Проверена компиляция и работа под MeeGo

// 1.28 - Основана на версии 1.27
//      - В globalParameters теперь хранятся ссылки на основные объекты
//        главного окна. Это сделано для того, чтобы не использовать
//        поиск объектов по имени, так как при начальной инициализации 
//        MainWindow до выхода из конструктора MainWindow невозможно найти
//        подчиненные объекты MainWindow
//      - Метки сделаны кликабельными, при клике на метку происходит поиск
//      - При выделении картинки и клике на конопку управления картинками
//        появляется окно настройки размеров картинки
//      - Теперь при клике на кнопку просмотра HTML-исходника есть возможность
//        его отредактировать
//      - Появилась возможность выделять часть текста для форматирования в код.
//        Ранее для того, чтобы отформатировать в код нужно было выделять
//        полностью параграф. Теперь можно выделить, например, одно слово,
//        и при нажатии на клавишу "{}" начертанию слова будет применено
//        начертание кода
//      - Появилась настройка цвета кода
//      - Ресурсы (картинки, перевод) из внешних файлов перенесены вовнутрь
//        бинарника и доступ к ним идет через механизм Qt-ресурсов
//      - Сделана более правильная очистка форматирования при нажатии 
//        клавиши сброса форматирования к стандартному
//      - Сделан вызов редактирования свойств картинки по правому клику мыши
//      - Исправлен механизм запоминания размеров области поиска по базе
//      - Добавлена возможность старта программы из любой директории,
//        то есть, теперь не обязательно давать команду cd <директория> в
//        стартовом скрипте
//      - Сделано создание начальных файлов окружения в текущей директории
//        бинарника и в директории пользователя
//      - Сделаны диалоги, которые вызываются при первоначальном старте
//        программы, и которые выясняют, где нужно создать
//        начальные файлы программы
//      - Добавлена кнопка редактирования цвета текста. Скрыта, так как
//        плохо укладывается в концепцию программы
//      - Добавлена кнопка распахивания редактора. Скрыта так как
//        плохо укладывается в концепцию программы
//      - В *.pro файл добавлена секция инсталляции, при команде
//        make install бинарник mytetra копируется в /usr/local/bin

// 1.28.2 - Основана на версии 1.28
//        - Задача > Доработать интерфейс до возможности работать с крупными
//          Qt-виджетами в MeeGo
//        - В редактор добавлена кнопка expandToolsLines для разворачивания
//          и сворачивания всех элементов панели редактора, кроме
//          первой линии
//        - В конфиг редактора editorconf.ini добавлен параметр
//          expand_tools_lines, информирующий о том, в каком состоянии
//          находится панель инструментов
//        - Введено определение APPLICATION_RELEASE_MICROVERSION, которое
//          показывает версию программы в третьей цифре

// 1.28.3 - Основана на версии 1.28.2
//        - Доработан конфиг редактора для запуска его в MeeGo

// 1.28.4 - Основана на версии 1.28.3
//        - Доработан *.pro файл, теперь из него может быть установлено
//          определение TARGET_OS_MEEGO
//        - В класс GlobalParameters добавлены методы
//          getTargetOs()
//          getApplicationName()
//        - Доработаны ресурсы, теперь они содержат конфигурации для
//          обычных операционных систем (any) и для MeeGo (meego)
//        - Доработано автоопределение нахождения базы данных в
//          каталоге ~/.config/имя_программы
//        - Теперь в режиме Standart начальные файлы создаются
//          в каталоге ~/.config/имя_программы, согласно новым правилам
//          разворачивания Linux-приложений

// 1.28.5 - Основана на версии 1.28.4
//        - Все имена файлов прведены в соответсвие к именам классов,
//          каждое начало слова выделяется большой буквой
//        - Добавлены отладочные сообщения в методы определения
//          текущей платформы, под которую собрана программа

// 1.29.0 - Основана на версии 1.28.5
//        - Переделан механизм выделения уникального идентификатора,
//          теперь идентификатор представляет собой 20-ти символьную строку,
//          где первые 10 символов - это timestamp (количество секунд с
//          эпохи Unix), последующие 10 символов - случайные
//        - В main.cpp добавлена функция get_unical_id()
//        - В классе AppConfig удалены методы, считывающие и сохраняющие
//          уникальные идентификаторы узлов, записей, директорий
//        - Сделано обновление конфига до версии 5 в котором исключены
//          параметры lastidnum, lastnotenum, lastprefixnum
//          и добавлены crypt_mode, crypt_check_salt, crypt_check_hash

// 1.29.1 - Основана на версии 1.29.0
//        - Исправлен код метода KnowTreeModel::parse_tree_to_dom() так, чтобы
//          в DOM-элемент попадали все существующие поля, заданные ветке
//        - Изменен прототип метода KnowTreeModel::parse_tree_to_dom() так,
//          чтобы не возникало предупреждения taking address of temporary
//        - В сырцы добавлен подкаталог crypt, в котором добавлены
//          классы Password, Pbkdf2Qt, RC5Simple

// 1.29.2 - Основана на версии 1.29.1
//        - Переработаны методы класса RecordTableData так, чтобы
//          набор инфополей передавался в виде QMap<QString, QString>
//          вместо передачи отдельно каждого поля
//        - Добавлены методы проверки допустимости имени поля
//        - Исправлены все места в коде, которые вызывали
//          возникновение предупреждения taking address of temporary
//        - WyEdit заменен на v.1.2
//        - Удалены все вызовы инициализации случайных чисел, оставлена
//          только инициализация в классе MainWondow

// 1.29.3 - Основана на версии 1.29.2
//        - Сделаны в первом приближении запрос пароля для шифрования ветки
//          и сохранение хеша пароля в конфигфайле хранилища данных

// 1.29.4 - Основана на версии 1.29.3
//        - Сделана возможность шифрования имени ветки и возможность
//          ее расшифровки

// 1.29.5 - Основана на версии 1.29.4
//        - Сделана возможность шифрования таблицы конечных записей
//          и файлов записей

// 1.29.6 - Основана на версии 1.29.5
//        - Сделаны методы для установки функций обратного вызова в редакторе,
//          они нужны для замены стандартной работы с файлами
//        - В редакторе сделано хранение произвольных полей данных,
//          через них функции обратного вызова могут узнавать, в каких
//          режимах им надо работать
//        - Переделан код работы с редактором так, чтобы устанавливались функции
//          обратного вызова для чтения и записи. Внутри этих функций сделана логика
//          как считывать и записывать файл - напрямую или путем шифрации/дешифрации

// 1.29.7 - Основана на версии 1.29.6
//        - Переработан код запроса пароля, теперь пароль автоматически
//          запрашивается при клике на зашифрованную запись
//        - Код запроса и проверки пароля выделен в отдельный 
//          класс Password расположенный в crypt/Password.h/cpp

// 1.29.8 - Основана на версии 1.29.7
//        - Сделано правильное добавление новой записи в зашифрованную ветку

// 1.29.9 - Основана на версии 1.29.8
//        - Сделана блокировка интерфейса и контекстного меню для зашифрованной
//          ветки если пароль не вводился
//        - Сделана блокировка интерфейса и контекстного меню для зашифрованной
//          конечной записи если пароль не вводился
//        - Сделан динамический механизм создания действий QAction в
//          классе TreeScreen

// 1.29.10 - Основана на версии 1.29.9
//         - В настройках добавлен раздел настроек параметров
//           работы с зашифрованными данными

// 1.29.11 - Основана на версии 1.29.10
//         - Доработаны процедуры копирования записей и веток в
//           зашифрованной области и вставки их в
//           зашифрованные и незашифрованные области дерева

// 1.29.12 - Основана на версии 1.29.11
//         - Сделано блокирование копирования ветки, если в ней есть как 
//           незашифрованные, так и зашифрованные данные
//         - При поиске, в случае если не введен пароль, данные в
//           зашифрованных записях не обрабатываются
//         - Сделана процедура смены пароля в окне настроек шифрования
//         - Библиотека RC5Simple заменена на Ver. 1.19 / 15.06.2011
//         - Исправлен svg-файл branch_opened.svg который вызывал появление
//           сообщений
//           QFont::setPointSize: Point size <= 0 (0), must be greater than 0
//         - Сделано обновление состояния значка ветки и подветок
//           после шифрации/дешифрации ветки

// 1.29.13 - Основана на версии 1.29.12
//         - Исправлено двойное появление запроса пароля в случае, если
//           в настройках стоит спрашивать пароль при старте
//           и курсор при восстановлении указывает на зашифрованную ветку
//         - После расшифровки ветки и после удаления ветки теперь
//           происходит проверка, есть ли зашифрованные данные.
//           Если зашифрованных данных нет, вызывается диалог
//           позволяющий сбросить пароль шифрования

// 1.29.14 - Основана на версии 1.29.13
//         - Код реализации сброса пароля перемещен из класса TreeScreen
//           в класс Password
//         - В классе TreeScreen удалено подключение и использование
//           объекта класса DataBaseConfig
//         - Проведена ревизия кода, удалены и исправлены автоматические
//           подключения Qt заголовков в виде qt4/..., QtGui/..., /QtCore/

// 1.29.15 - Основана на версии 1.29.14
//         - Добавлена настройка запуска MyTetra в свернутом окне
//         - Добавлены классы
//           ExecuteCommand
//           ConsoleEmulator

// 1.29.16 - Основана на версии 1.29.15
//         - В диалоге синхронизации сделано закрытие процесса и окна
//           при клике на Cancel
//         - В настройках сделан раздел настройки синхронизации
//         - Сделана проверка на наличие строки с командой синхронизации
//           если команды не указано, выводится предупреждающее сообщение

// 1.29.17 - Основана на версии 1.29.16
//         - В виджет отображения консольного вывода добавлена кнопка
//           показать/скрыть подробности
//         - Сделано запоминание состояния этой кнопки
//         - Конфиг обновлен на версию 9
//         - Переделан механим удаления объекта дерева записей и соответсвенно
//           объектов веток и объектов таблицы конечных записей. Теперь вместо
//           физического удаления объектов вместе с данными на диске
//           сделано мягкое удаление - удаляются только данные в памяти.
//           Для физического удаления записей используются специальные методы

// 1.29.18 - Основана на версии 1.29.17
//         - Доработан механизм обновления дерева записей после синхронизации
//         - Сделана возможность автозапуска синхронизации при
//           старте и при выходе из программы согласно настройкам

// 1.29.19 - Основана на версии 1.29.18
//         - Сделано глобальное переименование методов
//           из вида this_is_method_name() на thisIsMethodName()

// 1.29.20 - Основана на версии 1.29.19
//         - Сделана настройка времени ожидания нажатия Cancel в окне ввода
//           пароля
//         - Виджет окна ввода пароля переделан на возможность
//           установки времени закрытия
//         - Конфиг обновлен на версию 10
//         - Добавлено условие, что если в системе пароль вообще не задан,
//           то он не запрашивается при старте даже если сделана настройка
//           что при старте надо запрашивать пароль

// 1.29.21 - Основана на версии 1.29.20
//         - Сделано чтобы при двойном клике не открывалась ветка
//           на редактирование а просто раскрывались подветки
//           Редактирование продолжает быть доступно по
//           клавише "Редактировать название ветки". Это сделано для того,
//           чтобы было удобне работать с деревом и не целиться
//           в [+] для разворачивания ветки
//         - Сделана очередная чистка кода чтобы небыло автоматически
//           подключенных NetBeans Qt-заголовков в виде <*.h> файлов

// 1.29.22 - Основана на версии 1.29.21
//         - Редактор заменен на WyEdit v.1.4
//         - В метод AddNewRecord::setupUI() добавлена команда блокирования
//           инструмента "save" редактора, так как в окне добавления записи
//           для сохранения записи однозначно используется кнопка OK

// 1.29.23 - Основана на версии 1.29.22
//         - Сделано сохранение позиции курсора и позиции прокрутки
//           в окне редактирования записи при выходе из программы
//         - Конфиг обновлен на версию 11
//         - Добавлен класс истории посещаемых записей
//         - Сделана навигация по истории посещаемых записей

// 1.29.24 - Основана на версии 1.29.23
//         - Переделан механизм выбора конечной записи мышкой и клавишами
//         - Доработан объект истории посещаемых записей

// 1.29.25 - Основана на версии 1.29.24
//         - Сделана возможность хранить пароль (точнее хеш пароля)
//           локально, чтобы не вводить его каждый раз
//         - Переделана страница настройки свойств шифрования,
//           добавлена опция включающая возможность хранить
//           пароль (точнее хеш пароля) локально
//         - В main.cpp добавлен код, проверяющий хранится ли пароль
//           (точнее хеш пароля) локально. Если хранится то сразу хеш пароля
//           преобразуется в ключ шифрования чтобы зашифрованные
//           ветки были доступны
//         - Пароль (точнее хеш парля) хранится в общем конфиге, который
//           не подлежит синхронизации через интернет. Таким образом,
//           можно хранить зашифрованные данные и синхронизироваться
//           через интернет, а пароль остается никому недоступен

// 1.29.26 - Основана на версии 1.29.25
//         - Исправлены названия сигналов и слотов, которые были изменены
//           при приведении названий методов к виду normalMethodName(),
//           из-за которых перестал работать при клике по текстовой метке

// 1.29.27 - Основана на версии 1.29.26
//         - Исправлены имена файлов некоторых иконок, так как они были
//           написаны не с префиксом, использущим внутреннее хранилище
//           ресурсов, а как обычные файлы относительно директории запуска
//         - Исправлена проблема, при которой автоматически не запоминались
//           изменения в тексте записи

// 1.29.28 - Основана на версии 1.29.27
//         - Добавлены настройки
//           возможность восстановить позицию курсора при навигации по истории
//           возможность восстановить позицию курсора при обычном выборе записи
//         - Восстановление позиции курсора сделано согласно данным настройкам

// 1.29.29 - Основана на версии 1.29.28
//         - В классе ExecuteCommand исправлена работа с объектом QProcess,
//           чтобы имелась возможность в Windows нормально закрывать
//           окно синхронизации с удалением процесса

// 1.30.0  - Основана на версии 1.29.29
//         - Последние тесты завершены, версия обновлена

// 1.30.1 - Основана на версии 1.30.0
//        - В файле Password.cpp заменены обращения QString::QString() просто 
//          на QString(), так как в GCC старше 4.5 возникает ошибка вида
//          cannot call constructor QString::QString directly
//        - Библиотека RC5Simple заменена на Ver. 1.23 / 16.07.2011


// Версия программы
#define APPLICATION_RELEASE_VERSION         1
#define APPLICATION_RELEASE_SUBVERSION     30
#define APPLICATION_RELEASE_MICROVERSION    1

// Поддерживаемая версия формата базы (хранилища)
#define CURRENT_FORMAT_VERSION    1
#define CURRENT_FORMAT_SUBVERSION 1


#define ADD_NEW_RECORD_TO_END         0
#define ADD_NEW_RECORD_BEFORE         1
#define ADD_NEW_RECORD_AFTER          2


// Прототипы функций, которые могут использоваться в других файлах
void logprint(char *lpszText, ...);
void critical_error(QString message);
void info_window(QString i);
QString xmlnode_to_string(QDomNode xmlData);

void remove_directory_to_trash(QString nameDirFrom);
void remove_file_to_trash(QString fileNameFrom);
QString create_temp_directory(void);
bool remove_directory(const QString &dirName);
bool copy_directory(const QString &fromName, const QString &toName);
QMap<QString, QByteArray> get_files_from_directory(QString dirName, QString fileMask="*");
bool save_files_to_directory(QString dirName, QMap<QString, QByteArray> fileList);

void print_object_tree(void);
bool compare_QStringList_len(const QStringList &list1, const QStringList &list2);
void insert_action_as_button(QToolBar *tools_line, QAction *action);
int imax(int x1, int x2);
int imin(int x1, int x2);
void myMessageOutput(QtMsgType type, const char *msg);
QStringList text_delimiter_decompose(QString text);
QString get_unical_id(void);
int get_milli_count(void);
void init_random(void);
void convertByteArrayToVector(const QByteArray &qba, vector<unsigned char> &vec);
void convertVectorToByteArray(const vector<unsigned char> &vec, QByteArray &qba);
QString encryptString(QByteArray key, QString line);
QString decryptString(QByteArray key, QString line);
QByteArray encryptStringToByteArray(QByteArray key, QString line);
QString decryptStringFromByteArray(QByteArray key, QByteArray data);
void encryptFile(QByteArray key, QString fileName);
void decryptFile(QByteArray key, QString fileName);
void encDecFileSmart(QByteArray key, QString fileName, int mode);

// template <class X> inline X *find_object(QString n);


// Поиск объекта от корня по имени
template <class X> inline X *find_object(QString n)
{
 QObject *findObj;

 extern QObject *pMainWindow;

 // Если запрошен сам корень
 if(n=="mainwindow")
  {
   QObject *mvp=qobject_cast<X *>(pMainWindow);

   if(mvp->metaObject()->className()!=pMainWindow->metaObject()->className())
    {
     // Если запрошенный класс объекта не является классом главного окна
     printf("find_object(): Can't find mainwindow object. Check <type> in function call\n");
     exit(1);
     return NULL;
    }
   else
    return qobject_cast<X *>(pMainWindow);
  }

 // Запрошен обычный объект, надо его найти
 findObj=qFindChild<X *>(pMainWindow,n);

 if(findObj==NULL)
  {
   // Если объекта с указанным именем не найдено
   // print_object_tree();
   printf("find_object(): Can't find object with name %s\n",qPrintable(n));
   exit(1);
   return NULL;
  }
 else
  {
   // ОБъект был найден, и нужно преобразовать указатель на него
   // к указателю c заданным в шаблоне типом
   X *obj=qobject_cast<X *>(findObj);

   if(obj==0)
    {
     // Если найденный объект не может быть преобразован к заданному в шаблоне типу
     printf("find_object(): Object %s find, but can't convert type. Check <type> in function call\n",qPrintable(n));
     exit(1);
     return NULL;
    }
   else
    return obj; // Объект найден нормально
  }
}


#endif // __MAIN_H__
