/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import java.lang.annotation.Annotation;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.jasper.servlet.JspServlet;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class J2EEInstanceListener
implements InstanceListener {
    private static final Logger _logger = WebContainer.logger;
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    @LogMessageInfo(message="*** InstanceEvent: {0}", level="FINEST")
    public static final String INSTANCE_EVENT = "AS-WEB-GLUE-00265";
    @LogMessageInfo(message="Obtained securityContext implementation class {0}", level="FINE")
    public static final String SECURITY_CONTEXT_OBTAINED = "AS-WEB-GLUE-00266";
    @LogMessageInfo(message="Failed to obtain securityContext implementation class", level="FINE")
    public static final String SECURITY_CONTEXT_FAILED = "AS-WEB-GLUE-00267";
    @LogMessageInfo(message="Exception during processing of event of type {0} for web module {1}", level="SEVERE", cause="An exception occurred during processing event type", action="Check the exception for the error")
    public static final String EXCEPTION_DURING_HANDLE_EVENT = "AS-WEB-GLUE-00268";
    @LogMessageInfo(message="No ServerContext in WebModule [{0}]", level="WARNING")
    public static final String NO_SERVER_CONTEXT = "AS-WEB-GLUE-00269";
    private InvocationManager im;
    private JavaEETransactionManager tm;
    private InjectionManager injectionMgr;
    private boolean initialized = false;
    private AppServSecurityContext securityContext;
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");

    public void instanceEvent(InstanceEvent event) {
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        this.init(wm);
        InstanceEvent.EventType eventType = event.getType();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, INSTANCE_EVENT, eventType);
        }
        if (eventType.isBefore) {
            this.handleBeforeEvent(event, eventType);
        } else {
            this.handleAfterEvent(event, eventType);
        }
    }

    private synchronized void init(WebModule wm) {
        if (this.initialized) {
            return;
        }
        ServerContext serverContext = wm.getServerContext();
        if (serverContext == null) {
            String msg = _rb.getString(NO_SERVER_CONTEXT);
            msg = MessageFormat.format(msg, wm.getName());
            throw new IllegalStateException(msg);
        }
        ServiceLocator services = serverContext.getDefaultServices();
        this.im = (InvocationManager)services.getService(InvocationManager.class, new Annotation[0]);
        this.tm = this.getJavaEETransactionManager(services);
        this.injectionMgr = (InjectionManager)services.getService(InjectionManager.class, new Annotation[0]);
        this.initialized = true;
        this.securityContext = (AppServSecurityContext)serverContext.getDefaultServices().getService(AppServSecurityContext.class, new Annotation[0]);
        if (this.securityContext != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, SECURITY_CONTEXT_OBTAINED, this.securityContext);
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, SECURITY_CONTEXT_FAILED);
        }
    }

    private void handleBeforeEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        ServletRequest request;
        Context context = (Context)event.getWrapper().getParent();
        if (!(context instanceof WebModule)) {
            return;
        }
        WebModule wm = (WebModule)context;
        Object instance = eventType == InstanceEvent.EventType.BEFORE_FILTER_EVENT ? event.getFilter() : event.getServlet();
        Realm ra = context.getRealm();
        if (ra != null && (request = event.getRequest()) != null && request instanceof HttpServletRequest) {
            Principal prin;
            HttpServletRequest hreq;
            HttpServletRequest base = hreq = (HttpServletRequest)request;
            Principal basePrincipal = prin = hreq.getUserPrincipal();
            boolean wrapped = false;
            while (prin != null) {
                ServletRequest sr;
                if (base instanceof ServletRequestWrapper && (sr = ((ServletRequestWrapper)((Object)base)).getRequest()) instanceof HttpServletRequest) {
                    base = (HttpServletRequest)sr;
                    wrapped = true;
                    continue;
                }
                if (wrapped) {
                    basePrincipal = base.getUserPrincipal();
                    break;
                }
                if (base instanceof RequestFacade) {
                    if (base.getClass() == RequestFacade.class) break;
                    basePrincipal = ((RequestFacade)base).getUnwrappedCoyoteRequest().getUserPrincipal();
                    break;
                }
                basePrincipal = base.getUserPrincipal();
                break;
            }
            if (prin != null && prin == basePrincipal && prin.getClass().getName().equals("com.sun.enterprise.security.web.integration.WebPrincipal")) {
                this.securityContext.setSecurityContextWithPrincipal(prin);
            } else if (prin != basePrincipal) {
                J2EEInstanceListener.checkObjectForDoAsPermission(hreq);
                this.securityContext.setSecurityContextWithPrincipal(prin);
            }
        }
        WebComponentInvocation inv = eventType == InstanceEvent.EventType.BEFORE_INIT_EVENT ? new WebComponentInvocation(wm, instance, event.getWrapper().getName()) : new WebComponentInvocation(wm, instance);
        try {
            this.im.preInvoke((ComponentInvocation)inv);
            if (eventType == InstanceEvent.EventType.BEFORE_SERVICE_EVENT) {
                wm.beforeServiceEvent(event.getWrapper().getName());
                if (this.tm != null) {
                    this.tm.enlistComponentResources();
                }
            }
        }
        catch (Exception ex) {
            this.im.postInvoke((ComponentInvocation)inv);
            String msg = _rb.getString(EXCEPTION_DURING_HANDLE_EVENT);
            msg = MessageFormat.format(msg, new Object[]{eventType, wm});
            throw new RuntimeException(msg, ex);
        }
    }

    private static void checkObjectForDoAsPermission(final Object o) throws AccessControlException {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ProtectionDomain pD = o.getClass().getProtectionDomain();
                    Policy p = Policy.getPolicy();
                    if (!p.implies(pD, doAsPrivilegedPerm)) {
                        throw new AccessControlException("permission required to override getUserPrincipal", doAsPrivilegedPerm);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAfterEvent(InstanceEvent event, InstanceEvent.EventType eventType) {
        WebComponentInvocation inv;
        Object instance;
        WebModule wm;
        Context context;
        Wrapper wrapper;
        block34: {
            wrapper = event.getWrapper();
            context = (Context)wrapper.getParent();
            if (!(context instanceof WebModule)) {
                return;
            }
            wm = (WebModule)context;
            instance = eventType == InstanceEvent.EventType.AFTER_FILTER_EVENT ? event.getFilter() : event.getServlet();
            if (instance == null) {
                return;
            }
            if (instance instanceof Servlet) {
                if (eventType == InstanceEvent.EventType.AFTER_INIT_EVENT) {
                    wm.servletInitializedEvent(wrapper.getName());
                } else if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                    wm.servletDestroyedEvent(wrapper.getName());
                }
            }
            try {
                if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT && !DefaultServlet.class.equals(instance.getClass()) && !JspServlet.class.equals(instance.getClass())) {
                    this.injectionMgr.destroyManagedObject(instance, false);
                }
            }
            catch (InjectionException ie) {
                String msg = _rb.getString(EXCEPTION_DURING_HANDLE_EVENT);
                msg = MessageFormat.format(msg, new Object[]{eventType, wm});
                _logger.log(Level.SEVERE, msg, ie);
            }
            inv = new WebComponentInvocation(wm, instance);
            try {
                this.im.postInvoke((ComponentInvocation)inv);
                if (eventType != InstanceEvent.EventType.AFTER_DESTROY_EVENT) break block34;
                if (this.tm == null) return;
            }
            catch (Exception ex) {
                try {
                    String msg = _rb.getString(EXCEPTION_DURING_HANDLE_EVENT);
                    msg = MessageFormat.format(msg, new Object[]{eventType, wm});
                    throw new RuntimeException(msg, ex);
                }
                catch (Throwable throwable) {
                    if (eventType == InstanceEvent.EventType.AFTER_DESTROY_EVENT) {
                        if (this.tm == null) throw throwable;
                        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                        throw throwable;
                    }
                    if (eventType != InstanceEvent.EventType.AFTER_FILTER_EVENT && eventType != InstanceEvent.EventType.AFTER_SERVICE_EVENT) throw throwable;
                    if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
                        ServletResponse response = event.getResponse();
                        int status = -1;
                        if (response != null && response instanceof HttpServletResponse) {
                            status = ((HttpServletResponse)response).getStatus();
                        }
                        wm.afterServiceEvent(wrapper.getName(), status);
                    }
                    if (this.im.getCurrentInvocation() == null) {
                        try {
                            Realm ra = context.getRealm();
                            if (ra != null && ra instanceof RealmInitializer) {
                                ((RealmInitializer)ra).logout();
                            }
                        }
                        catch (Exception ex2) {
                            String msg = _rb.getString(EXCEPTION_DURING_HANDLE_EVENT);
                            msg = MessageFormat.format(msg, new Object[]{eventType, wm});
                            _logger.log(Level.SEVERE, msg, ex2);
                        }
                        if (this.tm != null) {
                            try {
                                if (this.tm.getTransaction() != null) {
                                    this.tm.rollback();
                                }
                                this.tm.cleanTxnTimeout();
                            }
                            catch (Exception ex3) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.tm == null) throw throwable;
                    this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
                    throw throwable;
                }
            }
            this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
            return;
        }
        if (eventType != InstanceEvent.EventType.AFTER_FILTER_EVENT && eventType != InstanceEvent.EventType.AFTER_SERVICE_EVENT) return;
        if (eventType == InstanceEvent.EventType.AFTER_SERVICE_EVENT) {
            ServletResponse response = event.getResponse();
            int status = -1;
            if (response != null && response instanceof HttpServletResponse) {
                status = ((HttpServletResponse)response).getStatus();
            }
            wm.afterServiceEvent(wrapper.getName(), status);
        }
        if (this.im.getCurrentInvocation() == null) {
            try {
                Realm ra = context.getRealm();
                if (ra != null && ra instanceof RealmInitializer) {
                    ((RealmInitializer)ra).logout();
                }
            }
            catch (Exception ex) {
                String msg = _rb.getString(EXCEPTION_DURING_HANDLE_EVENT);
                msg = MessageFormat.format(msg, new Object[]{eventType, wm});
                _logger.log(Level.SEVERE, msg, ex);
            }
            if (this.tm != null) {
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                    this.tm.cleanTxnTimeout();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.tm == null) return;
        this.tm.componentDestroyed(instance, (ComponentInvocation)inv);
        return;
    }

    private JavaEETransactionManager getJavaEETransactionManager(ServiceLocator services) {
        JavaEETransactionManager tm = null;
        ServiceHandle inhabitant = services.getServiceHandle(JavaEETransactionManager.class, new Annotation[0]);
        if (inhabitant != null && inhabitant.isActive()) {
            tm = (JavaEETransactionManager)inhabitant.getService();
        }
        return tm;
    }
}

