/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class Tool {
    @LogMessageInfo(message="Must set 'catalina.home' system property", level="SEVERE", cause="Did not set 'catalina.home'", action="Verify that 'catalina.home' was passed")
    public static final String MUST_SET_SYS_PROPERTY = "AS-WEB-CORE-00470";
    @LogMessageInfo(message="Class loader creation threw exception", level="SEVERE", cause="Could not create a new class loader", action="Verify directory paths")
    public static final String CLASS_LOADER_CREATION_EXCEPTION = "AS-WEB-CORE-00471";
    @LogMessageInfo(message="Exception creating instance of {0}", level="SEVERE", cause="Could not load application class", action="Verify the class name")
    public static final String CREATING_INSTANCE_EXCEPTION = "AS-WEB-CORE-00472";
    @LogMessageInfo(message="Exception locating main() method", level="SEVERE", cause="Could not locate the static main() method of the application class", action="Verify the access permission")
    public static final String LOCATING_MAIN_METHOD_EXCEPTION = "AS-WEB-CORE-00473";
    @LogMessageInfo(message="Exception calling main() method", level="SEVERE", cause="Could not invoke main() method", action="Verify the underlying method is inaccessible, and parameter values")
    public static final String CALLING_MAIN_METHOD_EXCEPTION = "AS-WEB-CORE-00474";
    @LogMessageInfo(message="Usage:  java org.apache.catalina.startup.Tool [<options>] <class> [<arguments>]", level="INFO")
    public static final String USAGE_INFO = "AS-WEB-CORE-00475";
    private static boolean ant = false;
    private static String catalinaHome = System.getProperty("catalina.home");
    private static boolean common = false;
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    private static boolean server = false;
    private static boolean shared = false;

    public static void main(String[] args) {
        if (catalinaHome == null) {
            log.log(Level.SEVERE, MUST_SET_SYS_PROPERTY);
            System.exit(1);
        }
        int index = 0;
        while (true) {
            if (index == args.length) {
                Tool.usage();
                System.exit(1);
            }
            if ("-ant".equals(args[index])) {
                ant = true;
            } else if ("-common".equals(args[index])) {
                common = true;
            } else if ("-server".equals(args[index])) {
                server = true;
            } else {
                if (!"-shared".equals(args[index])) break;
                shared = true;
            }
            ++index;
        }
        if (index > args.length) {
            Tool.usage();
            System.exit(1);
        }
        if (ant) {
            System.setProperty("ant.home", catalinaHome);
        }
        ClassLoader classLoader = null;
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Constructing class loader");
                ClassLoaderFactory.setDebug(1);
            }
            ArrayList<File> packed = new ArrayList<File>();
            ArrayList<File> unpacked = new ArrayList<File>();
            unpacked.add(new File(catalinaHome, "classes"));
            packed.add(new File(catalinaHome, "lib"));
            if (common) {
                unpacked.add(new File(catalinaHome, "common" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "common" + File.separator + "lib"));
            }
            if (server) {
                unpacked.add(new File(catalinaHome, "server" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "server" + File.separator + "lib"));
            }
            if (shared) {
                unpacked.add(new File(catalinaHome, "shared" + File.separator + "classes"));
                packed.add(new File(catalinaHome, "shared" + File.separator + "lib"));
            }
            classLoader = ClassLoaderFactory.createClassLoader(unpacked.toArray(new File[unpacked.size()]), packed.toArray(new File[packed.size()]), null);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, CLASS_LOADER_CREATION_EXCEPTION, t);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> clazz = null;
        String className = args[index++];
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Loading application class " + className);
            }
            clazz = classLoader.loadClass(className);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format(rb.getString(CREATING_INSTANCE_EXCEPTION), className);
            log.log(Level.SEVERE, msg, t);
            System.exit(1);
        }
        Method method = null;
        String[] params = new String[args.length - index];
        System.arraycopy(args, index, params, 0, params.length);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Identifying main() method");
            }
            String methodName = "main";
            Class[] paramTypes = new Class[]{params.getClass()};
            method = clazz.getMethod(methodName, paramTypes);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, LOCATING_MAIN_METHOD_EXCEPTION, t);
            System.exit(1);
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Calling main() method");
            }
            Object[] paramValues = new Object[]{params};
            method.invoke(null, paramValues);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, CALLING_MAIN_METHOD_EXCEPTION, t);
            System.exit(1);
        }
    }

    private static void usage() {
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, USAGE_INFO);
        }
    }
}

