/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class LogFile
implements Serializable {
    private static final long serialVersionUID = -2960142541274652618L;
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private long _indexSize = 10L;
    private String _logFileName = null;
    private List _recordIdx = new ArrayList();

    public LogFile(String name) {
        this._logFileName = name;
        this._recordIdx.add(0L);
    }

    public List getLogEntries(long startingRecord) {
        return this.getLogEntries(startingRecord, this.getIndexSize());
    }

    public List getLogEntries(final long startingRecord, final long maxRecords) {
        if (startingRecord < 0L) {
            return null;
        }
        final long recordsToIgnore = startingRecord % this.getIndexSize();
        BufferedReader reader = this.getFilePosition(startingRecord - recordsToIgnore);
        final ArrayList results = new ArrayList();
        if (reader == null) {
            return results;
        }
        try {
            File logFile = new File(this.getLogFileName());
            LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
            logParser.parseLog(reader, new LogParserListener(){
                long counter = 0L;

                @Override
                public void outputSummary(BufferedWriter writer, Object ... objects) throws IOException {
                }

                @Override
                public void foundLogRecord(long position, ParsedLogRecord logRecord) {
                    ++this.counter;
                    if (this.counter <= recordsToIgnore) {
                        return;
                    }
                    if ((long)results.size() < maxRecords) {
                        LogEntry entry = new LogEntry(logRecord.getFormattedLogRecord(), startingRecord + (long)results.size());
                        entry.setLoggedDateTime(new Date(logRecord.getTimeMillis()));
                        entry.setLoggedLevel(logRecord.getLevel());
                        entry.setLoggedLoggerName(logRecord.getLogger());
                        entry.setLoggedMessage(logRecord.getMessage());
                        entry.setLoggedNameValuePairs(logRecord.getSupplementalAttributes().toString());
                        entry.setLoggedProduct(logRecord.getComponentId());
                        entry.setMessageId(logRecord.getMessageId());
                        results.add(entry);
                    }
                }

                @Override
                public void close() throws IOException {
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return results;
    }

    private synchronized void buildLogFileIndex() {
        final long startPos = (Long)this._recordIdx.get(this._recordIdx.size() - 1);
        final long localIndexSize = this.getIndexSize();
        BufferedReader reader = this.getLogFileReader(startPos);
        try {
            File logFile = new File(this.getLogFileName());
            LogParser logParser = LogParserFactory.getInstance().createLogParser(logFile);
            if (logParser != null) {
                logParser.parseLog(reader, new LogParserListener(){
                    long recordNumber;
                    {
                        this.recordNumber = (long)(LogFile.this._recordIdx.size() - 1) * localIndexSize;
                    }

                    @Override
                    public void outputSummary(BufferedWriter writer, Object ... objects) throws IOException {
                    }

                    @Override
                    public void foundLogRecord(long position, ParsedLogRecord object) {
                        long modIndex = this.recordNumber % localIndexSize;
                        if (modIndex == 0L) {
                            LogFile.this._recordIdx.add(startPos + position);
                        }
                        ++this.recordNumber;
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private BufferedReader getFilePosition(long recordNumber) {
        int index = (int)(recordNumber / this.getIndexSize());
        if (index > this._recordIdx.size() - 1) {
            return null;
        }
        Long filePosition = (Long)this._recordIdx.get(index);
        return this.getLogFileReader(filePosition);
    }

    protected BufferedReader getLogFileReader(long fromFilePosition) {
        FileInputStream file = null;
        try {
            long bytesSkipped;
            file = new FileInputStream(this.getLogFileName());
            long bytesToSkip = fromFilePosition - 1L;
            if (bytesToSkip > 0L && (bytesSkipped = file.skip(bytesToSkip)) != fromFilePosition && LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                LogFacade.LOGGING_LOGGER.log(Level.FINE, "Did not skip exact bytes while positioning reader in " + this.getLogFileName());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            return reader;
        }
        catch (Exception ex) {
            block7: {
                if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error reading from file: " + this.getLogFileName(), ex);
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception ex2) {
                        if (!LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) break block7;
                        LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error closing file: " + this.getLogFileName(), ex2);
                    }
                }
            }
            return null;
        }
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public long getLastIndexNumber() {
        this.buildLogFileIndex();
        return this._recordIdx.size() - 1;
    }

    public long getIndexSize() {
        return this._indexSize;
    }

    public static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = -8597022493595023899L;
        private long recordNumber = -1L;
        private Date loggedDateTime = null;
        private String loggedLevel = null;
        private String loggedProduct = null;
        private String loggedLoggerName = null;
        private String loggedNameValuePairs = null;
        private String loggedMessage = null;
        private String messageId = "";

        public LogEntry(String line, long recordNumber) {
            this.setRecordNumber(recordNumber);
        }

        public Date getLoggedDateTime() {
            return this.loggedDateTime;
        }

        public void setLoggedDateTime(Date loggedDateTime) {
            this.loggedDateTime = loggedDateTime;
        }

        public String getLoggedLevel() {
            return this.loggedLevel;
        }

        public void setLoggedLevel(String loggedLevel) {
            this.loggedLevel = loggedLevel;
        }

        public String getLoggedProduct() {
            return this.loggedProduct;
        }

        public void setLoggedProduct(String loggedProduct) {
            this.loggedProduct = loggedProduct;
        }

        public String getLoggedLoggerName() {
            return this.loggedLoggerName;
        }

        public void setLoggedLoggerName(String loggedLoggerName) {
            this.loggedLoggerName = loggedLoggerName;
        }

        public String getLoggedNameValuePairs() {
            return this.loggedNameValuePairs;
        }

        public void setLoggedNameValuePairs(String loggedNameValuePairs) {
            this.loggedNameValuePairs = loggedNameValuePairs;
        }

        public void setLoggedMessage(String message) {
            this.loggedMessage = message;
        }

        public void appendLoggedMessage(String message) {
            this.loggedMessage = this.loggedMessage + message;
        }

        public String getLoggedMessage() {
            return this.loggedMessage;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public long getRecordNumber() {
            return this.recordNumber;
        }

        public void setRecordNumber(long recordNumber) {
            this.recordNumber = recordNumber;
        }

        public String toString() {
            return this.getRecordNumber() + ":" + this.getLoggedMessage();
        }
    }
}

