/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesInitializatonPolicy;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class DynamicPropertiesManager {
    public static final String PROPERTIES_MANAGER_FIELD = "DPM";
    protected DynamicTypeImpl type;
    protected DynamicPropertiesInitializatonPolicy dpInitializatonPolicy = new DynamicPropertiesInitializatonPolicy();

    public DynamicType getType() {
        return this.type;
    }

    public void setType(DynamicType type) {
        this.type = (DynamicTypeImpl)type;
    }

    public DynamicPropertiesInitializatonPolicy getInitializatonPolicy() {
        return this.dpInitializatonPolicy;
    }

    public void setInitializatonPolicy(DynamicPropertiesInitializatonPolicy dpInitializatonPolicy) {
        this.dpInitializatonPolicy = dpInitializatonPolicy;
    }

    public void postConstruct(DynamicEntity entity) {
        this.createSlots((DynamicEntityImpl)entity);
        this.initializeSlotValues((DynamicEntityImpl)entity);
    }

    protected void createSlots(DynamicEntityImpl entity) {
        Map<String, DynamicEntityImpl.PropertyWrapper> propertiesMap = entity.getPropertiesMap();
        List<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                propertiesMap.put(propertyName, new DynamicEntityImpl.PropertyWrapper(entity));
            }
        }
    }

    protected void initializeSlotValues(DynamicEntityImpl entity) {
        this.getInitializatonPolicy().initializeProperties(this.type, entity);
    }

    public boolean contains(String propertyName) {
        boolean contains = false;
        if (this.type != null && this.type.getDescriptor() != null) {
            for (DatabaseMapping dm : this.type.getDescriptor().getMappings()) {
                if (!dm.getAttributeName().equals(propertyName)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (this.type != null && this.type.getDescriptor() != null) {
            for (DatabaseMapping dm : this.type.getDescriptor().getMappings()) {
                propertyNames.add(dm.getAttributeName());
            }
        }
        return propertyNames;
    }

    public void checkSet(String propertyName, Object value) {
        if (!this.contains(propertyName)) {
            throw DynamicException.invalidPropertyName(this.type, propertyName);
        }
        this.type.checkSet(propertyName, value);
    }
}

