/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.registration.glassfish.ModuleMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActiveModules {
    private static final int UNMAPPED_MODULE = 384;
    private static final int NLONGS = 6;
    private ModulesRegistry registry;
    private Logger logger;

    public ActiveModules(Logger logger, ModulesRegistry registry) {
        this.logger = logger;
        this.registry = registry;
    }

    public String generateModuleStatus() {
        long[] loadedModules = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        StringBuilder str = new StringBuilder(128);
        for (Module m : this.registry.getModules()) {
            int group;
            if (m.getState() != ModuleState.READY) continue;
            Integer bit = ModuleMap.getMap().get(m.getName());
            if (bit == null) {
                bit = 384;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("ActiveModules: Unmapped module: " + m.getName());
                }
            }
            if ((group = (bit - 1) / 64) > 5) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("ActiveModules: id out of range: " + m.getName() + " " + bit);
                continue;
            }
            if ((bit = Integer.valueOf(bit - 64 * group)) == null) continue;
            int n = group;
            loadedModules[n] = loadedModules[n] | 1L << bit - 1;
        }
        for (int i = 5; i >= 0; --i) {
            str.append(Long.toHexString(loadedModules[i]));
            if (i == 0) continue;
            str.append(" ");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("ActiveModules: loadModules[0]: " + Long.toBinaryString(loadedModules[0]));
            this.logger.fine("ActiveModules: loadModules[1]: " + Long.toBinaryString(loadedModules[1]));
            this.logger.fine("ActiveModules: loadModules[2]: " + Long.toBinaryString(loadedModules[2]));
            this.logger.fine("ActiveModules: loadModules[3]: " + Long.toBinaryString(loadedModules[3]));
            this.logger.fine("ActiveModules: loadModules[4]: " + Long.toBinaryString(loadedModules[4]));
            this.logger.fine("ActiveModules: loadModules[5]: " + Long.toBinaryString(loadedModules[5]));
        }
        return str.toString();
    }
}

