/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class ObrURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String SYNTAX = "obr:<bundle-symbolic-name>['/'<bundle-version>]";
    public static final String OBR_UPDATE_STRATEGY = "obr.update.strategy";
    private final BundleContext m_bundleContext;
    private final RepositoryAdmin m_reRepositoryAdmin;
    private final Logger m_logger;
    private String m_updateStrategy = "newest";

    public ObrURLStreamHandlerService(BundleContext context, RepositoryAdmin admin) {
        this.m_bundleContext = context;
        this.m_reRepositoryAdmin = admin;
        this.m_logger = new Logger(context);
        if (this.m_bundleContext.getProperty(OBR_UPDATE_STRATEGY) != null) {
            this.m_updateStrategy = this.m_bundleContext.getProperty(OBR_UPDATE_STRATEGY);
        }
    }

    public URLConnection openConnection(URL u) throws IOException {
        String url = u.toExternalForm();
        URL remoteURL = null;
        try {
            Bundle[] bundles = this.m_bundleContext.getBundles();
            for (int i = 0; remoteURL == null && i < bundles.length; ++i) {
                if (!url.equals(bundles[i].getLocation())) continue;
                remoteURL = this.getRemoteUrlForBundle(bundles[i]);
            }
            if (remoteURL == null) {
                String path = u.getPath();
                remoteURL = this.getRemoteObrInstallUrl(path);
            }
        }
        catch (InvalidSyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return remoteURL.openConnection();
    }

    private URL getRemoteObrInstallUrl(String path) throws IOException, InvalidSyntaxException {
        Resource[] discoverResources;
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax obr:<bundle-symbolic-name>['/'<bundle-version>]");
        }
        String[] segments = path.split("/");
        if (segments.length > 2) {
            throw new MalformedURLException("Path cannot contain more then one '/'. Syntax  obr:<bundle-symbolic-name>['/'<bundle-version>]");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("(symbolicname=").append(segments[0]).append(")");
        if (!this.validateFilter(buffer.toString())) {
            throw new MalformedURLException("Invalid symbolic name value.");
        }
        if (segments.length > 1) {
            buffer.insert(0, "(&").append("(version=").append(segments[1]).append("))");
            if (!this.validateFilter(buffer.toString())) {
                throw new MalformedURLException("Invalid version value.");
            }
        }
        if ((discoverResources = this.m_reRepositoryAdmin.discoverResources(buffer.toString())) == null || discoverResources.length == 0) {
            throw new IOException("No resource found for filter [" + buffer.toString() + "]");
        }
        NewestSelectionStrategy strategy = new NewestSelectionStrategy(this.m_logger);
        Resource selected = strategy.selectOne(Version.emptyVersion, discoverResources);
        return new URL(selected.getURI());
    }

    private boolean validateFilter(String filter) {
        try {
            FrameworkUtil.createFilter((String)filter);
            return true;
        }
        catch (InvalidSyntaxException e) {
            return false;
        }
    }

    private URL getRemoteUrlForBundle(Bundle bundle) throws IOException, InvalidSyntaxException {
        String symbolicName = bundle.getSymbolicName();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        StringBuffer buffer = new StringBuffer();
        buffer.append("(symbolicname=");
        buffer.append(symbolicName);
        buffer.append(")");
        Resource[] discoverResources = this.m_reRepositoryAdmin.discoverResources(buffer.toString());
        if (discoverResources == null || discoverResources.length == 0) {
            throw new IOException("No resource found for filter [" + buffer.toString() + "]");
        }
        ResourceSelectionStrategy strategy = this.getStrategy(this.m_updateStrategy);
        Resource selected = strategy.selectOne(Version.parseVersion((String)version), discoverResources);
        return new URL(selected.getURI());
    }

    private ResourceSelectionStrategy getStrategy(String strategy) {
        this.m_logger.log(4, "Using ResourceSelectionStrategy: " + strategy);
        if ("same".equals(strategy)) {
            return new SameSelectionStrategy(this.m_logger);
        }
        if ("newest".equals(strategy)) {
            return new NewestSelectionStrategy(this.m_logger);
        }
        throw new RuntimeException("Could not determine obr update strategy : " + strategy);
    }

    static class NewestSelectionStrategy
    extends ResourceSelectionStrategy {
        NewestSelectionStrategy(Logger logger) {
            super(logger);
        }

        Version determineVersion(Version currentVersion, SortedMap sortedResources) {
            return (Version)sortedResources.lastKey();
        }
    }

    private static abstract class ResourceSelectionStrategy {
        private final Logger m_logger;

        ResourceSelectionStrategy(Logger logger) {
            this.m_logger = logger;
        }

        Logger getLogger() {
            return this.m_logger;
        }

        final Resource selectOne(Version currentVersion, Resource[] resources) {
            TreeMap<Version, Resource> sortedResources = new TreeMap<Version, Resource>();
            for (int i = 0; i < resources.length; ++i) {
                sortedResources.put(resources[i].getVersion(), resources[i]);
            }
            Version versionToUse = this.determineVersion(currentVersion, sortedResources);
            this.m_logger.log(4, "Using Version " + versionToUse + " for bundle " + resources[0].getSymbolicName());
            return (Resource)sortedResources.get(versionToUse);
        }

        abstract Version determineVersion(Version var1, SortedMap var2);
    }

    static class SameSelectionStrategy
    extends ResourceSelectionStrategy {
        SameSelectionStrategy(Logger logger) {
            super(logger);
        }

        Version determineVersion(Version currentVersion, SortedMap sortedResources) {
            return currentVersion;
        }
    }
}

