/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class FatalOutOfMemoryErrorDialog
extends TitleAreaDialog {
    private LocalResourceManager fResources;
    private final IStatus fErrorStatus;

    public FatalOutOfMemoryErrorDialog(IStatus errorStatus) {
        super(null);
        this.fErrorStatus = errorStatus;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.StartupErrorDialog_RSSOWL_CRASH_REPORTER);
        Image img_16x16 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/16x16.png");
        Image img_32x32 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/32x32.png");
        Image img_48x48 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/48x48.png");
        Image img_64x64 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/64x64.png");
        Image img_128x128 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/128x128.png");
        newShell.setImages(new Image[]{img_16x16, img_32x32, img_48x48, img_64x64, img_128x128});
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10, 15, 5, false));
        composite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.StartupErrorDialog_WE_SORRY);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/welcome_wiz.gif"));
        this.setMessage(Messages.FatalOutOfMemoryErrorDialog_RSSOWL_CRASHED_OOM, 2);
        Link recoveryMessageLabel = new Link(composite, 64);
        recoveryMessageLabel.setText(Messages.FatalOutOfMemoryErrorDialog_CRASH_ADVISE_OOM);
        recoveryMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        recoveryMessageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if ("faq".equals(e.text)) {
                        BrowserUtils.openFAQ(FatalOutOfMemoryErrorDialog.this.fErrorStatus);
                    } else if ("forum".equals(e.text)) {
                        BrowserUtils.openHelpForum(FatalOutOfMemoryErrorDialog.this.fErrorStatus);
                    }
                }
                catch (Throwable t) {
                    FatalOutOfMemoryErrorDialog.this.setMessage(t.getMessage(), 3);
                }
            }
        });
        Link dialogMessageLabel = new Link(composite, 64);
        dialogMessageLabel.setText(Messages.FatalOutOfMemoryErrorDialog_CRASH_DIAGNOSE_OOM);
        dialogMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        dialogMessageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if ("save".equals(e.text)) {
                        OwlUI.saveCrashReport(FatalOutOfMemoryErrorDialog.this.getShell());
                    } else {
                        BrowserUtils.sendErrorLog();
                    }
                }
                catch (Throwable t) {
                    FatalOutOfMemoryErrorDialog.this.setMessage(t.getMessage(), 3);
                }
            }
        });
        Label reasonLabel = new Label(composite, 0);
        reasonLabel.setText(Messages.StartupErrorDialog_ERROR_DETAILS);
        reasonLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        reasonLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Label errorDetailsLabel = new Label(composite, 64);
        if (StringUtils.isSet((String)this.fErrorStatus.getMessage())) {
            errorDetailsLabel.setText(NLS.bind((String)Messages.FatalOutOfMemoryErrorDialog_OOM_ERROR_N, (Object)this.fErrorStatus.getMessage()));
        } else {
            errorDetailsLabel.setText(Messages.FatalOutOfMemoryErrorDialog_OOM_ERROR);
        }
        errorDetailsLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite sepHolder = new Composite(parent, 0);
        sepHolder.setLayoutData((Object)new GridData(4, 1, true, false));
        sepHolder.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        Label separator = new Label(sepHolder, 258);
        separator.setLayoutData((Object)new GridData(768));
        FatalOutOfMemoryErrorDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 17, Messages.StartupErrorDialog_HELP, true);
        this.getButton(17).setFocus();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point location = this.getInitialLocation(bestSize);
        this.getShell().setBounds(location.x, location.y, bestSize.x, bestSize.y);
    }
}

