/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.GuiDownloads;
import mediathek.gui.dialog.DialogProgrammOrdnerOeffnen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;

public class OpenPlayerAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filmAbspielen(Frame parent, String datei) {
        boolean gut = false;
        if (datei.isEmpty()) {
            return;
        }
        File sFile = new File(datei);
        if (!sFile.exists()) {
            MVMessageDialog.showMessageDialog(parent, "Film existiert noch nicht!", "Fehler", 0);
            return;
        }
        try {
            Desktop d;
            if (!Daten.mVConfig.get("Player-zum-Abspielen").isEmpty()) {
                String programm = Daten.mVConfig.get("Player-zum-Abspielen");
                String[] cmd = new String[]{programm, sFile.getAbsolutePath()};
                Runtime.getRuntime().exec(cmd);
                gut = true;
            } else if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                d.open(sFile);
                gut = true;
            }
        }
        catch (Exception ex) {
            try {
                gut = false;
                String programm = "";
                String text = "\n Ein Videoplayer zum Abspielen wird nicht gefunden.\n Videoplayer selbst ausw\u00e4hlen.";
                DialogProgrammOrdnerOeffnen dialog = new DialogProgrammOrdnerOeffnen(parent, true, "", "Videoplayer suchen", text);
                dialog.setVisible(true);
                if (dialog.ok) {
                    programm = dialog.ziel;
                }
                Runtime.getRuntime().exec(programm + " " + sFile.getAbsolutePath());
                Daten.mVConfig.add("Player-zum-Abspielen", programm);
                ListenerMediathekView.notify(19, GuiDownloads.class.getSimpleName());
                gut = true;
            }
            catch (Exception eex) {
                Log.fehlerMeldung(959632369, ex, "Ordner \u00f6ffnen: " + datei);
            }
        }
        finally {
            if (!gut) {
                Daten.mVConfig.add("Player-zum-Abspielen", "");
                ListenerMediathekView.notify(19, GuiDownloads.class.getSimpleName());
                MVMessageDialog.showMessageDialog(parent, "Kann den Videoplayer nicht \u00f6ffnen!", "Fehler", 0);
            }
        }
    }
}

