/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import mediathek.controller.MVUsedUrl;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogZiel;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MVRun;
import mediathek.tool.TModel;
import msearch.daten.DatenFilm;

public class PanelErledigteUrls
extends PanelVorlage {
    private boolean abo;
    private JButton jButtonExport;
    private JButton jButtonLoeschen;
    private JLabel jLabelSum;
    private JTable jTable1;
    private JToggleButton jToggleButtonLaden;

    public PanelErledigteUrls(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.jTable1.addMouseListener(new BeobMausTabelle());
        this.jButtonLoeschen.setEnabled(false);
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelErledigteUrls.this.export();
            }
        });
    }

    public void initAbo() {
        this.abo = true;
        ListenerMediathekView.addListener(new ListenerMediathekView(11, PanelErledigteUrls.class.getSimpleName()){

            @Override
            public void ping() {
                if (PanelErledigteUrls.this.jToggleButtonLaden.isSelected()) {
                    PanelErledigteUrls.this.jTable1.setModel(new TModel(PanelErledigteUrls.this.daten.erledigteAbos.getObjectData(), MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                }
            }
        });
        this.jButtonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelErledigteUrls.this.daten.erledigteAbos.alleLoeschen();
            }
        });
        this.jToggleButtonLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelErledigteUrls.this.jToggleButtonLaden.isSelected()) {
                    PanelErledigteUrls.this.jButtonLoeschen.setEnabled(true);
                    PanelErledigteUrls.this.jTable1.setModel(new TModel(PanelErledigteUrls.this.daten.erledigteAbos.getObjectData(), MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                } else {
                    PanelErledigteUrls.this.jButtonLoeschen.setEnabled(false);
                    PanelErledigteUrls.this.jTable1.setModel(new TModel((Object[][])null, MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                }
            }
        });
    }

    public void initHistory() {
        this.abo = false;
        ListenerMediathekView.addListener(new ListenerMediathekView(2, PanelErledigteUrls.class.getSimpleName()){

            @Override
            public void ping() {
                if (PanelErledigteUrls.this.jToggleButtonLaden.isSelected()) {
                    PanelErledigteUrls.this.jTable1.setModel(new TModel(PanelErledigteUrls.this.daten.history.getObjectData(), MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                }
            }
        });
        this.jButtonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelErledigteUrls.this.daten.history.alleLoeschen();
            }
        });
        this.jToggleButtonLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelErledigteUrls.this.jToggleButtonLaden.isSelected()) {
                    PanelErledigteUrls.this.jButtonLoeschen.setEnabled(true);
                    PanelErledigteUrls.this.jTable1.setModel(new TModel(PanelErledigteUrls.this.daten.history.getObjectData(), MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                } else {
                    PanelErledigteUrls.this.jButtonLoeschen.setEnabled(false);
                    PanelErledigteUrls.this.jTable1.setModel(new TModel((Object[][])null, MVUsedUrl.title));
                    PanelErledigteUrls.this.setsum();
                }
            }
        });
    }

    private void setsum() {
        if (this.jTable1.getRowCount() <= 0) {
            this.jLabelSum.setText("");
        } else {
            this.jLabelSum.setText("Anzahl: " + this.jTable1.getRowCount());
        }
    }

    private void export() {
        if (this.jTable1.getModel().getRowCount() <= 0) {
            return;
        }
        DialogZiel dialog = new DialogZiel(this.parentComponent, true, GuiFunktionen.getHomePath() + File.separator + "Mediathek-Filme.txt", "Filmtitel speichern");
        dialog.setVisible(true);
        if (!dialog.ok) {
            return;
        }
        MVRun mVRun = new MVRun(this.daten.mediathekGui, "Datei: \"" + dialog.ziel + "\" erstellen");
        mVRun.setVisible(true);
        new Thread(new Export_(dialog.ziel, mVRun)).start();
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonLoeschen = new JButton();
        this.jToggleButtonLaden = new JToggleButton();
        this.jButtonExport = new JButton();
        this.jLabelSum = new JLabel();
        this.jTable1.setModel(new TModel());
        jScrollPane1.setViewportView(this.jTable1);
        this.jButtonLoeschen.setText("Liste l\u00f6schen");
        this.jToggleButtonLaden.setText("Laden");
        this.jButtonExport.setText("Liste exportieren");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 554, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jToggleButtonLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoeschen))).addContainerGap()));
        layout.linkSize(0, this.jButtonLoeschen, this.jToggleButtonLaden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -1, 283, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jToggleButtonLaden).addComponent(this.jLabelSum).addComponent(this.jButtonExport).addComponent(this.jButtonLoeschen)).addContainerGap()));
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        BeobLoeschen beobLoeschen = new BeobLoeschen();
        BeobUrl beobUrl = new BeobUrl();
        private Point p;
        DatenFilm film = null;

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = PanelErledigteUrls.this.jTable1.rowAtPoint(this.p);
            if (nr >= 0) {
                PanelErledigteUrls.this.jTable1.setRowSelectionInterval(nr, nr);
                String url = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(nr), 3).toString();
                this.film = Daten.listeFilme.getFilmByUrl(url);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Url aus der Liste l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            jPopupMenu.add(item);
            item = new JMenuItem("URL kopieren");
            item.addActionListener(this.beobUrl);
            jPopupMenu.add(item);
            item = new JMenuItem("Infos zum Film anzeigen");
            item.addActionListener(new BeobInfo());
            jPopupMenu.add(item);
            if (this.film == null) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Download noch einmal anlegen");
            item.addActionListener(new BeobDownload());
            jPopupMenu.add(item);
            if (this.film == null) {
                item.setEnabled(false);
            }
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobLoeschen
        implements ActionListener {
            private BeobLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow >= 0) {
                    String del = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    if (PanelErledigteUrls.this.abo) {
                        PanelErledigteUrls.this.daten.erledigteAbos.urlAusLogfileLoeschen(del);
                    } else {
                        PanelErledigteUrls.this.daten.history.urlAusLogfileLoeschen(del);
                    }
                }
            }
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow >= 0) {
                    String del = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    if (PanelErledigteUrls.this.abo) {
                        GuiFunktionen.copyToClipboard(del);
                    } else {
                        GuiFunktionen.copyToClipboard(del);
                    }
                }
            }
        }

        private class BeobInfo
        implements ActionListener {
            private BeobInfo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MVFilmInfo filmInfoHud = PanelErledigteUrls.this.daten.filmInfo;
                filmInfoHud.updateCurrentFilm(BeobMausTabelle.this.film);
                filmInfoHud.showInfo();
            }
        }

        private class BeobDownload
        implements ActionListener {
            private BeobDownload() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret;
                DatenDownload datenDownload = Daten.listeDownloads.getDownloadUrlFilm(BeobMausTabelle.this.film.arr[12]);
                if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(PanelErledigteUrls.this.parentComponent, "Download f\u00fcr den Film existiert bereits.\nNoch einmal anlegen?", "Anlegen?", 0)) != 0) {
                    return;
                }
                DialogAddDownload dialog = new DialogAddDownload(PanelErledigteUrls.this.daten.mediathekGui, PanelErledigteUrls.this.daten, BeobMausTabelle.this.film, null, "");
                dialog.setVisible(true);
            }
        }
    }

    private class Export_
    implements Runnable {
        String ziel;
        MVRun mVRun;

        public Export_(String ziel, MVRun mVRun) {
            this.ziel = ziel;
            this.mVRun = mVRun;
        }

        @Override
        public synchronized void run() {
            this.exportListe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportListe() {
            LinkedList<MVUsedUrl> liste = PanelErledigteUrls.this.abo ? PanelErledigteUrls.this.daten.erledigteAbos.getSortList() : PanelErledigteUrls.this.daten.history.getSortList();
            Path logFilePath = Paths.get(this.ziel, new String[0]);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(logFilePath, new OpenOption[0])));){
                bw.newLine();
                bw.write(MVUsedUrl.getHeaderString());
                bw.newLine();
                bw.newLine();
                for (MVUsedUrl entry : liste) {
                    bw.write(entry.getString());
                    bw.newLine();
                }
                bw.newLine();
                bw.flush();
                bw.close();
            }
            catch (Exception ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MVMessageDialog.showMessageDialog(null, "Datei konnte nicht geschrieben werden!", "Fehler beim Schreiben", 0);
                    }
                });
            }
            finally {
                this.mVRun.dispose();
            }
        }
    }
}

