/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import mediathek.controller.Log;
import mediathek.controller.MVUsedUrl;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFilmSize;
import msearch.daten.DatenFilm;
import msearch.tool.Datum;

public class DatenDownload
implements Comparable<DatenDownload> {
    public static final byte QUELLE_ALLE = -1;
    public static final byte QUELLE_BUTTON = 1;
    public static final byte QUELLE_DOWNLOAD = 2;
    public static final byte QUELLE_ABO = 3;
    public static final String QUELLE_ALLE_TXT = "Alle";
    public static final String QUELLE_BUTTON_TXT = "Button";
    public static final String QUELLE_DOWNLOAD_TXT = "Download";
    public static final String QUELLE_ABO_TXT = "Abo";
    public static final byte ART_DOWNLOAD = 1;
    public static final byte ART_PROGRAMM = 2;
    public static final String ART_DOWNLOAD_TXT = "direkter Download";
    public static final String ART_PROGRAMM_TXT = "Programm";
    public static final String TRENNER_PROG_ARRAY = "<>";
    private static GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
    private static SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");
    public static final String DOWNLOAD_NR = "Nr";
    public static final int DOWNLOAD_NR_NR = 0;
    public static final String DOWNLOAD_FILM_NR = "Filmnr";
    public static final int DOWNLOAD_FILM_NR_NR = 1;
    public static final String DOWNLOAD_ABO = "Abo";
    public static final int DOWNLOAD_ABO_NR = 2;
    public static final String DOWNLOAD_SENDER = "Sender";
    public static final int DOWNLOAD_SENDER_NR = 3;
    public static final String DOWNLOAD_THEMA = "Thema";
    public static final int DOWNLOAD_THEMA_NR = 4;
    public static final String DOWNLOAD_TITEL = "Titel";
    public static final int DOWNLOAD_TITEL_NR = 5;
    public static final String DOWNLOAD_BUTTON_START = "";
    public static final int DOWNLOAD_BUTTON_START_NR = 6;
    public static final String DOWNLOAD_BUTTON_DEL = "";
    public static final int DOWNLOAD_BUTTON_DEL_NR = 7;
    public static final String DOWNLOAD_PROGRESS = "Fortschritt";
    public static final int DOWNLOAD_PROGRESS_NR = 8;
    public static final String DOWNLOAD_RESTZEIT = "Restzeit";
    public static final int DOWNLOAD_RESTZEIT_NR = 9;
    public static final String DOWNLOAD_BANDBREITE = "Geschwindigkeit";
    public static final int DOWNLOAD_BANDBREITE_NR = 10;
    public static final String DOWNLOAD_GROESSE = "Gr\u00f6\u00dfe [MB]";
    public static final int DOWNLOAD_GROESSE_NR = 11;
    public static final String DOWNLOAD_DATUM = "Datum";
    public static final int DOWNLOAD_DATUM_NR = 12;
    public static final String DOWNLOAD_ZEIT = "Zeit";
    public static final int DOWNLOAD_ZEIT_NR = 13;
    public static final String DOWNLOAD_DAUER = "Dauer";
    public static final int DOWNLOAD_DAUER_NR = 14;
    public static final String DOWNLOAD_UNTERBROCHEN = "Pause";
    public static final int DOWNLOAD_UNTERBROCHEN_NR = 15;
    public static final String DOWNLOAD_GEO = "Geo";
    public static final int DOWNLOAD_GEO_NR = 16;
    public static final String DOWNLOAD_FILM_URL = "Film-URL";
    public static final int DOWNLOAD_FILM_URL_NR = 17;
    public static final String DOWNLOAD_HISTORY_URL = "History-URL";
    public static final int DOWNLOAD_HISTORY_URL_NR = 18;
    public static final String DOWNLOAD_URL = "URL";
    public static final int DOWNLOAD_URL_NR = 19;
    public static final String DOWNLOAD_URL_RTMP = "URL-rtmp";
    public static final int DOWNLOAD_URL_RTMP_NR = 20;
    public static final String DOWNLOAD_URL_SUBTITLE = "URL-Untertitel";
    public static final int DOWNLOAD_URL_SUBTITLE_NR = 21;
    public static final String DOWNLOAD_PROGRAMMSET = "Programmset";
    public static final int DOWNLOAD_PROGRAMMSET_NR = 22;
    public static final String DOWNLOAD_PROGRAMM = "Programm";
    public static final int DOWNLOAD_PROGRAMM_NR = 23;
    public static final String DOWNLOAD_PROGRAMM_AUFRUF = "Programmaufruf_";
    public static final int DOWNLOAD_PROGRAMM_AUFRUF_NR = 24;
    public static final String DOWNLOAD_PROGRAMM_AUFRUF_ARRAY = "Programmaufruf";
    public static final int DOWNLOAD_PROGRAMM_AUFRUF_ARRAY_NR = 25;
    public static final String DOWNLOAD_PROGRAMM_RESTART = "Restart";
    public static final int DOWNLOAD_PROGRAMM_RESTART_NR = 26;
    public static final String DOWNLOAD_ZIEL_DATEINAME = "Dateiname";
    public static final int DOWNLOAD_ZIEL_DATEINAME_NR = 27;
    public static final String DOWNLOAD_ZIEL_PFAD = "Pfad";
    public static final int DOWNLOAD_ZIEL_PFAD_NR = 28;
    public static final String DOWNLOAD_ZIEL_PFAD_DATEINAME = "Pfad-Dateiname";
    public static final int DOWNLOAD_ZIEL_PFAD_DATEINAME_NR = 29;
    public static final String DOWNLOAD_ART = "Art";
    public static final int DOWNLOAD_ART_NR = 30;
    public static final String DOWNLOAD_QUELLE = "Quelle";
    public static final int DOWNLOAD_QUELLE_NR = 31;
    public static final String DOWNLOAD_ZURUECKGESTELLT = "Zurueckgestellt";
    public static final int DOWNLOAD_ZURUECKGESTELLT_NR = 32;
    public static final String DOWNLOAD_INFODATEI = "Infodatei";
    public static final int DOWNLOAD_INFODATEI_NR = 33;
    public static final String DOWNLOAD_SPOTLIGHT = "Spotlight";
    public static final int DOWNLOAD_SPOTLIGHT_NR = 34;
    public static final String DOWNLOAD_SUBTITLE = "Untertitel";
    public static final int DOWNLOAD_SUBTITLE_NR = 35;
    public static final String DOWNLOAD_PROGRAMM_DOWNLOADMANAGER = "Remote-Download";
    public static final int DOWNLOAD_PROGRAMM_DOWNLOADMANAGER_NR = 36;
    public static final String DOWNLOAD_REF = "Ref";
    public static final int DOWNLOAD_REF_NR = 37;
    public static final String DOWNLOAD = "Downlad";
    public static final int MAX_ELEM = 38;
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "Filmnr", "Abo", "Sender", "Thema", "Titel", "", "", "Fortschritt", "Restzeit", "Geschwindigkeit", "Gr\u00f6\u00dfe [MB]", "Datum", "Zeit", "Dauer", "Pause", "Geo", "Film-URL", "History-URL", "URL", "URL-rtmp", "URL-Untertitel", "Programmset", "Programm", "Programmaufruf_", "Programmaufruf", "Restart", "Dateiname", "Pfad", "Pfad-Dateiname", "Art", "Quelle", "Zurueckgestellt", "Infodatei", "Spotlight", "Untertitel", "Remote-Download", "Ref"};
    public static final String[] COLUMN_NAMES_ = new String[]{"Nr", "Filmnr", "Abo", "Sender", "Thema", "Titel", "Button-Start", "Button-Del", "Fortschritt", "Restzeit", "Geschwindigkeit", "Groesse", "Datum", "Zeit", "Dauer", "Pause", "Geo", "Film-URL", "History-URL", "URL", "URL-rtmp", "URL-Untertitel", "Programmset", "Programm", "Programmaufruf_", "Programmaufruf", "Restart", "Dateiname", "Pfad", "Pfad-Dateiname", "Art", "Quelle", "Zurueckgestellt", "Infodatei", "Spotlight", "Untertitel", "Remote-Download", "Ref"};
    public static boolean[] spaltenAnzeigen = new boolean[38];
    public String[] arr;
    public Datum datumFilm = new Datum(0L);
    public DatenFilm film = null;
    public MVFilmSize mVFilmSize = new MVFilmSize();
    public Start start = null;
    public DatenPset pSet = null;
    public DatenAbo abo = null;
    public int nr = 0;
    public byte quelle = (byte)-1;
    public byte art = 1;

    public DatenDownload() {
        this.makeArr();
    }

    public DatenDownload(DatenPset pSet, DatenFilm film, byte quelle, DatenAbo abo, String name, String pfad, String aufloesung) {
        this.makeArr();
        this.film = film;
        this.pSet = pSet;
        this.abo = abo;
        this.arr[1] = film.arr[0];
        this.arr[3] = film.arr[1];
        this.arr[4] = film.arr[2];
        this.arr[5] = film.arr[3];
        this.arr[17] = film.arr[12];
        this.arr[21] = film.arr[15];
        this.arr[12] = film.arr[6];
        this.arr[13] = film.arr[7];
        this.arr[20] = film.arr[16];
        this.arr[14] = film.arr[8];
        this.arr[31] = String.valueOf(quelle);
        this.arr[18] = film.getUrlHistory();
        if (aufloesung.isEmpty()) {
            this.arr[19] = film.getUrlFuerAufloesung(pSet.arr[15]);
            this.arr[20] = film.getUrlRtmpFuerAufloesung(pSet.arr[15]);
        } else {
            this.arr[19] = film.getUrlFuerAufloesung(aufloesung);
            this.arr[20] = film.getUrlRtmpFuerAufloesung(aufloesung);
        }
        this.arr[33] = pSet.arr[19];
        this.arr[35] = pSet.arr[21];
        this.arr[34] = pSet.arr[20];
        this.arr[16] = film.arr[11];
        if (film.arr[12].equals(this.arr[19])) {
            this.mVFilmSize.setSize(film.arr[9]);
        } else {
            this.mVFilmSize.setSize("");
        }
        this.aufrufBauen(pSet, film, abo, name, pfad);
        this.init();
    }

    public void setGroesse(String groesse) {
        if (!groesse.isEmpty()) {
            this.mVFilmSize.setSize(groesse);
        } else {
            this.mVFilmSize.setSize(this.film.getDateigroesse(this.arr[19]));
        }
    }

    public static boolean anzeigen(int i) {
        if (spaltenAnzeigen == null) {
            return true;
        }
        return spaltenAnzeigen[i];
    }

    public final void init() {
        this.datumFilm = this.getDatumForObject();
        try {
            this.art = Byte.parseByte(this.arr[30]);
            this.quelle = Byte.parseByte(this.arr[31]);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(649632580, ex, "Art: " + this.arr[30] + " Quelle: " + this.arr[31]);
            this.art = (byte)2;
            this.quelle = 1;
        }
    }

    public boolean istZurueckgestellt() {
        return this.arr[32].equals(Boolean.TRUE.toString());
    }

    public void zurueckstellen() {
        if (this.start != null && this.start.status > 1) {
            return;
        }
        this.arr[32] = Boolean.TRUE.toString();
        this.resetDownload();
    }

    public boolean isInterrupted() {
        return !this.isFinished() && this.arr[15].equals(Boolean.TRUE.toString());
    }

    public void interrupt() {
        this.arr[15] = Boolean.TRUE.toString();
    }

    public void interruptRestart() {
        this.arr[15] = Boolean.FALSE.toString();
        ListenerMediathekView.notify(33, DatenDownload.class.getName());
    }

    public boolean isFinished() {
        return this.start != null && this.start.status == 3;
    }

    public void resetDownload() {
        this.mVFilmSize.reset();
        this.start = null;
    }

    public void startDownload(Daten ddaten) {
        this.start = new Start();
        if (this.film != null) {
            Daten.listeFilmeHistory.add((Object)this.film);
        }
        ddaten.history.zeileSchreiben(this.arr[4], this.arr[5], this.arr[18]);
        ListenerMediathekView.notify(14, this.getClass().getSimpleName());
    }

    public static void startenDownloads(Daten ddaten, ArrayList<DatenDownload> downloads) {
        String zeit = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
        LinkedList<MVUsedUrl> urlList = new LinkedList<MVUsedUrl>();
        for (DatenDownload d : downloads) {
            d.start = new Start();
            urlList.add(new MVUsedUrl(zeit, d.arr[4], d.arr[5], d.arr[18]));
        }
        if (!urlList.isEmpty()) {
            ddaten.history.zeilenSchreiben(urlList);
        }
        ListenerMediathekView.notify(14, DatenDownload.class.getSimpleName());
    }

    public DatenDownload getCopy() {
        DatenDownload ret = new DatenDownload();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.datumFilm = this.datumFilm;
        ret.film = this.film;
        ret.mVFilmSize = this.mVFilmSize;
        ret.start = this.start;
        ret.pSet = this.pSet;
        ret.abo = this.abo;
        ret.nr = this.nr;
        ret.quelle = this.quelle;
        ret.art = this.art;
        return ret;
    }

    public void aufMichKopieren(DatenDownload datenDownload) {
        System.arraycopy(datenDownload.arr, 0, this.arr, 0, this.arr.length);
        this.datumFilm = datenDownload.datumFilm;
        this.film = datenDownload.film;
        this.mVFilmSize = datenDownload.mVFilmSize;
        this.start = datenDownload.start;
        this.pSet = datenDownload.pSet;
        this.abo = datenDownload.abo;
        this.nr = datenDownload.nr;
        this.quelle = datenDownload.quelle;
        this.art = datenDownload.art;
    }

    public boolean istAbo() {
        return !this.arr[2].isEmpty();
    }

    public boolean isRestart() {
        if (this.arr[26].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[26]);
    }

    public boolean isDownloadManager() {
        if (this.arr[36].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[36]);
    }

    public boolean isInfoFile() {
        if (this.arr[33].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[33]);
    }

    public boolean isSubtitle() {
        if (this.arr[35].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[35]);
    }

    public boolean isSpotlight() {
        if (this.arr[34].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[34]);
    }

    public String getTextRestzeit() {
        if (this.start != null && this.start.status < 3 && this.start.status >= 2 && this.start.restSekunden > 0L) {
            if (this.start.restSekunden > 300L) {
                return Long.toString(Math.round((double)this.start.restSekunden / 60.0)) + " Min.";
            }
            if (this.start.restSekunden > 230L) {
                return "5 Min.";
            }
            if (this.start.restSekunden > 170L) {
                return "4 Min.";
            }
            if (this.start.restSekunden > 110L) {
                return "3 Min.";
            }
            if (this.start.restSekunden > 60L) {
                return "2 Min.";
            }
            if (this.start.restSekunden > 30L) {
                return "1 Min.";
            }
            if (this.start.restSekunden > 20L) {
                return "30 s";
            }
            if (this.start.restSekunden > 10L) {
                return "20 s";
            }
            return "10 s";
        }
        return "";
    }

    public String getTextBandbreite() {
        if (this.start != null && this.start.status < 3 && this.start.status >= 2) {
            if (this.start.bandbreite > 1000000L) {
                String s = String.valueOf(this.start.bandbreite / 1000L);
                if (s.length() >= 4) {
                    s = s.substring(0, s.length() - 3) + "," + s.substring(s.length() - 3);
                }
                return s + " MB/s";
            }
            if (this.start.bandbreite > 1000L) {
                return this.start.bandbreite / 1000L + " kB/s";
            }
            if (this.start.bandbreite > 1L) {
                return this.start.bandbreite + " B/s";
            }
            return "";
        }
        return "";
    }

    public boolean checkAufrufBauen() {
        return this.pSet != null && this.film != null;
    }

    public void aufrufBauen() {
        this.aufrufBauen(this.pSet, this.film, this.abo, this.arr[27], this.arr[28]);
    }

    private void aufrufBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        try {
            DatenProg programm = pSet.getProgUrl(this.arr[19]);
            pSet.arr[5] = pSet.arr[5].replace("%n", "");
            pSet.arr[5] = pSet.arr[5].replace("%p", "");
            pSet.arr[4] = pSet.arr[4].replace("%n", "");
            pSet.arr[4] = pSet.arr[4].replace("%p", "");
            for (DatenProg prog : pSet.getListeProg()) {
                prog.arr[1] = prog.arr[1].replace("%n", "");
                prog.arr[1] = prog.arr[1].replace("%p", "");
            }
            this.arr[22] = pSet.arr[0];
            this.art = (byte)(pSet.checkDownloadDirekt(this.arr[19]) && pSet.progsContainPath() ? 1 : 2);
            this.arr[30] = String.valueOf(this.art);
            this.arr[23] = this.art == 1 ? ART_DOWNLOAD_TXT : programm.arr[0];
            this.arr[26] = String.valueOf(programm.isRestart());
            this.arr[36] = String.valueOf(programm.isDownloadManager());
            this.dateinamePfadBauen(pSet, film, abo, nname, ppfad);
            this.programmaufrufBauen(programm);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(825600145, ex);
        }
    }

    private void programmaufrufBauen(DatenProg programm) {
        if (this.art == 1) {
            this.arr[24] = "";
            this.arr[25] = "";
        } else {
            String befehlsString = programm.getProgrammAufruf();
            this.arr[24] = befehlsString = this.replaceExec(befehlsString);
            String progArray = programm.getProgrammAufrufArray();
            this.arr[25] = progArray = this.replaceExec(progArray);
        }
    }

    private String replaceExec(String befehlsString) {
        befehlsString = befehlsString.replace("**", this.arr[29]);
        befehlsString = befehlsString.replace("%f", this.arr[19]);
        befehlsString = befehlsString.replace("%F", this.arr[20]);
        befehlsString = befehlsString.replace("%a", this.arr[28]);
        befehlsString = befehlsString.replace("%b", this.arr[27]);
        return befehlsString;
    }

    private void dateinamePfadBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        String path;
        String name;
        if (!pSet.progsContainPath()) {
            this.arr[27] = "";
            this.arr[28] = "";
            return;
        }
        if (!nname.equals("")) {
            name = nname;
        } else {
            this.arr[27] = pSet.getZielDateiname(this.arr[19]);
            name = this.arr[27];
            if (name.equals("")) {
                name = this.getHeute_yyyyMMdd() + "_" + this.arr[4] + "-" + this.arr[5] + ".mp4";
            }
            name = this.replaceString(name, film);
            String suff = "";
            if (name.contains(".")) {
                suff = name.substring(name.lastIndexOf("."));
                if (suff.length() <= 4 && suff.length() > 1) {
                    name = name.substring(0, name.lastIndexOf("."));
                } else {
                    suff = "";
                }
            }
            name = FilenameUtils.replaceLeerDateiname(name, false);
            if ((name = name + suff).length() > 8) {
                String suf1 = name.substring(name.length() - 8, name.length() - 4);
                String suf2 = name.substring(name.length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = name.substring(0, name.length() - 4);
                }
            }
            if (Boolean.parseBoolean(pSet.arr[11])) {
                int laenge = 25;
                if (!pSet.arr[13].equals("")) {
                    laenge = Integer.parseInt(pSet.arr[13]);
                }
                name = GuiFunktionen.cutName(name, laenge);
            }
        }
        if (!ppfad.equals("")) {
            path = ppfad;
        } else {
            this.arr[28] = pSet.getZielPfad();
            path = this.arr[28];
            if (path.equals("")) {
                path = GuiFunktionen.getStandardDownloadPath();
            }
            if (abo != null) {
                this.arr[2] = abo.arr[2];
                if (Boolean.parseBoolean(pSet.arr[6])) {
                    path = GuiFunktionen.addsPfad(path, abo.arr[9]);
                }
            } else if (Boolean.parseBoolean(pSet.arr[6])) {
                path = GuiFunktionen.addsPfad(path, FilenameUtils.replaceLeerDateiname(this.arr[4], true));
            }
            path = this.replaceString(path, film);
            path = FilenameUtils.replaceLeerDateiname(path, true);
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.equals("")) {
            path = GuiFunktionen.getStandardDownloadPath();
        }
        if (name.equals("")) {
            name = this.getHeute_yyyyMMdd() + "_" + this.arr[4] + "-" + this.arr[5] + ".mp4";
        }
        String[] pathName = new String[]{path, name};
        GuiFunktionen.checkLengthPath(pathName);
        this.arr[27] = pathName[1];
        this.arr[28] = pathName[0];
        this.arr[29] = GuiFunktionen.addsPfad(pathName[0], pathName[1]);
    }

    private String replaceString(String s, DatenFilm film) {
        int laenge = -1;
        if (Boolean.parseBoolean(this.pSet.arr[12])) {
            laenge = 10;
            if (!this.pSet.arr[14].equals("")) {
                laenge = Integer.parseInt(this.pSet.arr[14]);
            }
        }
        String field = this.cleanField(this.getField(film.arr[2], laenge));
        s = s.replace("%t", field);
        field = this.cleanField(this.getField(film.arr[3], laenge));
        s = s.replace("%T", field);
        field = this.cleanField(this.getField(film.arr[1], laenge));
        s = s.replace("%s", field);
        field = this.cleanField(this.getField(GuiFunktionen.getDateiName(this.arr[19]), laenge));
        s = s.replace("%N", field);
        s = s.replace("%D", film.arr[6].equals("") ? this.getHeute_yyyyMMdd() : DatenDownload.datumDatumZeitReinigen(DatenDownload.datumDrehen(film.arr[6])));
        s = s.replace("%d", film.arr[7].equals("") ? this.getJetzt_HHMMSS() : DatenDownload.datumDatumZeitReinigen(film.arr[7]));
        s = s.replace("%H", this.getHeute_yyyyMMdd());
        s = s.replace("%h", this.getJetzt_HHMMSS());
        s = s.replace("%1", DatenDownload.getDMY("%1", film.arr[6].equals("") ? this.getHeute_yyyy_MM_dd() : film.arr[6]));
        s = s.replace("%2", DatenDownload.getDMY("%2", film.arr[6].equals("") ? this.getHeute_yyyy_MM_dd() : film.arr[6]));
        s = s.replace("%3", DatenDownload.getDMY("%3", film.arr[6].equals("") ? this.getHeute_yyyy_MM_dd() : film.arr[6]));
        s = s.replace("%4", DatenDownload.getHMS("%4", film.arr[7].equals("") ? this.getJetzt_HH_MM_SS() : film.arr[7]));
        s = s.replace("%5", DatenDownload.getHMS("%5", film.arr[7].equals("") ? this.getJetzt_HH_MM_SS() : film.arr[7]));
        s = s.replace("%6", DatenDownload.getHMS("%6", film.arr[7].equals("") ? this.getJetzt_HH_MM_SS() : film.arr[7]));
        s = s.replace("%i", String.valueOf(film.nr));
        String res = "";
        if (this.arr[19].equals(film.getUrlFuerAufloesung("normal"))) {
            res = "H";
        } else if (this.arr[19].equals(film.getUrlFuerAufloesung("hd"))) {
            res = "HD";
        } else if (this.arr[19].equals(film.getUrlFuerAufloesung("klein"))) {
            res = "L";
        } else if (this.arr[19].equals(film.getUrlRtmpFuerAufloesung("normal"))) {
            res = "H";
        } else if (this.arr[19].equals(film.getUrlRtmpFuerAufloesung("hd"))) {
            res = "HD";
        } else if (this.arr[19].equals(film.getUrlRtmpFuerAufloesung("klein"))) {
            res = "L";
        }
        s = s.replace("%q", res);
        s = s.replace("%S", GuiFunktionen.getDateiSuffix(this.arr[19]));
        s = s.replace("%Z", GuiFunktionen.getHash(this.arr[19]));
        s = s.replace("%z", GuiFunktionen.getHash(this.arr[19]) + "." + GuiFunktionen.getDateiSuffix(this.arr[19]));
        return s;
    }

    private String cleanField(String name) {
        name = FilenameUtils.replaceLeerDateiname(name, false);
        return name;
    }

    private String getField(String name, int length) {
        if (length < 0) {
            return name;
        }
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private String getJetzt_HHMMSS() {
        return new SimpleDateFormat("HHmmss").format(new Date());
    }

    private String getJetzt_HH_MM_SS() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }

    private String getHeute_yyyyMMdd() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    private String getHeute_yyyy_MM_dd() {
        return new SimpleDateFormat("dd.MM.yyyy").format(new Date());
    }

    private static String getDMY(String s, String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    switch (s) {
                        case "%1": {
                            ret = datum.substring(0, 2);
                            break;
                        }
                        case "%2": {
                            ret = datum.substring(3, 5);
                            break;
                        }
                        case "%3": {
                            ret = datum.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(775421006, ex, datum);
            }
        }
        return ret;
    }

    private static String getHMS(String s, String zeit) {
        String ret = "";
        if (!zeit.equals("")) {
            try {
                if (zeit.length() == 8) {
                    switch (s) {
                        case "%4": {
                            ret = zeit.substring(0, 2);
                            break;
                        }
                        case "%5": {
                            ret = zeit.substring(3, 5);
                            break;
                        }
                        case "%6": {
                            ret = zeit.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(775421006, ex, zeit);
            }
        }
        return ret;
    }

    private static String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6);
                    tmp = tmp + "." + datum.substring(3, 5);
                    ret = tmp = tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(775421006, ex, datum);
            }
        }
        return ret;
    }

    private static String datumDatumZeitReinigen(String datum) {
        String ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    @Override
    public int compareTo(DatenDownload arg0) {
        int ret = sorter.compare(this.arr[3], arg0.arr[3]);
        if (ret == 0) {
            return sorter.compare(this.arr[4], arg0.arr[4]);
        }
        return ret;
    }

    private void makeArr() {
        this.arr = new String[38];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
        this.arr[32] = Boolean.FALSE.toString();
        this.arr[15] = Boolean.FALSE.toString();
    }

    public Datum getDatumForObject() {
        Datum tmp = new Datum(0L);
        if (!this.arr[12].equals("")) {
            try {
                if (!this.arr[13].equals("")) {
                    tmp.setTime(sdf_datum_zeit.parse(this.arr[12] + this.arr[13]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(this.arr[12]).getTime());
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(649897321, ex, new String[]{"Datum: " + this.arr[12], "Zeit: " + this.arr[13]});
            }
        }
        return tmp;
    }
}

