/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogZiel;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVMessageDialog;
import msearch.tool.MSLog;

public class ProgrammLog {
    public static void LogDateiSchreiben(Daten ddaten, JFrame jFrame) {
        DialogZiel dialog = new DialogZiel(jFrame, true, GuiFunktionen.getHomePath() + File.separator + "Mediathek.log", "Logdatei speichern");
        dialog.setVisible(true);
        if (!dialog.ok) {
            return;
        }
        Path logFilePath = Paths.get(dialog.ziel, new String[0]);
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(logFilePath, new OpenOption[0])));){
            String[] java;
            bw.write("#####################################################");
            bw.newLine();
            bw.write("Erstellt: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            bw.write(MVFunctionSys.getProgVersionString());
            bw.newLine();
            bw.write("Compiled: " + MVFunctionSys.getCompileDate());
            bw.newLine();
            bw.write("=====================================================");
            bw.newLine();
            bw.write("Java");
            bw.newLine();
            for (String ja : java = MVFunctionSys.getJavaVersion()) {
                bw.write(ja);
                bw.newLine();
            }
            bw.write("=====================================================");
            bw.newLine();
            bw.write("Betriebssystem: " + System.getProperty("os.name"));
            bw.newLine();
            bw.write("Bs-Version:     " + System.getProperty("os.version"));
            bw.newLine();
            bw.write("Bs-Architektur: " + System.getProperty("os.arch"));
            bw.newLine();
            bw.newLine();
            bw.write("Programmpfad: " + MVFunctionSys.getPathJar());
            bw.newLine();
            bw.write("Verzeichnis Einstellungen: " + Daten.getSettingsDirectory());
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write("## Programmsets ##################################");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            for (int i = 0; i < Daten.listePset.size(); ++i) {
                bw.write(((DatenPset)Daten.listePset.get(i)).toString());
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write("## Systemmeldungen ##################################");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            bw.write(Log.textSystem.toString());
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write("## Programmausgabe ##################################");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            bw.write(Log.textProgramm.toString());
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("#########################################################");
            bw.newLine();
            bw.write("## Fehlermeldungen GUI                                   ");
            bw.newLine();
            ArrayList retList = Log.printFehlerMeldung();
            for (String s : retList) {
                bw.write(s);
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            bw.write("#########################################################");
            bw.newLine();
            bw.write("## Fehlermeldungen lib msearch                           ");
            bw.newLine();
            retList = MSLog.fehlerMeldungen();
            for (String s : retList) {
                bw.write(s);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(319865493, ex);
            MVMessageDialog.showMessageDialog(null, "Datei konnte nicht geschrieben werden!", "Fehler beim Schreiben", 0);
        }
    }
}

