/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import mediathek.daten.Daten;
import mediathek.gui.dialogEinstellungen.PanelMeldungen;
import mediathek.tool.MVFunctionSys;

public class Log {
    public static StringBuffer textSystem = new StringBuffer(10000);
    public static StringBuffer textProgramm = new StringBuffer(10000);
    public static StringBuffer textFehler = new StringBuffer();
    public static boolean playerMeldungenAus = false;
    public static final int LOG_FEHLER = 16;
    public static final int LOG_SYSTEM = 17;
    public static final int LOG_PLAYER = 18;
    private static final int MAX_LAENGE_1 = 50000;
    private static final int MAX_LAENGE_2 = 30000;
    private static int zeilenNrSystem = 0;
    private static int zeilenNrProgramm = 0;
    private static int zeilenNrFehler = 0;
    private static final LinkedList<Integer[]> fehlerListe = new LinkedList();
    private static final boolean progress = false;
    private static final String progressText = "";
    private static final Date startZeit = new Date(System.currentTimeMillis());
    public static PanelMeldungen panelMeldungenFehler = null;
    public static PanelMeldungen panelMeldungenSystem = null;
    public static PanelMeldungen panelMeldungenPlayer = null;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public static synchronized void versionsMeldungen() {
        String[] java;
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("Programmstart: " + sdf.format(startZeit));
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("totalMemory: " + totalMem / 1000000L + " MB");
        Log.systemMeldung("maxMemory: " + maxMem / 1000000L + " MB");
        Log.systemMeldung("freeMemory: " + freeMem / 1000000L + " MB");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung(MVFunctionSys.getProgVersionString());
        Log.systemMeldung("Compiled: " + MVFunctionSys.getCompileDate());
        Log.systemMeldung("###########################################################");
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        Log.systemMeldung("Classname: " + methodCaller.getClassName());
        for (String ja : java = MVFunctionSys.getJavaVersion()) {
            Log.systemMeldung(ja);
        }
        Log.systemMeldung("###########################################################");
    }

    public static synchronized void startMeldungen() {
        Log.versionsMeldungen();
        Log.systemMeldung("Programmpfad: " + MVFunctionSys.getPathJar());
        Log.systemMeldung("Verzeichnis Einstellungen: " + Daten.getSettingsDirectory_String());
        Log.systemMeldung("###########################################################");
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[0]);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex, String text) {
        Log.fehlermeldung_(fehlerNummer, ex, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex, String[] text) {
        Log.fehlermeldung_(fehlerNummer, ex, text);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String text) {
        Log.fehlermeldung_(fehlerNummer, null, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String[] text) {
        Log.fehlermeldung_(fehlerNummer, null, text);
    }

    public static synchronized void systemMeldung(String[] text) {
        Log.systemmeldung(text);
    }

    public static synchronized void systemMeldung(String text) {
        Log.systemmeldung(new String[]{text});
    }

    public static synchronized void playerMeldung(String text) {
        if (!playerMeldungenAus) {
            Log.playermeldung(new String[]{text});
        }
    }

    public static void printEndeMeldung() {
        int minuten;
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        ArrayList<String> ret = Log.printFehlerMeldung();
        for (String s : ret) {
            Log.systemMeldung(s);
        }
        Date stopZeit = new Date(System.currentTimeMillis());
        try {
            minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("   --> Beginn: " + sdf.format(startZeit));
        Log.systemMeldung("   --> Fertig: " + sdf.format(stopZeit));
        Log.systemMeldung("   --> Dauer[Min]: " + (minuten == 0 ? "<1" : Integer.valueOf(minuten)));
        Log.systemMeldung("###########################################################");
        Log.systemMeldung(progressText);
        Log.systemMeldung("   und Tschuess");
        Log.systemMeldung(progressText);
        Log.systemMeldung(progressText);
        Log.systemMeldung("###########################################################");
    }

    public static ArrayList<String> printFehlerMeldung() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(progressText);
        retList.add("###########################################################");
        if (fehlerListe.size() == 0) {
            retList.add(" Keine Fehler :)");
        } else {
            for (int i = 1; i < fehlerListe.size(); ++i) {
                int i_2;
                int i_1;
                for (int k = i; k > 0 && (i_1 = fehlerListe.get(k - 1)[0].intValue()) < (i_2 = fehlerListe.get(k)[0].intValue()); --k) {
                    fehlerListe.add(k - 1, fehlerListe.remove(k));
                }
            }
            for (Integer[] integers : fehlerListe) {
                boolean ex = integers[2] == 1;
                String strEx = ex ? "Ex! " : "    ";
                if (integers[0] < 0) {
                    retList.add(strEx + " Fehlernummer: " + integers[0] + " Anzahl: " + integers[1]);
                    continue;
                }
                retList.add(strEx + " Fehlernummer:  " + integers[0] + " Anzahl: " + integers[1]);
            }
        }
        retList.add("###########################################################");
        retList.add(progressText);
        return retList;
    }

    private static void addFehlerNummer(int nr, boolean exception) {
        int ex;
        Iterator it = fehlerListe.iterator();
        int n = ex = exception ? 1 : 2;
        while (it.hasNext()) {
            Integer[] i = (Integer[])it.next();
            if (i[0] != nr) continue;
            Integer[] integerArray = i;
            Integer n2 = integerArray[1];
            Integer n3 = integerArray[1] = Integer.valueOf(integerArray[1] + 1);
            i[2] = ex;
            return;
        }
        fehlerListe.add(new Integer[]{nr, 1, ex});
    }

    private static void fehlermeldung_(int fehlerNummer, Exception ex, String[] texte) {
        String kl;
        Log.addFehlerNummer(fehlerNummer, ex != null);
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (kl.contains(".") && !Character.isUpperCase(kl.charAt(0))) {
                kl = kl.substring(kl.indexOf(".") + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        if (ex != null || Daten.debug) {
            try {
                String s = Log.getStackTrace(ex);
                System.out.println(s);
            }
            catch (Exception s) {
                // empty catch block
            }
            String FEHLER = "Fehler(MediathekView): ";
            String x = ex != null ? "!" : "=";
            String z = "*";
            System.out.println(x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x);
            System.out.println(z + " Fehlernr: " + fehlerNummer);
            if (ex != null) {
                System.out.println(z + " Exception: " + ex.getMessage());
            }
            System.out.println(z + " " + "Fehler(MediathekView): " + kl);
            Log.notifyPanelMeldung(16, "Fehler(MediathekView): " + kl);
            for (String text : texte) {
                System.out.println(z + "           " + text);
                Log.notifyPanelMeldung(16, text);
            }
            System.out.println(progressText);
        }
    }

    private static void systemmeldung(String[] texte) {
        String z = ". ";
        if (texte.length <= 1) {
            System.out.println(".  " + texte[0]);
            Log.notifyPanelMeldung(17, texte[0]);
        } else {
            String zeile = "---------------------------------------";
            System.out.println(". " + zeile);
            Log.notifyPanelMeldung(17, zeile);
            for (int i = 0; i < texte.length; ++i) {
                String txt = "| " + texte[i];
                System.out.println(". " + txt);
                if (i == 0) {
                    Log.notifyPanelMeldung(17, texte[i]);
                    continue;
                }
                Log.notifyPanelMeldung(17, "    " + texte[i]);
            }
            Log.notifyPanelMeldung(17, " ");
            System.out.println(". " + zeile);
        }
    }

    private static void playermeldung(String[] texte) {
        String z = "  >>";
        System.out.println("  >> " + texte[0]);
        Log.notifyPanelMeldung(18, texte[0]);
        for (int i = 1; i < texte.length; ++i) {
            System.out.println("  >> " + texte[i]);
            Log.notifyPanelMeldung(18, texte[i]);
        }
    }

    public static void clearText(int art) {
        if (art == 16) {
            zeilenNrFehler = 0;
            textFehler.setLength(0);
        } else if (art == 17) {
            zeilenNrSystem = 0;
            textSystem.setLength(0);
        } else if (art == 18) {
            zeilenNrProgramm = 0;
            textProgramm.setLength(0);
        }
    }

    private static void notifyPanelMeldung(int art, String zeile) {
        if (art == 16) {
            Log.addText(textFehler, "[" + Log.getNr(zeilenNrFehler++) + "]   " + zeile);
        } else if (art == 17) {
            Log.addText(textSystem, "[" + Log.getNr(zeilenNrSystem++) + "]   " + zeile);
        } else if (art == 18) {
            Log.addText(textProgramm, "[" + Log.getNr(zeilenNrProgramm++) + "]   " + zeile);
        }
        Log.notifyPanel(art);
    }

    private static void notifyPanel(int art) {
        final int a = art;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                if (art == 16 && panelMeldungenFehler != null) {
                    panelMeldungenFehler.notifyPanel();
                } else if (art == 17 && panelMeldungenSystem != null) {
                    panelMeldungenSystem.notifyPanel();
                } else if (art == 18 && panelMeldungenPlayer != null) {
                    panelMeldungenPlayer.notifyPanel();
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (a == 16 && panelMeldungenFehler != null) {
                            panelMeldungenFehler.notifyPanel();
                        } else if (a == 17 && panelMeldungenSystem != null) {
                            panelMeldungenSystem.notifyPanel();
                        } else if (a == 18 && panelMeldungenPlayer != null) {
                            panelMeldungenPlayer.notifyPanel();
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(698989743, ex);
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    private static String getNr(int nr) {
        int MAX_STELLEN = 5;
        String FUELL_ZEICHEN = "0";
        String str = String.valueOf(nr);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str;
    }

    private static void addText(StringBuffer text, String texte) {
        Log.cut(text);
        text.append(texte);
        text.append(System.getProperty("line.separator"));
    }

    private static void cut(StringBuffer buffer) {
        if (buffer.length() > 50000) {
            buffer.delete(0, 30000);
        }
    }
}

